/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.datanucleus.sco.backed.List;

public final class Utilities {
    public static String HADOOP_LOCAL_FS = "file:///";
    private static Map<String, MapredWork> gWorkMap = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = LogFactory.getLog((String)Utilities.class.getName());
    public static TableDesc defaultTd = PlanUtils.getDefaultTableDesc("1");
    public static final int newLineCode = 10;
    public static final int tabCode = 9;
    public static final int ctrlaCode = 1;
    public static final String INDENT = "  ";
    public static String nullStringStorage = "\\N";
    public static String nullStringOutput = "NULL";
    public static Random randGen = new Random();
    public static final String NSTR = "";
    private static final String tmpPrefix = "_tmp.";
    private static Pattern fileNameTaskIdRegex = Pattern.compile("^.*?([0-9]+)(_[0-9])?(\\..*)?$");
    public static String suffix = ".hashtable";

    private Utilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMapRedWork(Configuration job) {
        try {
            Path planPath = new Path(HiveConf.getVar(job, HiveConf.ConfVars.PLAN));
            FileSystem fs = planPath.getFileSystem(job);
            if (fs.exists(planPath)) {
                try {
                    fs.delete(planPath, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            String jobID = Utilities.getHiveJobID(job);
            if (jobID != null) {
                gWorkMap.remove(jobID);
            }
        }
    }

    public static MapredWork getMapRedWork(Configuration job) {
        MapredWork gWork = null;
        try {
            String jobID = Utilities.getHiveJobID(job);
            assert (jobID != null);
            gWork = gWorkMap.get(jobID);
            if (gWork == null) {
                MapredWork ret;
                String path;
                String jtConf = HiveConf.getVar(job, HiveConf.ConfVars.HADOOPJT);
                if (jtConf.equals("local")) {
                    String planPath = HiveConf.getVar(job, HiveConf.ConfVars.PLAN);
                    path = new Path(planPath).toUri().getPath();
                } else {
                    path = "HIVE_PLAN" + jobID;
                }
                FileInputStream in = new FileInputStream(path);
                gWork = ret = Utilities.deserializeMapRedWork(in, job);
                gWork.initialize();
                gWorkMap.put(jobID, gWork);
            }
            return gWork;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static java.util.List<String> getFieldSchemaString(java.util.List<FieldSchema> fl) {
        if (fl == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (FieldSchema f : fl) {
            ret.add(f.getName() + " " + f.getType() + (f.getComment() != null ? " " + f.getComment() : NSTR));
        }
        return ret;
    }

    public static void setMapRedWork(Configuration job, MapredWork w, String hiveScratchDir) {
        try {
            String jobID = UUID.randomUUID().toString();
            Path planPath = new Path(hiveScratchDir, jobID);
            HiveConf.setVar(job, HiveConf.ConfVars.PLAN, planPath.toUri().toString());
            FileSystem fs = planPath.getFileSystem(job);
            FSDataOutputStream out = fs.create(planPath);
            Utilities.serializeMapRedWork(w, (OutputStream)out);
            if (!HiveConf.getVar(job, HiveConf.ConfVars.HADOOPJT).equals("local")) {
                DistributedCache.createSymlink((Configuration)job);
                String uriWithLink = planPath.toUri().toString() + "#HIVE_PLAN" + jobID;
                DistributedCache.addCacheFile((URI)new URI(uriWithLink), (Configuration)job);
                short replication = (short)job.getInt("mapred.submit.replication", 10);
                fs.setReplication(planPath, replication);
            }
            w.initialize();
            gWorkMap.put(jobID, w);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String getHiveJobID(Configuration job) {
        String planPath = HiveConf.getVar(job, HiveConf.ConfVars.PLAN);
        if (planPath != null) {
            return new Path(planPath).getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeExpression(ExprNodeDesc expr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(baos);
        try {
            encoder.writeObject(expr);
        }
        finally {
            encoder.close();
        }
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExprNodeDesc deserializeExpression(String s, Configuration conf) {
        byte[] bytes;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        XMLDecoder decoder = new XMLDecoder(bais, null, null, conf.getClassLoader());
        try {
            ExprNodeDesc expr;
            ExprNodeDesc exprNodeDesc = expr = (ExprNodeDesc)decoder.readObject();
            return exprNodeDesc;
        }
        finally {
            decoder.close();
        }
    }

    public static void serializeTasks(Task<? extends Serializable> t, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
        e.setPersistenceDelegate(Operator.ProgressCounter.class, new EnumDelegate());
        e.writeObject(t);
        e.close();
    }

    public static void serializeQueryPlan(QueryPlan plan, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                LOG.warn((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                throw new RuntimeException("Cannot serialize the query plan", e);
            }
        });
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
        e.setPersistenceDelegate(Operator.ProgressCounter.class, new EnumDelegate());
        e.setPersistenceDelegate(org.datanucleus.sco.backed.Map.class, new MapDelegate());
        e.setPersistenceDelegate(List.class, new ListDelegate());
        e.writeObject(plan);
        e.close();
    }

    public static QueryPlan deserializeQueryPlan(InputStream in, Configuration conf) {
        XMLDecoder d = new XMLDecoder(in, null, null, conf.getClassLoader());
        QueryPlan ret = (QueryPlan)d.readObject();
        d.close();
        return ret;
    }

    public static void serializeMapRedWork(MapredWork w, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
        e.writeObject(w);
        e.close();
    }

    public static MapredWork deserializeMapRedWork(InputStream in, Configuration conf) {
        XMLDecoder d = new XMLDecoder(in, null, null, conf.getClassLoader());
        MapredWork ret = (MapredWork)d.readObject();
        d.close();
        return ret;
    }

    public static void serializeMapRedLocalWork(MapredLocalWork w, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
        e.writeObject(w);
        e.close();
    }

    public static MapredLocalWork deserializeMapRedLocalWork(InputStream in, Configuration conf) {
        XMLDecoder d = new XMLDecoder(in, null, null, conf.getClassLoader());
        MapredLocalWork ret = (MapredLocalWork)d.readObject();
        d.close();
        return ret;
    }

    public static String getTaskId(Configuration hconf) {
        String taskid;
        String string = taskid = hconf == null ? null : hconf.get("mapred.task.id");
        if (taskid == null || taskid.equals(NSTR)) {
            return NSTR + Math.abs(randGen.nextInt());
        }
        String ret = taskid.replaceAll(".*_[mr]_", NSTR).replaceAll(".*_(map|reduce)_", NSTR);
        return ret;
    }

    public static HashMap makeMap(Object ... olist) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        for (int i = 0; i < olist.length; i += 2) {
            ret.put(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static Properties makeProperties(String ... olist) {
        Properties ret = new Properties();
        for (int i = 0; i < olist.length; i += 2) {
            ret.setProperty(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static ArrayList makeList(Object ... olist) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object element : olist) {
            ret.add(element);
        }
        return ret;
    }

    public static TableDesc getTableDesc(Table tbl) {
        return new TableDesc(tbl.getDeserializer().getClass(), tbl.getInputFormatClass(), tbl.getOutputFormatClass(), tbl.getSchema());
    }

    public static TableDesc getTableDesc(String cols, String colTypes) {
        return new TableDesc(LazySimpleSerDe.class, SequenceFileInputFormat.class, HiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", cols, "columns.types", colTypes));
    }

    public static PartitionDesc getPartitionDesc(Partition part) throws HiveException {
        return new PartitionDesc(part);
    }

    public static void addMapWork(MapredWork mr, Table tbl, String alias, Operator<?> work) {
        mr.addMapWork(tbl.getDataLocation().getPath(), alias, work, new PartitionDesc(Utilities.getTableDesc(tbl), null));
    }

    private static String getOpTreeSkel_helper(Operator<?> op, String indent) {
        if (op == null) {
            return NSTR;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(op.toString());
        sb.append("\n");
        if (op.getChildOperators() != null) {
            for (Operator<Serializable> child : op.getChildOperators()) {
                sb.append(Utilities.getOpTreeSkel_helper(child, indent + INDENT));
            }
        }
        return sb.toString();
    }

    public static String getOpTreeSkel(Operator<?> op) {
        return Utilities.getOpTreeSkel_helper(op, NSTR);
    }

    private static boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    public static boolean contentsEqual(InputStream is1, InputStream is2, boolean ignoreWhitespace) throws IOException {
        try {
            int c2;
            int c1;
            if (is1 == is2 || is1 == null && is2 == null) {
                return true;
            }
            if (is1 == null || is2 == null) {
                return false;
            }
            do {
                c1 = is1.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c1)) {
                    c1 = is1.read();
                }
                c2 = is2.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c2)) {
                    c2 = is2.read();
                }
                if (c1 != -1 || c2 != -1) continue;
                return true;
            } while (c1 == c2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String abbreviate(String str, int max) {
        str = str.trim();
        int len = str.length();
        int suffixlength = 20;
        if (len <= max) {
            return str;
        }
        suffixlength = Math.min(suffixlength, (max - 3) / 2);
        String rev = StringUtils.reverse(str);
        String suffix = WordUtils.abbreviate(rev, 0, suffixlength, NSTR);
        suffix = StringUtils.reverse(suffix);
        String prefix = StringUtils.abbreviate(str, max - suffix.length());
        return prefix + suffix;
    }

    public static StreamStatus readColumn(DataInput in, OutputStream out) throws IOException {
        while (true) {
            byte b;
            try {
                b = in.readByte();
            }
            catch (EOFException e) {
                return StreamStatus.EOF;
            }
            if (b == 10) {
                return StreamStatus.TERMINATED;
            }
            out.write(b);
        }
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createCompressedStream(jc, out, isCompressed);
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out, boolean isCompressed) throws IOException {
        if (isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
            return codec.createOutputStream(out);
        }
        return out;
    }

    public static String getFileExtension(JobConf jc, boolean isCompressed) {
        if (!isCompressed) {
            return NSTR;
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        return codec.getDefaultExtension();
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createSequenceWriter(jc, fs, file, keyClass, valClass, isCompressed);
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass, boolean isCompressed) throws IOException {
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        Class codecClass = null;
        if (isCompressed) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType((JobConf)jc);
            codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        }
        return SequenceFile.createWriter((FileSystem)fs, (Configuration)jc, (Path)file, keyClass, valClass, (SequenceFile.CompressionType)compressionType, codec);
    }

    public static RCFile.Writer createRCFileWriter(JobConf jc, FileSystem fs, Path file, boolean isCompressed) throws IOException {
        CompressionCodec codec = null;
        Class codecClass = null;
        if (isCompressed) {
            codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        }
        return new RCFile.Writer(fs, (Configuration)jc, file, null, codec);
    }

    public static String realFile(String newFile, Configuration conf) throws IOException {
        Path path = new Path(newFile);
        URI pathURI = path.toUri();
        Object fs = pathURI.getScheme() == null ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem(conf);
        if (!fs.exists(path)) {
            return null;
        }
        try {
            fs.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String file = path.makeQualified((FileSystem)fs).toString();
        if (StringUtils.startsWith(file, "file:/") && !StringUtils.startsWith(file, "file:///")) {
            file = "file:///" + file.substring("file:/".length());
        }
        return file;
    }

    public static java.util.List<String> mergeUniqElems(java.util.List<String> src, java.util.List<String> dest) {
        if (dest == null) {
            return src;
        }
        if (src == null) {
            return dest;
        }
        for (int pos = 0; pos < dest.size(); ++pos) {
            if (src.contains(dest.get(pos))) continue;
            src.add(dest.get(pos));
        }
        return src;
    }

    public static Path toTempPath(Path orig) {
        if (orig.getName().indexOf(tmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), tmpPrefix + orig.getName());
    }

    public static Path toTempPath(String orig) {
        return Utilities.toTempPath(new Path(orig));
    }

    public static boolean isTempPath(FileStatus file) {
        String name = file.getPath().getName();
        return name.startsWith("_task") || name.startsWith(tmpPrefix);
    }

    public static void rename(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.rename(src, dst)) {
            throw new HiveException("Unable to move: " + src + " to: " + dst);
        }
    }

    public static void renameOrMoveFiles(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.exists(dst)) {
            if (!fs.rename(src, dst)) {
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        } else {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(src)) {
                Path srcFilePath = file.getPath();
                String fileName = srcFilePath.getName();
                Path dstFilePath = new Path(dst, fileName);
                if (fs.exists(dstFilePath)) {
                    int suffix = 0;
                    while (fs.exists(dstFilePath = new Path(dst, fileName + "_" + ++suffix))) {
                    }
                }
                if (fs.rename(srcFilePath, dstFilePath)) continue;
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        }
    }

    public static String getTaskIdFromFilename(String filename) {
        Matcher m;
        String taskId = filename;
        int dirEnd = filename.lastIndexOf("/");
        if (dirEnd != -1) {
            taskId = filename.substring(dirEnd + 1);
        }
        if (!(m = fileNameTaskIdRegex.matcher(taskId)).matches()) {
            LOG.warn((Object)("Unable to get task id from file name: " + filename + ". Using last component" + taskId + " as task id."));
        } else {
            taskId = m.group(1);
        }
        LOG.debug((Object)("TaskId for " + filename + " = " + taskId));
        return taskId;
    }

    public static String replaceTaskIdFromFilename(String filename, int bucketNum) {
        String taskId = Utilities.getTaskIdFromFilename(filename);
        String newTaskId = Utilities.replaceTaskId(taskId, bucketNum);
        String ret = Utilities.replaceTaskIdFromFilename(filename, taskId, newTaskId);
        return ret;
    }

    private static String replaceTaskId(String taskId, int bucketNum) {
        String strBucketNum = String.valueOf(bucketNum);
        int bucketNumLen = strBucketNum.length();
        int taskIdLen = taskId.length();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < taskIdLen - bucketNumLen; ++i) {
            s.append("0");
        }
        return s.toString() + strBucketNum;
    }

    private static String replaceTaskIdFromFilename(String filename, String oldTaskId, String newTaskId) {
        String[] spl = filename.split(oldTaskId);
        if (spl.length == 0 || spl.length == 1) {
            return filename.replaceAll(oldTaskId, newTaskId);
        }
        StringBuffer snew = new StringBuffer();
        for (int idx = 0; idx < spl.length - 1; ++idx) {
            if (idx > 0) {
                snew.append(oldTaskId);
            }
            snew.append(spl[idx]);
        }
        snew.append(newTaskId);
        snew.append(spl[spl.length - 1]);
        return snew.toString();
    }

    public static FileStatus[] getFileStatusRecurse(Path path, int level, FileSystem fs) throws IOException {
        StringBuilder sb = new StringBuilder(path.toUri().getPath());
        for (int i = 0; i < level; ++i) {
            sb.append("/").append("*");
        }
        Path pathPattern = new Path(path, sb.toString());
        return fs.globStatus(pathPattern);
    }

    public static void removeTempOrDuplicateFiles(FileSystem fs, Path path) throws IOException {
        Utilities.removeTempOrDuplicateFiles(fs, path, null);
    }

    public static ArrayList<String> removeTempOrDuplicateFiles(FileSystem fs, Path path, DynamicPartitionCtx dpCtx) throws IOException {
        if (path == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (dpCtx != null) {
            FileStatus[] parts = Utilities.getFileStatusRecurse(path, dpCtx.getNumDPCols(), fs);
            HashMap<String, FileStatus> taskIDToFile = null;
            for (int i = 0; i < parts.length; ++i) {
                assert (parts[i].isDir()) : "dynamic partition " + parts[i].getPath() + " is not a direcgtory";
                FileStatus[] items = fs.listStatus(parts[i].getPath());
                if (items.length == 0 && !fs.delete(parts[i].getPath(), true)) {
                    LOG.error((Object)("Cannot delete empty directory " + parts[i].getPath()));
                    throw new IOException("Cannot delete empty directory " + parts[i].getPath());
                }
                taskIDToFile = Utilities.removeTempOrDuplicateFiles(items, fs);
                if (dpCtx.getNumBuckets() <= 0 || taskIDToFile == null) continue;
                items = fs.listStatus(parts[i].getPath());
                String taskID1 = taskIDToFile.keySet().iterator().next();
                Path bucketPath = taskIDToFile.values().iterator().next().getPath();
                for (int j = 0; j < dpCtx.getNumBuckets(); ++j) {
                    String taskID2 = Utilities.replaceTaskId(taskID1, j);
                    if (taskIDToFile.containsKey(taskID2)) continue;
                    String path2 = Utilities.replaceTaskIdFromFilename(bucketPath.toUri().getPath().toString(), j);
                    result.add(path2);
                }
            }
        } else {
            FileStatus[] items = fs.listStatus(path);
            Utilities.removeTempOrDuplicateFiles(items, fs);
        }
        return result;
    }

    public static HashMap<String, FileStatus> removeTempOrDuplicateFiles(FileStatus[] items, FileSystem fs) throws IOException {
        if (items == null || fs == null) {
            return null;
        }
        HashMap<String, FileStatus> taskIdToFile = new HashMap<String, FileStatus>();
        for (FileStatus one : items) {
            if (Utilities.isTempPath(one)) {
                if (fs.delete(one.getPath(), true)) continue;
                throw new IOException("Unable to delete tmp file: " + one.getPath());
            }
            String taskId = Utilities.getTaskIdFromFilename(one.getPath().getName());
            FileStatus otherFile = taskIdToFile.get(taskId);
            if (otherFile == null) {
                taskIdToFile.put(taskId, one);
                continue;
            }
            FileStatus toDelete = null;
            if (otherFile.getLen() >= one.getLen()) {
                toDelete = one;
            } else {
                toDelete = otherFile;
                taskIdToFile.put(taskId, one);
            }
            long len1 = toDelete.getLen();
            long len2 = taskIdToFile.get(taskId).getLen();
            if (!fs.delete(toDelete.getPath(), true)) {
                throw new IOException("Unable to delete duplicate file: " + toDelete.getPath() + ". Existing file: " + taskIdToFile.get(taskId).getPath());
            }
            LOG.warn((Object)("Duplicate taskid file removed: " + toDelete.getPath() + " with length " + len1 + ". Existing file: " + taskIdToFile.get(taskId).getPath() + " with length " + len2));
        }
        return taskIdToFile;
    }

    public static String getNameMessage(Exception e) {
        return e.getClass().getName() + "(" + e.getMessage() + ")";
    }

    public static ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        URLClassLoader loader = (URLClassLoader)cloader;
        java.util.List<URL> curPath = Arrays.asList(loader.getURLs());
        ArrayList<URL> newPath = new ArrayList<URL>();
        for (URL onePath : curPath) {
            newPath.add(onePath);
        }
        curPath = newPath;
        for (String onestr : newPaths) {
            URL oneurl;
            if (StringUtils.indexOf(onestr, "file://") == 0) {
                onestr = StringUtils.substring(onestr, 7);
            }
            if (curPath.contains(oneurl = new File(onestr).toURL())) continue;
            curPath.add(oneurl);
        }
        return new URLClassLoader(curPath.toArray(new URL[0]), (ClassLoader)loader);
    }

    public static void removeFromClassPath(String[] pathsToRemove) throws Exception {
        Thread curThread = Thread.currentThread();
        URLClassLoader loader = (URLClassLoader)curThread.getContextClassLoader();
        HashSet<URL> newPath = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        for (String onestr : pathsToRemove) {
            if (StringUtils.indexOf(onestr, "file://") == 0) {
                onestr = StringUtils.substring(onestr, 7);
            }
            URL oneurl = new File(onestr).toURL();
            newPath.remove(oneurl);
        }
        loader = new URLClassLoader(newPath.toArray(new URL[0]));
        curThread.setContextClassLoader(loader);
    }

    public static String formatBinaryString(byte[] array, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            sb.append("x");
            sb.append(array[i] < 0 ? array[i] + 256 : array[i] + 0);
        }
        return sb.toString();
    }

    public static java.util.List<String> getColumnNamesFromSortCols(java.util.List<Order> sortCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (Order o : sortCols) {
            names.add(o.getCol());
        }
        return names;
    }

    public static java.util.List<String> getColumnNamesFromFieldSchema(java.util.List<FieldSchema> partCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (FieldSchema o : partCols) {
            names.add(o.getName());
        }
        return names;
    }

    public static java.util.List<String> getColumnNames(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns");
        String[] cols = colNames.trim().split(",");
        if (cols != null) {
            for (String col : cols) {
                if (col == null || col.trim().equals(NSTR)) continue;
                names.add(col);
            }
        }
        return names;
    }

    public static java.util.List<String> getColumnTypes(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns.types");
        String[] cols = colNames.trim().split(",");
        if (cols != null) {
            for (String col : cols) {
                if (col == null || col.trim().equals(NSTR)) continue;
                names.add(col);
            }
        }
        return names;
    }

    public static void validateColumnNames(java.util.List<String> colNames, java.util.List<String> checkCols) throws SemanticException {
        for (String toCheck : checkCols) {
            boolean found = false;
            for (String colName : colNames) {
                if (!toCheck.equalsIgnoreCase(colName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
        }
    }

    public static int getDefaultNotificationInterval(Configuration hconf) {
        Integer expInterval = Integer.decode(hconf.get("mapred.tasktracker.expiry.interval"));
        int notificationInterval = expInterval != null ? expInterval / 2 : 300000;
        return notificationInterval;
    }

    public static void copyTableJobPropertiesToConf(TableDesc tbl, JobConf job) {
        Map<String, String> jobProperties = tbl.getJobProperties();
        if (jobProperties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
            job.set(entry.getKey(), entry.getValue());
        }
    }

    public static ContentSummary getInputSummary(Context ctx, MapredWork work, PathFilter filter) throws IOException {
        long[] summary = new long[]{0L, 0L, 0L};
        for (String path : work.getPathToAliases().keySet()) {
            try {
                Path p = new Path(path);
                if (filter != null && !filter.accept(p)) continue;
                ContentSummary cs = ctx.getCS(path);
                if (cs == null) {
                    JobConf jobConf = new JobConf(ctx.getConf());
                    PartitionDesc partDesc = work.getPathToPartitionInfo().get(p.toString());
                    Class<? extends InputFormat> inputFormatCls = partDesc.getInputFileFormatClass();
                    InputFormat<WritableComparable, Writable> inputFormatObj = HiveInputFormat.getInputFormatFromCache(inputFormatCls, jobConf);
                    if (inputFormatObj instanceof ContentSummaryInputFormat) {
                        cs = ((ContentSummaryInputFormat)inputFormatObj).getContentSummary(p, jobConf);
                    } else {
                        FileSystem fs = p.getFileSystem(ctx.getConf());
                        cs = fs.getContentSummary(p);
                    }
                    ctx.addCS(path, cs);
                }
                summary[0] = summary[0] + cs.getLength();
                summary[1] = summary[1] + cs.getFileCount();
                summary[2] = summary[2] + cs.getDirectoryCount();
            }
            catch (IOException e) {
                LOG.info((Object)("Cannot get size of " + path + ". Safely ignored."));
                if (path == null) continue;
                ctx.addCS(path, new ContentSummary(0L, 0L, 0L));
            }
        }
        return new ContentSummary(summary[0], summary[1], summary[2]);
    }

    public static boolean isEmptyPath(JobConf job, Path dirPath) throws Exception {
        FileStatus[] fStats;
        FileSystem inpFs = dirPath.getFileSystem((Configuration)job);
        return !inpFs.exists(dirPath) || (fStats = inpFs.listStatus(dirPath)).length <= 0;
    }

    public static java.util.List<ExecDriver> getMRTasks(java.util.List<Task<? extends Serializable>> tasks) {
        ArrayList<ExecDriver> mrTasks = new ArrayList<ExecDriver>();
        if (tasks != null) {
            Utilities.getMRTasks(tasks, mrTasks);
        }
        return mrTasks;
    }

    private static void getMRTasks(java.util.List<Task<? extends Serializable>> tasks, java.util.List<ExecDriver> mrTasks) {
        for (Task<? extends Serializable> task : tasks) {
            if (task instanceof ExecDriver && !mrTasks.contains((ExecDriver)task)) {
                mrTasks.add((ExecDriver)task);
            }
            if (task.getDependentTasks() == null) continue;
            Utilities.getMRTasks(task.getDependentTasks(), mrTasks);
        }
    }

    public static boolean supportCombineFileInputFormat() {
        return ShimLoader.getHadoopShims().getCombineFileInputFormat() != null;
    }

    public static java.util.List<LinkedHashMap<String, String>> getFullDPSpecs(Configuration conf, DynamicPartitionCtx dpCtx) throws HiveException {
        try {
            Path loadPath = new Path(dpCtx.getRootPath());
            FileSystem fs = loadPath.getFileSystem(conf);
            int numDPCols = dpCtx.getNumDPCols();
            FileStatus[] status = Utilities.getFileStatusRecurse(loadPath, numDPCols, fs);
            if (status.length == 0) {
                LOG.warn((Object)"No partition is genereated by dynamic partitioning");
                return null;
            }
            Map<String, String> partSpec = dpCtx.getPartSpec();
            ArrayList<LinkedHashMap<String, String>> fullPartSpecs = new ArrayList<LinkedHashMap<String, String>>();
            for (int i = 0; i < status.length; ++i) {
                Path partPath = status[i].getPath();
                assert (fs.getFileStatus(partPath).isDir()) : "partitions " + partPath + " is not a directory !";
                LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(partSpec);
                Warehouse.makeSpecFromName(fullPartSpec, (Path)partPath);
                fullPartSpecs.add(fullPartSpec);
            }
            return fullPartSpecs;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public static StatsPublisher getStatsPublisher(JobConf jc) {
        String statsImplementationClass = HiveConf.getVar((Configuration)jc, HiveConf.ConfVars.HIVESTATSDBCLASS);
        if (StatsFactory.setImplementation(statsImplementationClass, (Configuration)jc)) {
            return StatsFactory.getStatsPublisher();
        }
        return null;
    }

    public static void setColumnNameList(JobConf jobConf, Operator op) {
        RowSchema rowSchema = op.getSchema();
        if (rowSchema == null) {
            return;
        }
        StringBuilder columnNames = new StringBuilder();
        for (ColumnInfo colInfo : rowSchema.getSignature()) {
            if (columnNames.length() > 0) {
                columnNames.append(",");
            }
            columnNames.append(colInfo.getInternalName());
        }
        String columnNamesString = columnNames.toString();
        jobConf.set("columns", columnNamesString);
    }

    public static void validatePartSpec(Table tbl, Map<String, String> partSpec) throws SemanticException {
        java.util.List<FieldSchema> parts = tbl.getPartitionKeys();
        HashSet<String> partCols = new HashSet<String>(parts.size());
        for (FieldSchema fieldSchema : parts) {
            partCols.add(fieldSchema.getName());
        }
        for (String string : partSpec.keySet()) {
            if (partCols.contains(string)) continue;
            throw new SemanticException(ErrorMsg.NONEXISTPARTCOL.getMsg(string));
        }
    }

    public static String generatePath(String baseURI, Byte tag, String bigBucketFileName) {
        String path = new String(baseURI + "/" + "MapJoin-" + tag + "-" + bigBucketFileName + suffix);
        return path;
    }

    public static String generateFileName(Byte tag, String bigBucketFileName) {
        String fileName = new String("MapJoin-" + tag + "-" + bigBucketFileName + suffix);
        return fileName;
    }

    public static String generateTmpURI(String baseURI, String id) {
        String tmpFileURI = new String(baseURI + "/" + "HashTable-" + id);
        return tmpFileURI;
    }

    public static String generateTarURI(String baseURI, String filename) {
        String tmpFileURI = new String(baseURI + "/" + filename + ".tar.gz");
        return tmpFileURI;
    }

    public static String generateTarURI(Path baseURI, String filename) {
        String tmpFileURI = new String(baseURI + "/" + filename + ".tar.gz");
        return tmpFileURI;
    }

    public static String generateTarFileName(String name) {
        String tmpFileURI = new String(name + ".tar.gz");
        return tmpFileURI;
    }

    public static String generatePath(Path baseURI, String filename) {
        String path = new String(baseURI + "/" + filename);
        return path;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return sdf.format(cal.getTime());
    }

    public static double showTime(long time) {
        double result = (double)time / 1000.0;
        return result;
    }

    public static enum StreamStatus {
        EOF,
        TERMINATED;

    }

    public static class StreamPrinter
    extends Thread {
        InputStream is;
        String type;
        PrintStream os;

        public StreamPrinter(InputStream is, String type, PrintStream os) {
            this.is = is;
            this.type = type;
            this.os = os;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                if (this.type != null) {
                    while ((line = br.readLine()) != null) {
                        this.os.println(this.type + ">" + line);
                    }
                } else {
                    while ((line = br.readLine()) != null) {
                        this.os.println(line);
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static class Tuple<T, V> {
        private final T one;
        private final V two;

        public Tuple(T one, V two) {
            this.one = one;
            this.two = two;
        }

        public T getOne() {
            return this.one;
        }

        public V getTwo() {
            return this.two;
        }
    }

    public static class CollectionPersistenceDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", null);
        }

        protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
            Iterator ite = ((Collection)oldInstance).iterator();
            while (ite.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{ite.next()}));
            }
        }
    }

    public static class ListDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            java.util.List oldList = (java.util.List)oldInstance;
            ArrayList newList = new ArrayList(oldList);
            return new Expression(newList, ArrayList.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class SetDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Set oldSet = (Set)oldInstance;
            HashSet newSet = new HashSet(oldSet);
            return new Expression(newSet, HashSet.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class MapDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Map oldMap = (Map)oldInstance;
            HashMap newMap = new HashMap(oldMap);
            return new Expression(newMap, HashMap.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class EnumDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(Enum.class, "valueOf", new Object[]{oldInstance.getClass(), ((Enum)oldInstance).name()});
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }
    }

    public static enum ReduceField {
        KEY,
        VALUE,
        ALIAS;

    }
}

