/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.CopyTask;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;

public final class TaskFactory {
    public static ArrayList<taskTuple<? extends Serializable>> taskvec = new ArrayList();
    private static ThreadLocal<Integer> tid;

    public static int getAndIncrementId() {
        int curValue = tid.get();
        tid.set(new Integer(curValue + 1));
        return curValue;
    }

    public static void resetId() {
        tid.set(new Integer(0));
    }

    public static <T extends Serializable> Task<T> get(Class<T> workClass, HiveConf conf) {
        for (taskTuple<? extends Serializable> t : taskvec) {
            if (t.workClass != workClass) continue;
            try {
                Task ret = t.taskClass.newInstance();
                ret.setId("Stage-" + Integer.toString(TaskFactory.getAndIncrementId()));
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No task for work class " + workClass.getName());
    }

    public static <T extends Serializable> Task<T> get(T work, HiveConf conf, Task<? extends Serializable> ... tasklist) {
        Task<?> ret = TaskFactory.get(work.getClass(), conf);
        ret.setWork(work);
        if (tasklist.length == 0) {
            return ret;
        }
        ArrayList<Task<? extends Serializable>> clist = new ArrayList<Task<? extends Serializable>>();
        for (Task<? extends Serializable> tsk : tasklist) {
            clist.add(tsk);
        }
        ret.setChildTasks(clist);
        return ret;
    }

    public static <T extends Serializable> Task<T> getAndMakeChild(T work, HiveConf conf, Task<? extends Serializable> ... tasklist) {
        Task<?> ret = TaskFactory.get(work.getClass(), conf);
        ret.setWork(work);
        if (tasklist.length == 0) {
            return ret;
        }
        TaskFactory.makeChild(ret, tasklist);
        return ret;
    }

    public static void makeChild(Task<?> ret, Task<? extends Serializable> ... tasklist) {
        for (Task<? extends Serializable> tsk : tasklist) {
            List<Task<? extends Serializable>> children = tsk.getChildTasks();
            if (children == null) {
                children = new ArrayList<Task<Serializable>>();
            }
            children.add(ret);
            tsk.setChildTasks(children);
        }
    }

    private TaskFactory() {
    }

    static {
        taskvec.add(new taskTuple<MoveWork>(MoveWork.class, MoveTask.class));
        taskvec.add(new taskTuple<FetchWork>(FetchWork.class, FetchTask.class));
        taskvec.add(new taskTuple<CopyWork>(CopyWork.class, CopyTask.class));
        taskvec.add(new taskTuple<DDLWork>(DDLWork.class, DDLTask.class));
        taskvec.add(new taskTuple<FunctionWork>(FunctionWork.class, FunctionTask.class));
        taskvec.add(new taskTuple<ExplainWork>(ExplainWork.class, ExplainTask.class));
        taskvec.add(new taskTuple<ConditionalWork>(ConditionalWork.class, ConditionalTask.class));
        taskvec.add(new taskTuple<MapredWork>(MapredWork.class, MapRedTask.class));
        taskvec.add(new taskTuple<MapredLocalWork>(MapredLocalWork.class, MapredLocalTask.class));
        taskvec.add(new taskTuple<StatsWork>(StatsWork.class, StatsTask.class));
        tid = new ThreadLocal<Integer>(){

            @Override
            protected synchronized Integer initialValue() {
                return new Integer(0);
            }
        };
    }

    public static final class taskTuple<T extends Serializable> {
        public Class<T> workClass;
        public Class<? extends Task<T>> taskClass;

        public taskTuple(Class<T> workClass, Class<? extends Task<T>> taskClass) {
            this.workClass = workClass;
            this.taskClass = taskClass;
        }
    }
}

