/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class AbstractMapJoinOperator<T extends MapJoinDesc>
extends CommonJoinOperator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Map<Byte, List<ExprNodeEvaluator>> joinKeys;
    protected transient Map<Byte, List<ObjectInspector>> joinKeysObjectInspectors;
    protected transient Map<Byte, List<ObjectInspector>> joinKeysStandardObjectInspectors;
    protected transient int posBigTable = -1;
    transient int mapJoinRowsKey;
    protected transient RowContainer<ArrayList<Object>> emptyList = null;
    transient int numMapRowsRead;
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Mapside join size exceeds hive.mapjoin.maxsize. Please increase that or remove the mapjoin hint."};
    transient boolean firstRow;

    public AbstractMapJoinOperator() {
    }

    public AbstractMapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.numMapRowsRead = 0;
        this.firstRow = true;
        this.joinKeys = new HashMap<Byte, List<ExprNodeEvaluator>>();
        JoinUtil.populateJoinKeyValue(this.joinKeys, ((MapJoinDesc)this.conf).getKeys(), this.order, -1);
        this.joinKeysObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinKeys, this.inputObjInspectors, -1);
        this.joinKeysStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(this.joinKeysObjectInspectors, -1);
        this.posBigTable = ((MapJoinDesc)this.conf).getPosBigTable();
        this.emptyList = new RowContainer(1, hconf);
        RowContainer bigPosRC = JoinUtil.getRowContainer(hconf, (List)this.rowContainerStandardObjectInspectors.get((byte)this.posBigTable), this.order[this.posBigTable], this.joinCacheSize, this.spillTableDesc, (JoinDesc)this.conf, this.noOuterJoin);
        this.storage.put((byte)this.posBigTable, bigPosRC);
        this.mapJoinRowsKey = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINROWSIZE);
        List<? extends StructField> structFields = ((StructObjectInspector)this.outputObjInspector).getAllStructFieldRefs();
        if (((MapJoinDesc)this.conf).getOutputColumnNames().size() < structFields.size()) {
            ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
            for (Byte alias : this.order) {
                int sz = ((MapJoinDesc)this.conf).getExprs().get(alias).size();
                List<Integer> retained = ((MapJoinDesc)this.conf).getRetainList().get(alias);
                for (int i = 0; i < sz; ++i) {
                    int pos = retained.get(i);
                    structFieldObjectInspectors.add(structFields.get(pos).getFieldObjectInspector());
                }
            }
            this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(((MapJoinDesc)this.conf).getOutputColumnNames(), structFieldObjectInspectors);
        }
        this.initializeChildren(hconf);
    }

    @Override
    protected void fatalErrorMessage(StringBuilder errMsg, long counterCode) {
        errMsg.append("Operator " + this.getOperatorId() + " (id=" + this.id + "): " + FATAL_ERR_MSG[(int)counterCode]);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    protected boolean hasAnyNulls(ArrayList<Object> key) {
        if (key != null && key.size() > 0) {
            for (Object k : key) {
                if (k != null) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasAnyNulls(Object[] key) {
        if (key != null && key.length > 0) {
            for (Object k : key) {
                if (k != null) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasAnyNulls(AbstractMapJoinKey key) {
        return key.hasAnyNulls();
    }
}

