/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.MaskDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.SideNavigator;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;

public class DialogDatasource
extends AbstractDialogConfirm {
    public static final short ITEM_NEW = 0;
    public static final short ITEM_MODIFY = 1;
    public static final short ITEM_DUPLICATE = 2;
    private short request;
    private SideNavigator navigator;
    private UoDatasource uoDs;
    private MaskDatasource mDs;
    private JCheckBox cbxConnect;

    public DialogDatasource(SideNavigator navigator, short request) {
        super((Component)Application.window, "datasource." + (request == 1 ? "edit" : "new"));
        this.request = request;
        this.navigator = navigator;
        this.mDs = new MaskDatasource();
        this.getContentPane().add(this.mDs);
        this.cbxConnect = new JCheckBox("connect");
        this.bar.add((Component)this.cbxConnect, 0);
    }

    protected void onOpen() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.navigator.getSelectionPath().getLastPathComponent();
        switch (this.request) {
            case 0: {
                this.uoDs = new UoDatasource((UoDriver)node.getUserObject());
                this.mDs.load(this.uoDs);
                break;
            }
            case 2: {
                UoDriver uoDv = (UoDriver)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                this.uoDs = new UoDatasource(uoDv);
                this.uoDs.url = ((UoDatasource)node.getUserObject()).url;
                this.uoDs.uid = ((UoDatasource)node.getUserObject()).uid;
                this.uoDs.pwd = ((UoDatasource)node.getUserObject()).pwd;
                this.uoDs.schema = ((UoDatasource)node.getUserObject()).schema;
                this.uoDs.remember = ((UoDatasource)node.getUserObject()).remember;
                this.uoDs.auto_connect = ((UoDatasource)node.getUserObject()).auto_connect;
                this.mDs.load(this.uoDs);
                break;
            }
            case 1: {
                this.uoDs = (UoDatasource)node.getUserObject();
                this.mDs.load(this.uoDs);
            }
        }
        this.mDs.setEnabled(!this.uoDs.isConnected());
        this.cbxConnect.setSelected(this.uoDs.isConnected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onConfirm() {
        boolean bContinue = this.mDs.unload(this.uoDs);
        if (bContinue) {
            this.setCursor(new Cursor(3));
            try {
                if (this.cbxConnect.isSelected() && !this.uoDs.isConnected()) {
                    this.uoDs.connect();
                    Application.window.connectionOpened(this.uoDs.getKey());
                } else if (!this.cbxConnect.isSelected() && this.uoDs.isConnected()) {
                    this.uoDs.disconnect();
                    Application.window.connectionClosed(this.uoDs.getKey());
                }
                if (this.request == 1) {
                    this.navigator.reloadSelection();
                } else {
                    this.navigator.add(this.uoDs);
                }
            }
            catch (Exception e) {
                Application.println(e, true);
                bContinue = false;
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
        return bContinue;
    }
}

