/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive;

import com.jaspersoft.hadoop.hive.HiveConnection;
import com.jaspersoft.hadoop.hive.HiveDataSource;
import com.jaspersoft.hadoop.hive.HiveSqlInClause;
import com.jaspersoft.hadoop.hive.HiveSqlNotInClause;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.log4j.Logger;

public class HiveQueryExecuter
extends JRAbstractQueryExecuter {
    private Statement statement;
    protected static final String CLAUSE_ID_IN = "IN";
    protected static final String CLAUSE_ID_NOTIN = "NOTIN";
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(0);
    private static final Logger logger = Logger.getLogger(HiveQueryExecuter.class);

    public HiveQueryExecuter(JRDataset dataset, Map<String, JRValueParameter> parameters) {
        super(dataset, parameters);
        this.registerFunctions();
        this.parseQuery();
    }

    protected void registerFunctions() {
        this.registerClauseFunction(CLAUSE_ID_IN, HiveSqlInClause.getInstance());
        this.registerClauseFunction(CLAUSE_ID_NOTIN, HiveSqlNotInClause.getInstance());
    }

    public boolean cancelQuery() throws JRException {
        try {
            this.statement.cancel();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }

    public void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.statement = null;
        }
    }

    public JRDataSource createDatasource() throws JRException {
        HiveConnection connection = (HiveConnection)((Map)this.getParameterValue("REPORT_PARAMETERS_MAP")).get("com.jaspersoft.hadoop.hive.connection");
        if (connection == null) {
            logger.error((Object)"No Hive connection");
            System.out.println("Testing as default connection");
            connection = (HiveConnection)((Map)this.getParameterValue("REPORT_PARAMETERS_MAP")).get("REPORT_CONNECTION");
            if (connection == null) {
                return null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.statement = null;
        }
        try {
            this.statement = connection.getSqlConnection().createStatement();
            return new HiveDataSource(this.statement.executeQuery(this.getQueryString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }

    protected String getParameterReplacement(String parameterName) {
        JRValueParameter parameter = this.getValueParameter(parameterName);
        Class parameterType = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (parameterValue == null) {
            return "null";
        }
        return HiveQueryExecuter.getParameterReplacement(parameterType, parameterValue);
    }

    public static String getParameterReplacement(Class<?> parameterType, Object parameterValue) {
        if (Boolean.class.isAssignableFrom(parameterType)) {
            return String.valueOf((Boolean)parameterValue);
        }
        if (Byte.class.isAssignableFrom(parameterType)) {
            return "\"" + (Byte)parameterValue + "\"";
        }
        if (Double.class.isAssignableFrom(parameterType)) {
            return String.valueOf(parameterValue);
        }
        if (Float.class.isAssignableFrom(parameterType)) {
            return String.valueOf(parameterValue);
        }
        if (Integer.class.isAssignableFrom(parameterType)) {
            return String.valueOf(parameterValue);
        }
        if (Long.class.isAssignableFrom(parameterType)) {
            return String.valueOf(parameterValue);
        }
        if (Short.class.isAssignableFrom(parameterType)) {
            return String.valueOf(parameterValue);
        }
        if (BigDecimal.class.isAssignableFrom(parameterType)) {
            return String.valueOf(parameterValue);
        }
        if (String.class.isAssignableFrom(parameterType)) {
            return "\"" + String.valueOf(parameterValue) + "\"";
        }
        if (Timestamp.class.isAssignableFrom(parameterType)) {
            return "\"" + DATE_FORMAT.format((Timestamp)parameterValue) + "\"";
        }
        if (Time.class.isAssignableFrom(parameterType)) {
            return "\"" + DATE_FORMAT.format((Time)parameterValue) + "\"";
        }
        if (java.util.Date.class.isAssignableFrom(parameterType)) {
            return "\"" + DATE_FORMAT.format((Date)parameterValue) + "\"";
        }
        return String.valueOf(parameterValue);
    }
}

