/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class JRDataUtils {
    public static final double JULIAN_0000 = 1721424.5;
    public static final double JULIAN_1900 = 2415020.5;

    public static String getLocaleCode(Locale locale) {
        return locale.toString();
    }

    public static Locale getLocale(String code) {
        String country;
        String variant;
        String language;
        int firstSep = code.indexOf(95);
        if (firstSep < 0) {
            language = code;
            variant = "";
            country = "";
        } else {
            language = code.substring(0, firstSep);
            int secondSep = code.indexOf(95, firstSep + 1);
            if (secondSep < 0) {
                country = code.substring(firstSep + 1);
                variant = "";
            } else {
                country = code.substring(firstSep + 1, secondSep);
                variant = code.substring(secondSep + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static String getTimeZoneId(TimeZone tz) {
        return tz.getID();
    }

    public static TimeZone getTimeZone(String id) {
        return TimeZone.getTimeZone(id);
    }

    public static double getExcelSerialDayNumber(Date date, Locale locale, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone, locale);
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        double result = JRDataUtils.getGregorianToJulianDay(year, month + 1, day) + Math.floor((double)(sec + 60 * (min + 60 * hour)) + 0.5) / 86400.0;
        return result - 2415020.5 + 1.0 + (double)(result > 2415078.5 ? 1 : 0);
    }

    public static double getGregorianToJulianDay(int year, int month, int day) {
        return 1721424.5 + (double)(365 * (year - 1)) + Math.floor((year - 1) / 4) - Math.floor((year - 1) / 100) + Math.floor((year - 1) / 400) + Math.floor((367 * month - 362) / 12 + (month <= 2 ? 0 : (JRDataUtils.isLeapYear(year) ? -1 : -2)) + day);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static Date translateToTimezone(Date value, TimeZone tz) {
        if (tz == null) {
            return value;
        }
        TimeZone defaultTz = TimeZone.getDefault();
        if (defaultTz.hasSameRules(tz)) {
            return value;
        }
        long time = value.getTime();
        Date adjustedDate = new Date(time + (long)tz.getOffset(time) - (long)defaultTz.getOffset(time));
        return adjustedDate;
    }

    private JRDataUtils() {
    }
}

