/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatUtils {
    public static Number getFormattedNumber(NumberFormat numberFormat, String fieldValue, Class<?> valueClass) throws ParseException {
        if (valueClass.equals(Byte.class)) {
            return new Byte(numberFormat.parse(fieldValue).byteValue());
        }
        if (valueClass.equals(Integer.class)) {
            return numberFormat.parse(fieldValue).intValue();
        }
        if (valueClass.equals(Long.class)) {
            return new Long(numberFormat.parse(fieldValue).longValue());
        }
        if (valueClass.equals(Short.class)) {
            return new Short(numberFormat.parse(fieldValue).shortValue());
        }
        if (valueClass.equals(Double.class)) {
            return new Double(numberFormat.parse(fieldValue).doubleValue());
        }
        if (valueClass.equals(Float.class)) {
            return new Float(numberFormat.parse(fieldValue).floatValue());
        }
        if (valueClass.equals(BigDecimal.class)) {
            return new BigDecimal(numberFormat.parse(fieldValue).toString());
        }
        if (valueClass.equals(BigInteger.class)) {
            return new BigInteger(String.valueOf(numberFormat.parse(fieldValue).longValue()));
        }
        if (valueClass.equals(Number.class)) {
            return numberFormat.parse(fieldValue);
        }
        return null;
    }

    public static Date getFormattedDate(DateFormat dateFormat, String fieldValue, Class<?> valueClass) throws ParseException {
        if (valueClass.equals(Date.class)) {
            return dateFormat.parse(fieldValue);
        }
        if (valueClass.equals(Timestamp.class)) {
            return new Timestamp(dateFormat.parse(fieldValue).getTime());
        }
        if (valueClass.equals(Time.class)) {
            return new Time(dateFormat.parse(fieldValue).getTime());
        }
        return null;
    }
}

