/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.TabSegment;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRProperties;

public class PdfTextRenderer
extends AbstractTextRenderer {
    private JRPdfExporter pdfExporter;
    private PdfContentByte pdfContentByte;
    private int horizontalAlignment;
    private float leftOffsetFactor;
    private float rightOffsetFactor;

    public static PdfTextRenderer getInstance() {
        return new PdfTextRenderer(JRProperties.getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
    }

    public PdfTextRenderer(boolean ignoreMissingFont) {
        super(false, ignoreMissingFont);
    }

    public void initialize(JRPdfExporter pdfExporter, PdfContentByte pdfContentByte, JRPrintText text, int offsetX, int offsetY) {
        this.pdfExporter = pdfExporter;
        this.pdfContentByte = pdfContentByte;
        this.horizontalAlignment = 0;
        this.leftOffsetFactor = 0.0f;
        this.rightOffsetFactor = 0.0f;
        switch (text.getHorizontalAlignmentValue()) {
            case JUSTIFIED: {
                this.horizontalAlignment = 8;
                this.leftOffsetFactor = 0.0f;
                this.rightOffsetFactor = 0.0f;
                break;
            }
            case RIGHT: {
                this.horizontalAlignment = text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 0;
                this.leftOffsetFactor = -0.2f;
                this.rightOffsetFactor = 0.0f;
                break;
            }
            case CENTER: {
                this.horizontalAlignment = 1;
                this.leftOffsetFactor = -0.1f;
                this.rightOffsetFactor = 0.1f;
                break;
            }
            default: {
                this.horizontalAlignment = text.getRunDirectionValue() == RunDirectionEnum.LTR ? 0 : 2;
                this.leftOffsetFactor = 0.0f;
                this.rightOffsetFactor = 0.2f;
            }
        }
        super.initialize(text, offsetX, offsetY);
    }

    public void draw() {
        TabSegment segment = (TabSegment)this.segments.get(this.segmentIndex);
        float advance = segment.layout.getAdvance();
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(this.pdfExporter.getPhrase(segment.as, segment.text, this.text), (float)this.x + this.drawPosX + this.leftOffsetFactor * advance, (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset + this.lineHeight - this.drawPosY, (float)this.x + this.drawPosX + segment.layout.getAdvance() + this.rightOffsetFactor * advance, (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - 400.0f - this.drawPosY, 0.0f, this.horizontalAlignment);
        colText.setLeading(this.lineHeight);
        colText.setRunDirection(this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 3);
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
    }
}

