/*
 * Decompiled with CFR 0.152.
 */
package mondrian.recorder;

import java.io.PrintStream;
import mondrian.olap.Util;
import mondrian.recorder.AbstractRecorder;

public class PrintStreamRecorder
extends AbstractRecorder {
    private final PrintStream err;
    private final PrintStream out;

    public PrintStreamRecorder() {
        this(System.out, System.err);
    }

    public PrintStreamRecorder(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    protected void recordMessage(String msg, Object info, AbstractRecorder.MsgType msgType) {
        PrintStream ps;
        String prefix;
        switch (msgType) {
            case INFO: {
                prefix = "INFO: ";
                ps = this.out;
                break;
            }
            case WARN: {
                prefix = "WARN: ";
                ps = this.out;
                break;
            }
            case ERROR: {
                prefix = "ERROR: ";
                ps = this.err;
                break;
            }
            default: {
                throw Util.unexpected(msgType);
            }
        }
        String context = this.getContext();
        ps.print(prefix);
        ps.print(context);
        ps.print(": ");
        ps.println(msg);
    }
}

