/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;

public final class InnerClass {
    ClassName name;
    ClassName outerClassName;
    String simpleName;
    int access;

    static InnerClass[] loadInnerClasses(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        InnerClass[] innerClassArray = new InnerClass[n];
        for (int i = 0; i < n; ++i) {
            innerClassArray[i] = new InnerClass(dataInputStream, constantPool);
        }
        return innerClassArray;
    }

    InnerClass(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.loadInnerClass(dataInputStream, constantPool);
    }

    private void loadInnerClass(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.name = n > 0 ? constantPool.getClass(n).getClassName() : null;
        n = dataInputStream.readUnsignedShort();
        this.outerClassName = n > 0 ? constantPool.getClass(n).getClassName() : null;
        n = dataInputStream.readUnsignedShort();
        if (n > 0) {
            CPUTF8Info cPUTF8Info = (CPUTF8Info)constantPool.get(n);
            this.simpleName = cPUTF8Info.getName();
        }
        this.access = dataInputStream.readUnsignedShort();
    }

    public final ClassName getName() {
        return this.name;
    }

    public final ClassName getOuterClassName() {
        return this.outerClassName;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final int getAccess() {
        return this.access;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("innerclass=");
        stringBuffer.append(this.name);
        if (this.simpleName != null) {
            stringBuffer.append(" (");
            stringBuffer.append(this.simpleName);
            stringBuffer.append(')');
        }
        stringBuffer.append(", outerclass=");
        stringBuffer.append(this.outerClassName);
        return stringBuffer.toString();
    }
}

