/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.comp;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mondrian.olap.Util;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.XOMUtil;
import org.eigenbase.xom.wrappers.W3CDOMWrapper;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLUtility {
    static final Pattern WhitespacePattern = Pattern.compile("\\s*");

    XMLUtility() {
    }

    public static DocumentBuilder createDomParser(boolean validate, boolean ignoreIgnorableWhitespace, boolean usingSchema, ErrorHandler handler) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            factory.setIgnoringElementContentWhitespace(ignoreIgnorableWhitespace);
            factory.setValidating(validate);
            if (usingSchema) {
                factory.setAttribute("http://xml.org/sax/features/validation", Boolean.TRUE);
                factory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
                factory.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", Boolean.TRUE);
                factory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
            }
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            if (handler != null) {
                documentBuilder.setErrorHandler(handler);
            }
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    public static Document getDocument(File file) throws IOException, SAXException {
        DocumentBuilder builder = XMLUtility.createDomParser(true, true, true, new UtilityErrorHandler());
        Document result = builder.parse(file);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Writer writer, Document document) throws IOException {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setIndenting(true);
        outputFormat.setLineWidth(Integer.MAX_VALUE);
        outputFormat.setLineSeparator(Util.nl);
        try {
            XMLSerializer serializer = new XMLSerializer(writer, outputFormat);
            serializer.serialize(document);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static String decodeEncodedString(String enc) {
        if (enc.indexOf(38) == -1) {
            return enc;
        }
        int len = enc.length();
        StringBuilder result = new StringBuilder(len);
        for (int idx = 0; idx < len; ++idx) {
            char ch = enc.charAt(idx);
            if (ch == '&' && enc.charAt(idx + 1) == 'l' && enc.charAt(idx + 2) == 't' && enc.charAt(idx + 3) == ';') {
                result.append('<');
                idx += 3;
                continue;
            }
            if (ch == '&' && enc.charAt(idx + 1) == 'g' && enc.charAt(idx + 2) == 't' && enc.charAt(idx + 3) == ';') {
                result.append('>');
                idx += 3;
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static void stripWhitespace(Element element) {
        NodeList childNodeList = element.getChildNodes();
        block4: for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node node = childNodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    String text = ((CharacterData)node).getData();
                    if (!WhitespacePattern.matcher(text).matches()) continue block4;
                    element.removeChild(node);
                    --i;
                    continue block4;
                }
                case 1: {
                    XMLUtility.stripWhitespace((Element)node);
                }
            }
        }
    }

    public static String toString(Element xmlRoot) {
        XMLUtility.stripWhitespace(xmlRoot);
        return XOMUtil.wrapperToXml((DOMWrapper)new W3CDOMWrapper((Node)xmlRoot, null), (boolean)false);
    }

    public static class UtilityErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException exc) {
            System.err.println("Error parsing file: " + exc);
        }

        public void fatalError(SAXParseException exc) {
            System.err.println("Fatal error parsing file: " + exc);
        }

        public void warning(SAXParseException exc) {
            System.err.println("SAX parsing exception: " + exc);
        }
    }
}

