/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import junit.framework.TestCase;
import mondrian.recorder.ListRecorder;
import mondrian.rolap.aggmatcher.DefaultDef;
import mondrian.rolap.aggmatcher.Recognizer;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMUtil;

public class DefaultRuleTest
extends TestCase {
    private static final Logger LOGGER = Logger.getLogger(DefaultRuleTest.class);
    private static final String DIRECTORY = "testsrc/main/mondrian/rolap/aggmatcher";
    private static final String TEST_RULE_XML = "TestRule.xml";
    private DefaultDef.AggRules rules;

    public DefaultRuleTest() {
    }

    public DefaultRuleTest(String name) {
        super(name);
    }

    private DefaultDef.AggRule getAggRule(String tag) {
        return this.rules.getAggRule(tag);
    }

    protected void setUp() throws Exception {
        File file = new File(DIRECTORY, TEST_RULE_XML);
        FileReader reader = new FileReader(file);
        Parser xmlParser = XOMUtil.createDefaultParser();
        DOMWrapper domWrapper = xmlParser.parse((Reader)reader);
        this.rules = new DefaultDef.AggRules(domWrapper);
        ListRecorder msgRecorder = new ListRecorder();
        this.rules.validate(msgRecorder);
        if (msgRecorder.hasErrors()) {
            LOGGER.error((Object)"HAS ERRORS");
            Iterator<ListRecorder.Entry> it = msgRecorder.getErrorEntries();
            while (it.hasNext()) {
                ListRecorder.Entry e = it.next();
                LOGGER.error((Object)("context=" + e.getContext()));
                LOGGER.error((Object)("message=" + e.getMessage()));
            }
        }
    }

    protected void tearDown() throws Exception {
    }

    private Recognizer.Matcher getTableMatcher(String tag, String tableName) {
        DefaultDef.TableMatch tableMatch;
        DefaultDef.AggRule rule = this.getAggRule(tag);
        if (rule == null) {
            LOGGER.info((Object)("rule == null for tag=" + tag));
        }
        if ((tableMatch = rule.getTableMatch()) == null) {
            LOGGER.info((Object)("tableMatch == null for tag=" + tag + ", tableName=" + tableName));
        }
        return tableMatch.getMatcher(tableName);
    }

    private Recognizer.Matcher getFactCountMatcher(String tag) {
        DefaultDef.AggRule rule = this.getAggRule(tag);
        DefaultDef.FactCountMatch factTableName = rule.getFactCountMatch();
        return factTableName.getMatcher();
    }

    private Recognizer.Matcher getForeignKeyMatcher(String tag, String foreignKeyName) {
        DefaultDef.AggRule rule = this.getAggRule(tag);
        DefaultDef.ForeignKeyMatch foreignKeyMatch = rule.getForeignKeyMatch();
        return foreignKeyMatch.getMatcher(foreignKeyName);
    }

    private Recognizer.Matcher getLevelMatcher(String tag, String usagePrefix, String hierarchyName, String levelName, String levelColumnName) {
        DefaultDef.AggRule rule = this.getAggRule(tag);
        Recognizer.Matcher matcher = rule.getLevelMap().getMatcher(usagePrefix, hierarchyName, levelName, levelColumnName);
        return matcher;
    }

    private Recognizer.Matcher getMeasureMatcher(String tag, String measureName, String measureColumnName, String aggregateName) {
        DefaultDef.AggRule rule = this.getAggRule(tag);
        Recognizer.Matcher matcher = rule.getMeasureMap().getMatcher(measureName, measureColumnName, aggregateName);
        return matcher;
    }

    public void testTableNameDefault() {
        String tag = "default";
        String factTableName = "FACT_TABLE";
        Recognizer.Matcher matcher = this.getTableMatcher("default", "FACT_TABLE");
        this.doMatch(matcher, "agg_10_FACT_TABLE");
        this.doMatch(matcher, "AGG_10_FACT_TABLE");
        this.doMatch(matcher, "agg_this_is_ok_FACT_TABLE");
        this.doMatch(matcher, "AGG_THIS_IS_OK_FACT_TABLE");
        this.doMatch(matcher, "agg_10_" + "FACT_TABLE".toLowerCase());
        this.doMatch(matcher, "AGG_10_" + "FACT_TABLE".toLowerCase());
        this.doMatch(matcher, "agg_this_is_ok_" + "FACT_TABLE".toLowerCase());
        this.doMatch(matcher, "AGG_THIS_IS_OK_" + "FACT_TABLE".toLowerCase());
        this.doNotMatch(matcher, "FACT_TABLE");
        this.doNotMatch(matcher, "agg__FACT_TABLE");
        this.doNotMatch(matcher, "agg_FACT_TABLE");
        this.doNotMatch(matcher, "FACT_TABLE_agg");
        this.doNotMatch(matcher, "agg_10_Mytable");
    }

    public void testTableNameBBBB() {
        String tag = "bbbb";
        String factTableName = "FACT_TABLE";
        Recognizer.Matcher matcher = this.getTableMatcher("bbbb", "FACT_TABLE");
        this.doMatch(matcher, "FACT_TABLE_agg_10");
        this.doMatch(matcher, "FACT_TABLE_agg_this_is_ok");
        this.doNotMatch(matcher, "FACT_TABLE");
        this.doNotMatch(matcher, "FACT_TABLE_agg");
        this.doNotMatch(matcher, "FACT_TABLE__agg");
        this.doNotMatch(matcher, "agg_FACT_TABLE");
        this.doNotMatch(matcher, "Mytable_agg_10");
    }

    public void testTableNameCCCCBAD() {
        String tag = "cccc";
        String basename = "WAREHOUSE";
        String factTableName = "RF_WAREHOUSE_TABLE";
        Recognizer.Matcher matcher = this.getTableMatcher("cccc", "WAREHOUSE");
        this.doNotMatch(matcher, "AGG_10_WAREHOUSE");
        this.doNotMatch(matcher, "agg_this_is_ok_WAREHOUSE");
        this.doNotMatch(matcher, "RF_WAREHOUSE_TABLE");
        this.doNotMatch(matcher, "agg__WAREHOUSE");
        this.doNotMatch(matcher, "agg_WAREHOUSE");
        this.doNotMatch(matcher, "WAREHOUSE_agg");
        this.doNotMatch(matcher, "agg_10_Mytable");
    }

    public void testTableNameCCCCGOOD() {
        String tag = "cccc";
        String basename = "WAREHOUSE";
        String factTableName = "RF_WAREHOUSE_TABLE";
        Recognizer.Matcher matcher = this.getTableMatcher("cccc", "RF_WAREHOUSE_TABLE");
        this.doMatch(matcher, "AGG_10_WAREHOUSE");
        this.doMatch(matcher, "agg_this_is_ok_WAREHOUSE");
        this.doNotMatch(matcher, "RF_WAREHOUSE_TABLE");
        this.doNotMatch(matcher, "agg__WAREHOUSE");
        this.doNotMatch(matcher, "agg_WAREHOUSE");
        this.doNotMatch(matcher, "WAREHOUSE_agg");
        this.doNotMatch(matcher, "agg_10_Mytable");
    }

    public void testFactCountDefault() {
        String tag = "default";
        Recognizer.Matcher matcher = this.getFactCountMatcher("default");
        this.doMatch(matcher, "fact_count");
        this.doMatch(matcher, "FACT_COUNT");
        this.doNotMatch(matcher, "my_fact_count");
        this.doNotMatch(matcher, "MY_FACT_COUNT");
        this.doNotMatch(matcher, "count");
        this.doNotMatch(matcher, "COUNT");
        this.doNotMatch(matcher, "fact_count_my");
        this.doNotMatch(matcher, "FACT_COUNT_MY");
    }

    public void testFactCountBBBB() {
        String tag = "bbbb";
        Recognizer.Matcher matcher = this.getFactCountMatcher("bbbb");
        this.doMatch(matcher, "my_fact_count");
        this.doMatch(matcher, "MY_FACT_COUNT");
        this.doNotMatch(matcher, "fact_count");
        this.doNotMatch(matcher, "FACT_COUNT");
        this.doNotMatch(matcher, "count");
        this.doNotMatch(matcher, "COUNT");
        this.doNotMatch(matcher, "fact_count_my");
        this.doNotMatch(matcher, "FACT_COUNT_MY");
    }

    public void testFactCountCCCC() {
        String tag = "cccc";
        Recognizer.Matcher matcher = this.getFactCountMatcher("cccc");
        this.doMatch(matcher, "MY_FACT_COUNT");
        this.doNotMatch(matcher, "my_fact_count");
        this.doNotMatch(matcher, "fact_count");
        this.doNotMatch(matcher, "FACT_COUNT");
        this.doNotMatch(matcher, "count");
        this.doNotMatch(matcher, "COUNT");
        this.doNotMatch(matcher, "fact_count_my");
        this.doNotMatch(matcher, "FACT_COUNT_MY");
    }

    public void testForeignKeyDefault() {
        String tag = "default";
        String foreignKeyName = "foo_key";
        Recognizer.Matcher matcher = this.getForeignKeyMatcher("default", "foo_key");
        this.doMatch(matcher, "foo_key");
        this.doMatch(matcher, "FOO_KEY");
        this.doNotMatch(matcher, "foo_key_my");
        this.doNotMatch(matcher, "my_foo_key");
    }

    public void testForeignKeyBBBB() {
        String tag = "bbbb";
        String foreignKeyName = "fk_ham_n_eggs";
        Recognizer.Matcher matcher = this.getForeignKeyMatcher("bbbb", "fk_ham_n_eggs");
        this.doMatch(matcher, "HAM_N_EGGS_FK");
        this.doNotMatch(matcher, "ham_n_eggs_fk");
        this.doNotMatch(matcher, "ham_n_eggs");
        this.doNotMatch(matcher, "fk_ham_n_eggs");
        this.doNotMatch(matcher, "HAM_N_EGGS");
        this.doNotMatch(matcher, "FK_HAM_N_EGGS");
    }

    public void testForeignKeyCCCC() {
        String tag = "cccc";
        String foreignKeyName1 = "fk_toast";
        String foreignKeyName2 = "FK_TOAST";
        String foreignKeyName3 = "FK_ToAsT";
        Recognizer.Matcher matcher1 = this.getForeignKeyMatcher("cccc", "fk_toast");
        Recognizer.Matcher matcher2 = this.getForeignKeyMatcher("cccc", "FK_TOAST");
        Recognizer.Matcher matcher3 = this.getForeignKeyMatcher("cccc", "FK_ToAsT");
        this.doMatch(matcher1, "toast_fk");
        this.doNotMatch(matcher1, "TOAST_FK");
        this.doMatch(matcher2, "TOAST_FK");
        this.doNotMatch(matcher2, "toast_fk");
        this.doMatch(matcher3, "ToAsT_FK");
        this.doMatch(matcher3, "ToAsT_fk");
        this.doMatch(matcher3, "ToAsT_Fk");
        this.doNotMatch(matcher3, "toast_fk");
        this.doNotMatch(matcher3, "TOAST_FK");
    }

    public void testLevelDefaultOne() {
        String tag = "default";
        String usagePrefix = null;
        String hierarchyName = "Time";
        String levelName = "Day in Year";
        String levelColumnName = "days";
        Recognizer.Matcher matcher = this.getLevelMatcher("default", usagePrefix, "Time", "Day in Year", "days");
        this.doMatch(matcher, "days");
        this.doMatch(matcher, "time_day_in_year");
        this.doMatch(matcher, "time_days");
        this.doNotMatch(matcher, "DAYS");
        this.doNotMatch(matcher, "Time Day in Year");
    }

    public void testLevelDefaultTwo() {
        String tag = "default";
        String usagePrefix = "boo_";
        String hierarchyName = "Time";
        String levelName = "Day in Year";
        String levelColumnName = "days";
        Recognizer.Matcher matcher = this.getLevelMatcher("default", "boo_", "Time", "Day in Year", "days");
        this.doMatch(matcher, "days");
        this.doMatch(matcher, "boo_days");
        this.doMatch(matcher, "time_day_in_year");
        this.doMatch(matcher, "time_days");
        this.doNotMatch(matcher, "boo_time_day_in_year");
        this.doNotMatch(matcher, "boo_time_days");
        this.doNotMatch(matcher, "DAYS");
        this.doNotMatch(matcher, "Time Day in Year");
    }

    public void testLevelBBBB() {
        String tag = "bbbb";
        String usagePrefix = "boo_";
        String hierarchyName = "Time.Period";
        String levelName = "Day in Year";
        String levelColumnName = "days";
        Recognizer.Matcher matcher = this.getLevelMatcher("bbbb", "boo_", "Time.Period", "Day in Year", "days");
        this.doMatch(matcher, "boo_time_DOT_period_day_SP_in_SP_year_days");
    }

    public void testMeasureDefault() {
        String tag = "default";
        String measureName = "Total Sales";
        String measureColumnName = "sales";
        String aggregateName = "sum";
        Recognizer.Matcher matcher = this.getMeasureMatcher("default", "Total Sales", "sales", "sum");
        this.doMatch(matcher, "total_sales");
        this.doMatch(matcher, "sales");
        this.doMatch(matcher, "sales_sum");
        this.doNotMatch(matcher, "Total Sales");
        this.doNotMatch(matcher, "Total_Sales");
        this.doNotMatch(matcher, "total_sales_sum");
    }

    private void doMatch(Recognizer.Matcher matcher, String s) {
        DefaultRuleTest.assertTrue((String)("Recognizer.Matcher: " + s), (boolean)matcher.matches(s));
    }

    private void doNotMatch(Recognizer.Matcher matcher, String s) {
        DefaultRuleTest.assertTrue((String)("Recognizer.Matcher: " + s), (!matcher.matches(s) ? 1 : 0) != 0);
    }
}

