/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import mondrian.rolap.BatchTestCase;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentLoaderTest
extends BatchTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testLoadWithMockResultsForLoadingSummaryAndDetailedSegments() {
        GroupingSet groupableSetsInfo = this.getGroupingSetRollupOnGender();
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        groupingSets.add(groupableSetsInfo);
        SegmentLoader loader = new SegmentLoader(){

            @Override
            SqlStatement createExecuteSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
                return null;
            }

            @Override
            List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
                return SegmentLoaderTest.this.getData(true);
            }
        };
        loader.load(groupingSets, null, null);
        Aggregation.Axis[] axes = groupingSetsInfo.getAxes();
        this.verifyYearAxis(axes[0]);
        this.verifyProductFamilyAxis(axes[1]);
        this.verifyProductDepartmentAxis(axes[2]);
        this.verifyGenderAxis(axes[3]);
        this.verifyUnitSalesDetailed(groupingSets.get(0).getSegments()[0]);
        axes = groupingSets.get(0).getAxes();
        this.verifyYearAxis(axes[0]);
        this.verifyProductFamilyAxis(axes[1]);
        this.verifyProductDepartmentAxis(axes[2]);
        this.verifyUnitSalesAggregate(groupingSets.get(1).getSegments()[0]);
    }

    public void testLoadWithMockResultsForLoadingSummaryAndDetailedSegmentsWithNullInRollupColumn() {
        GroupingSet groupableSetsInfo = this.getGroupingSetRollupOnGender();
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        groupingSets.add(groupableSetsInfo);
        SegmentLoader loader = new SegmentLoader(){

            @Override
            SqlStatement createExecuteSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
                return null;
            }

            @Override
            List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
                return SegmentLoaderTest.this.getDataWithNullInRollupColumn(true);
            }
        };
        loader.load(groupingSets, null, null);
        Segment detailedSegment = groupingSets.get(0).getSegments()[0];
        SegmentLoaderTest.assertEquals((int)3, (int)detailedSegment.getCellCount());
    }

    public void testLoadWithMockResultsForLoadingSummaryAndDetailedSegmentsUsingSparse() {
        GroupingSet groupableSetsInfo = this.getGroupingSetRollupOnGender();
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        groupingSets.add(groupableSetsInfo);
        SegmentLoader loader = new SegmentLoader(){

            @Override
            SqlStatement createExecuteSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
                return null;
            }

            @Override
            List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
                return SegmentLoaderTest.this.getData(true);
            }

            @Override
            boolean useSparse(boolean sparse, int n, List<Object[]> rows) {
                return true;
            }
        };
        loader.load(groupingSets, null, null);
        Aggregation.Axis[] axes = groupingSetsInfo.getAxes();
        this.verifyYearAxis(axes[0]);
        this.verifyProductFamilyAxis(axes[1]);
        this.verifyProductDepartmentAxis(axes[2]);
        this.verifyGenderAxis(axes[3]);
        this.verifyUnitSalesDetailedForSparse(groupingSets.get(0).getSegments()[0]);
        axes = groupingSets.get(0).getAxes();
        this.verifyYearAxis(axes[0]);
        this.verifyProductFamilyAxis(axes[1]);
        this.verifyProductDepartmentAxis(axes[2]);
        this.verifyUnitSalesAggregateForSparse(groupingSets.get(1).getSegments()[0]);
    }

    public void testLoadWithMockResultsForLoadingOnlyDetailedSegments() {
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        SegmentLoader loader = new SegmentLoader(){

            @Override
            SqlStatement createExecuteSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
                return null;
            }

            @Override
            List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
                return SegmentLoaderTest.this.getData(false);
            }
        };
        loader.load(groupingSets, null, null);
        Aggregation.Axis[] axes = groupingSetsInfo.getAxes();
        this.verifyYearAxis(axes[0]);
        this.verifyProductFamilyAxis(axes[1]);
        this.verifyProductDepartmentAxis(axes[2]);
        this.verifyGenderAxis(axes[3]);
        this.verifyUnitSalesDetailed(groupingSetsInfo.getSegments()[0]);
    }

    public void testProcessDataForGettingGroupingSetsBitKeysAndLoadingAxisValueSet() throws SQLException {
        GroupingSet groupableSetsInfo = this.getGroupingSetRollupOnGender();
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        groupingSets.add(groupableSetsInfo);
        SegmentLoader loader = new SegmentLoader(){

            @Override
            List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
                return SegmentLoaderTest.this.getData(true);
            }
        };
        int axisCount = 4;
        SortedSet<Comparable<?>>[] axisValueSet = loader.getDistinctValueWorkspace(axisCount);
        boolean[] axisContainsNull = new boolean[axisCount];
        List<Object[]> list = loader.processData(null, axisContainsNull, axisValueSet, new GroupingSetsList(groupingSets));
        int totalNoOfRows = 12;
        int lengthOfRowWithBitKey = 6;
        Object[] detailedRow = list.get(0);
        SegmentLoaderTest.assertEquals((int)totalNoOfRows, (int)list.size());
        SegmentLoaderTest.assertEquals((int)lengthOfRowWithBitKey, (int)detailedRow.length);
        SegmentLoaderTest.assertEquals((Object)BitKey.Factory.makeBitKey(0), (Object)detailedRow[5]);
        BitKey bitKeyForSummaryRow = BitKey.Factory.makeBitKey(0);
        bitKeyForSummaryRow.set(0);
        Object[] summaryRow = list.get(2);
        SegmentLoaderTest.assertEquals((Object)bitKeyForSummaryRow, (Object)summaryRow[5]);
        SortedSet<Comparable<?>> yearAxis = axisValueSet[0];
        SegmentLoaderTest.assertEquals((int)1, (int)yearAxis.size());
        SortedSet<Comparable<?>> productFamilyAxis = axisValueSet[1];
        SegmentLoaderTest.assertEquals((int)3, (int)productFamilyAxis.size());
        SortedSet<Comparable<?>> productDepartmentAxis = axisValueSet[2];
        SegmentLoaderTest.assertEquals((int)4, (int)productDepartmentAxis.size());
        SortedSet<Comparable<?>> genderAxis = axisValueSet[3];
        SegmentLoaderTest.assertEquals((int)2, (int)genderAxis.size());
        SegmentLoaderTest.assertFalse((boolean)axisContainsNull[0]);
        SegmentLoaderTest.assertFalse((boolean)axisContainsNull[1]);
        SegmentLoaderTest.assertFalse((boolean)axisContainsNull[2]);
        SegmentLoaderTest.assertFalse((boolean)axisContainsNull[3]);
    }

    private GroupingSet getGroupingSetRollupOnGender() {
        GroupingSet groupableSetsInfo = this.getGroupingSet(new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
        return groupableSetsInfo;
    }

    public void testProcessDataForSettingNullAxis() throws SQLException {
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        SegmentLoader loader = new SegmentLoader(){

            @Override
            List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
                return SegmentLoaderTest.this.getDataWithNullInAxisColumn(false);
            }
        };
        int axisCount = 4;
        SortedSet<Comparable<?>>[] axisValueSet = loader.getDistinctValueWorkspace(axisCount);
        boolean[] axisContainsNull = new boolean[axisCount];
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        loader.processData(null, axisContainsNull, axisValueSet, new GroupingSetsList(groupingSets));
        SegmentLoaderTest.assertFalse((boolean)axisContainsNull[0]);
        SegmentLoaderTest.assertFalse((boolean)axisContainsNull[1]);
        SegmentLoaderTest.assertTrue((boolean)axisContainsNull[2]);
        SegmentLoaderTest.assertFalse((boolean)axisContainsNull[3]);
    }

    public void testProcessDataForNonGroupingSetsScenario() throws SQLException {
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        SegmentLoader loader = new SegmentLoader(){

            @Override
            List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
                ArrayList<Object[]> data = new ArrayList<Object[]>();
                data.add(new Object[]{"1997", "Food", "Deli", "F", "5990"});
                data.add(new Object[]{"1997", "Food", "Deli", "M", "6047"});
                data.add(new Object[]{"1997", "Food", "Canned_Products", "F", "867"});
                return data;
            }
        };
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        SortedSet<Comparable<?>>[] axisValueSet = loader.getDistinctValueWorkspace(4);
        List<Object[]> list = loader.processData(null, new boolean[4], axisValueSet, new GroupingSetsList(groupingSets));
        int totalNoOfRows = 3;
        SegmentLoaderTest.assertEquals((int)totalNoOfRows, (int)list.size());
        int lengthOfRowWithoutBitKey = 5;
        SegmentLoaderTest.assertEquals((int)lengthOfRowWithoutBitKey, (int)list.get(0).length);
        SortedSet<Comparable<?>> yearAxis = axisValueSet[0];
        SegmentLoaderTest.assertEquals((int)1, (int)yearAxis.size());
        SortedSet<Comparable<?>> productFamilyAxis = axisValueSet[1];
        SegmentLoaderTest.assertEquals((int)1, (int)productFamilyAxis.size());
        SortedSet<Comparable<?>> productDepartmentAxis = axisValueSet[2];
        SegmentLoaderTest.assertEquals((int)2, (int)productDepartmentAxis.size());
        SortedSet<Comparable<?>> genderAxis = axisValueSet[3];
        SegmentLoaderTest.assertEquals((int)2, (int)genderAxis.size());
    }

    private void verifyUnitSalesDetailed(Segment segment) {
        Double[] unitSalesValues = new Double[]{null, null, null, null, 1987.0, 2199.0, null, null, 867.0, 945.0, null, null, null, null, 5990.0, 6047.0, null, null, 368.0, 473.0, null, null, null, null};
        Iterator iterator = segment.getData().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry x = (Map.Entry)iterator.next();
            SegmentLoaderTest.assertEquals((Object)unitSalesValues[index++], x.getValue());
        }
    }

    private void verifyUnitSalesDetailedForSparse(Segment segment) {
        ArrayList<CellKey> cellKeys = new ArrayList<CellKey>();
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 2, 1, 0}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 0, 2, 0}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 1, 0, 0}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 2, 1, 1}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 1, 0, 1}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 1, 3, 0}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 0, 2, 1}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 1, 3, 1}));
        Double[] unitSalesValues = new Double[]{368.0, 1987.0, 867.0, 473.0, 945.0, 5990.0, 2199.0, 6047.0};
        Iterator iterator = segment.getData().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry x = (Map.Entry)iterator.next();
            SegmentLoaderTest.assertEquals(cellKeys.get(index), x.getKey());
            SegmentLoaderTest.assertEquals((Object)unitSalesValues[index], x.getValue());
            ++index;
        }
    }

    private void verifyUnitSalesAggregateForSparse(Segment segment) {
        ArrayList<CellKey> cellKeys = new ArrayList<CellKey>();
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 2, 1}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 1, 0}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 1, 3}));
        cellKeys.add(CellKey.Generator.newCellKey(new int[]{0, 0, 2}));
        Double[] unitSalesValues = new Double[]{841.0, 1812.0, 12037.0, 4186.0};
        Iterator iterator = segment.getData().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry x = (Map.Entry)iterator.next();
            SegmentLoaderTest.assertEquals(cellKeys.get(index), x.getKey());
            SegmentLoaderTest.assertEquals((Object)unitSalesValues[index], x.getValue());
            ++index;
        }
    }

    private void verifyUnitSalesAggregate(Segment segment) {
        Double[] unitSalesValues = new Double[]{null, null, 4186.0, null, 1812.0, null, null, 12037.0, null, 841.0, null, null};
        Iterator iterator = segment.getData().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry x = (Map.Entry)iterator.next();
            SegmentLoaderTest.assertEquals((Object)unitSalesValues[index++], x.getValue());
        }
    }

    public void testGetGroupingBitKey() {
        Object[] data = new Object[]{"1997", "Food", "Deli", "M", "6047", 0, 0, 0, 0};
        SegmentLoaderTest.assertEquals((Object)BitKey.Factory.makeBitKey(4), (Object)new SegmentLoader().getRollupBitKey(4, data, 5));
        data = new Object[]{"1997", "Food", "Deli", null, "12037", 0, 0, 0, 1};
        BitKey key = BitKey.Factory.makeBitKey(4);
        key.set(3);
        SegmentLoaderTest.assertEquals((Object)key, (Object)new SegmentLoader().getRollupBitKey(4, data, 5));
        data = new Object[]{"1997", null, "Deli", null, "12037", 0, 1, 0, 1};
        key = BitKey.Factory.makeBitKey(4);
        key.set(1);
        key.set(3);
        SegmentLoaderTest.assertEquals((Object)key, (Object)new SegmentLoader().getRollupBitKey(4, data, 5));
    }

    public void testGroupingSetsUtilForMissingGroupingBitKeys() {
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(this.getDefaultGroupingSet());
        groupingSets.add(this.getGroupingSetRollupOnGender());
        GroupingSetsList detail = new GroupingSetsList(groupingSets);
        List<BitKey> bitKeysList = detail.getRollupColumnsBitKeyList();
        int columnsCount = 4;
        SegmentLoaderTest.assertEquals((Object)BitKey.Factory.makeBitKey(columnsCount), (Object)bitKeysList.get(0));
        BitKey key = BitKey.Factory.makeBitKey(columnsCount);
        key.set(0);
        SegmentLoaderTest.assertEquals((Object)key, (Object)bitKeysList.get(1));
        groupingSets = new ArrayList();
        groupingSets.add(this.getDefaultGroupingSet());
        groupingSets.add(this.getGroupingSetRollupOnGenderAndProductFamily());
        bitKeysList = new GroupingSetsList(groupingSets).getRollupColumnsBitKeyList();
        SegmentLoaderTest.assertEquals((Object)BitKey.Factory.makeBitKey(columnsCount), (Object)bitKeysList.get(0));
        key = BitKey.Factory.makeBitKey(columnsCount);
        key.set(0);
        key.set(1);
        SegmentLoaderTest.assertEquals((Object)key, (Object)bitKeysList.get(1));
        SegmentLoaderTest.assertTrue((boolean)new GroupingSetsList(new ArrayList<GroupingSet>()).getRollupColumnsBitKeyList().isEmpty());
    }

    private GroupingSet getGroupingSetRollupOnGenderAndProductFamily() {
        return this.getGroupingSet(new String[]{"time_by_day", "product_class"}, new String[]{"the_year", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
    }

    public void testGroupingSetsUtilSetsDetailForRollupColumns() {
        RolapStar.Measure measure = this.getMeasure("Sales", "[Measures].[Unit Sales]");
        RolapStar star = measure.getStar();
        RolapStar.Column year = star.lookupColumn("time_by_day", "the_year");
        RolapStar.Column productFamily = star.lookupColumn("product_class", "product_family");
        RolapStar.Column productDepartment = star.lookupColumn("product_class", "product_department");
        RolapStar.Column gender = star.lookupColumn("customer", this.fieldGender);
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(this.getDefaultGroupingSet());
        groupingSets.add(this.getGroupingSetRollupOnProductDepartment());
        groupingSets.add(this.getGroupingSetRollupOnGenderAndProductDepartment());
        GroupingSetsList detail = new GroupingSetsList(groupingSets);
        List<RolapStar.Column> rollupColumnsList = detail.getRollupColumns();
        SegmentLoaderTest.assertEquals((int)2, (int)rollupColumnsList.size());
        SegmentLoaderTest.assertEquals((Object)gender, (Object)rollupColumnsList.get(0));
        SegmentLoaderTest.assertEquals((Object)productDepartment, (Object)rollupColumnsList.get(1));
        groupingSets.add(this.getGroupingSetRollupOnGenderAndProductDepartmentAndYear());
        detail = new GroupingSetsList(groupingSets);
        rollupColumnsList = detail.getRollupColumns();
        SegmentLoaderTest.assertEquals((int)3, (int)rollupColumnsList.size());
        SegmentLoaderTest.assertEquals((Object)gender, (Object)rollupColumnsList.get(0));
        SegmentLoaderTest.assertEquals((Object)productDepartment, (Object)rollupColumnsList.get(1));
        SegmentLoaderTest.assertEquals((Object)year, (Object)rollupColumnsList.get(2));
        groupingSets.add(this.getGroupingSetRollupOnProductFamilyAndProductDepartment());
        detail = new GroupingSetsList(groupingSets);
        rollupColumnsList = detail.getRollupColumns();
        SegmentLoaderTest.assertEquals((int)4, (int)rollupColumnsList.size());
        SegmentLoaderTest.assertEquals((Object)gender, (Object)rollupColumnsList.get(0));
        SegmentLoaderTest.assertEquals((Object)productDepartment, (Object)rollupColumnsList.get(1));
        SegmentLoaderTest.assertEquals((Object)productFamily, (Object)rollupColumnsList.get(2));
        SegmentLoaderTest.assertEquals((Object)year, (Object)rollupColumnsList.get(3));
        SegmentLoaderTest.assertTrue((boolean)new GroupingSetsList(new ArrayList<GroupingSet>()).getRollupColumns().isEmpty());
    }

    private GroupingSet getGroupingSetRollupOnGenderAndProductDepartment() {
        return this.getGroupingSet(new String[]{"product_class", "time_by_day"}, new String[]{"product_family", "the_year"}, new String[][]{this.fieldValuesProductFamily, this.fieldValuesYear}, "Sales", "[Measures].[Unit Sales]");
    }

    private GroupingSet getGroupingSetRollupOnProductFamilyAndProductDepartment() {
        return this.getGroupingSet(new String[]{"customer", "time_by_day"}, new String[]{this.fieldGender, "the_year"}, new String[][]{this.fieldValuesGender, this.fieldValuesYear}, "Sales", "[Measures].[Unit Sales]");
    }

    private GroupingSet getGroupingSetRollupOnGenderAndProductDepartmentAndYear() {
        return this.getGroupingSet(new String[]{"product_class"}, new String[]{"product_family"}, new String[][]{this.fieldValuesProductFamily}, "Sales", "[Measures].[Unit Sales]");
    }

    private GroupingSet getGroupingSetRollupOnProductDepartment() {
        return this.getGroupingSet(new String[]{"customer", "product_class", "time_by_day"}, new String[]{this.fieldGender, "product_family", "the_year"}, new String[][]{this.fieldValuesGender, this.fieldValuesProductFamily, this.fieldValuesYear}, "Sales", "[Measures].[Unit Sales]");
    }

    public void testGroupingSetsUtilSetsForDetailForRollupColumns() {
        RolapStar.Measure measure = this.getMeasure("Sales", "[Measures].[Unit Sales]");
        RolapStar star = measure.getStar();
        RolapStar.Column year = star.lookupColumn("time_by_day", "the_year");
        RolapStar.Column productFamily = star.lookupColumn("product_class", "product_family");
        RolapStar.Column productDepartment = star.lookupColumn("product_class", "product_department");
        RolapStar.Column gender = star.lookupColumn("customer", this.fieldGender);
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(this.getDefaultGroupingSet());
        groupingSets.add(this.getGroupingSetRollupOnProductDepartment());
        groupingSets.add(this.getGroupingSetRollupOnGenderAndProductDepartment());
        GroupingSetsList detail = new GroupingSetsList(groupingSets);
        List<RolapStar.Column> rollupColumnsList = detail.getRollupColumns();
        SegmentLoaderTest.assertEquals((int)2, (int)rollupColumnsList.size());
        SegmentLoaderTest.assertEquals((Object)gender, (Object)rollupColumnsList.get(0));
        SegmentLoaderTest.assertEquals((Object)productDepartment, (Object)rollupColumnsList.get(1));
        groupingSets.add(this.getGroupingSetRollupOnGenderAndProductDepartmentAndYear());
        detail = new GroupingSetsList(groupingSets);
        rollupColumnsList = detail.getRollupColumns();
        SegmentLoaderTest.assertEquals((int)3, (int)rollupColumnsList.size());
        SegmentLoaderTest.assertEquals((Object)gender, (Object)rollupColumnsList.get(0));
        SegmentLoaderTest.assertEquals((Object)productDepartment, (Object)rollupColumnsList.get(1));
        SegmentLoaderTest.assertEquals((Object)year, (Object)rollupColumnsList.get(2));
        groupingSets.add(this.getGroupingSetRollupOnProductFamilyAndProductDepartment());
        detail = new GroupingSetsList(groupingSets);
        rollupColumnsList = detail.getRollupColumns();
        SegmentLoaderTest.assertEquals((int)4, (int)rollupColumnsList.size());
        SegmentLoaderTest.assertEquals((Object)gender, (Object)rollupColumnsList.get(0));
        SegmentLoaderTest.assertEquals((Object)productDepartment, (Object)rollupColumnsList.get(1));
        SegmentLoaderTest.assertEquals((Object)productFamily, (Object)rollupColumnsList.get(2));
        SegmentLoaderTest.assertEquals((Object)year, (Object)rollupColumnsList.get(3));
        SegmentLoaderTest.assertTrue((boolean)new GroupingSetsList(new ArrayList<GroupingSet>()).getRollupColumns().isEmpty());
    }

    public void testGroupingSetsUtilSetsForGroupingFunctionIndex() {
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(this.getDefaultGroupingSet());
        groupingSets.add(this.getGroupingSetRollupOnProductDepartment());
        groupingSets.add(this.getGroupingSetRollupOnGenderAndProductDepartment());
        GroupingSetsList detail = new GroupingSetsList(groupingSets);
        SegmentLoaderTest.assertEquals((int)0, (int)detail.findGroupingFunctionIndex(3));
        SegmentLoaderTest.assertEquals((int)1, (int)detail.findGroupingFunctionIndex(2));
        groupingSets.add(this.getGroupingSetRollupOnGenderAndProductDepartmentAndYear());
        detail = new GroupingSetsList(groupingSets);
        SegmentLoaderTest.assertEquals((int)0, (int)detail.findGroupingFunctionIndex(3));
        SegmentLoaderTest.assertEquals((int)1, (int)detail.findGroupingFunctionIndex(2));
        SegmentLoaderTest.assertEquals((int)2, (int)detail.findGroupingFunctionIndex(0));
        groupingSets.add(this.getGroupingSetRollupOnProductFamilyAndProductDepartment());
        detail = new GroupingSetsList(groupingSets);
        SegmentLoaderTest.assertEquals((int)0, (int)detail.findGroupingFunctionIndex(3));
        SegmentLoaderTest.assertEquals((int)1, (int)detail.findGroupingFunctionIndex(2));
        SegmentLoaderTest.assertEquals((int)2, (int)detail.findGroupingFunctionIndex(1));
        SegmentLoaderTest.assertEquals((int)3, (int)detail.findGroupingFunctionIndex(0));
    }

    public void testGetGroupingColumnsList() {
        GroupingSet groupingSetsInfo = this.getDefaultGroupingSet();
        GroupingSet groupableSetsInfo = this.getGroupingSetRollupOnGender();
        RolapStar.Column[] detailedColumns = groupingSetsInfo.getSegments()[0].aggregation.getColumns();
        RolapStar.Column[] summaryColumns = groupableSetsInfo.getSegments()[0].aggregation.getColumns();
        ArrayList<GroupingSet> summayAggs = new ArrayList<GroupingSet>();
        summayAggs.add(groupableSetsInfo);
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(groupingSetsInfo);
        groupingSets.add(groupableSetsInfo);
        List<RolapStar.Column[]> groupingColumns = new GroupingSetsList(groupingSets).getGroupingSetsColumns();
        SegmentLoaderTest.assertEquals((int)2, (int)groupingColumns.size());
        SegmentLoaderTest.assertEquals((Object)detailedColumns, (Object)groupingColumns.get(0));
        SegmentLoaderTest.assertEquals((Object)summaryColumns, (Object)groupingColumns.get(1));
        groupingColumns = new GroupingSetsList(new ArrayList<GroupingSet>()).getGroupingSetsColumns();
        SegmentLoaderTest.assertEquals((int)0, (int)groupingColumns.size());
    }

    public void testSetFailOnStillLoadingSegments() {
        ArrayList<GroupingSet> groupingSets = new ArrayList<GroupingSet>();
        groupingSets.add(this.getDefaultGroupingSet());
        new SegmentLoader().setFailOnStillLoadingSegments(new GroupingSetsList(groupingSets));
        for (GroupingSet groupingSet : groupingSets) {
            for (Segment segment : groupingSet.getSegments()) {
                SegmentLoaderTest.assertTrue((boolean)segment.isFailed());
            }
        }
        groupingSets = new ArrayList();
        groupingSets.add(this.getDefaultGroupingSet());
        groupingSets.add(this.getGroupingSetRollupOnGender());
        new SegmentLoader().setFailOnStillLoadingSegments(new GroupingSetsList(groupingSets));
        for (GroupingSet groupingSet : groupingSets) {
            for (Segment segment : groupingSet.getSegments()) {
                SegmentLoaderTest.assertTrue((boolean)segment.isFailed());
            }
        }
    }

    private GroupingSet getDefaultGroupingSet() {
        return this.getGroupingSet(new String[]{"customer", "product_class", "product_class", "time_by_day"}, new String[]{this.fieldGender, "product_department", "product_family", "the_year"}, new String[][]{this.fieldValuesGender, this.fieldValueProductDepartment, this.fieldValuesProductFamily, this.fieldValuesYear}, "Sales", "[Measures].[Unit Sales]");
    }

    private void verifyYearAxis(Aggregation.Axis axis) {
        Comparable<?>[] keys = axis.getKeys();
        SegmentLoaderTest.assertEquals((int)1, (int)keys.length);
        SegmentLoaderTest.assertEquals((String)"1997", (String)keys[0].toString());
    }

    private void verifyProductFamilyAxis(Aggregation.Axis axis) {
        Comparable<?>[] keys = axis.getKeys();
        SegmentLoaderTest.assertEquals((int)3, (int)keys.length);
        SegmentLoaderTest.assertEquals((String)"Drink", (String)keys[0].toString());
        SegmentLoaderTest.assertEquals((String)"Food", (String)keys[1].toString());
        SegmentLoaderTest.assertEquals((String)"Non-Consumable", (String)keys[2].toString());
    }

    private void verifyProductDepartmentAxis(Aggregation.Axis axis) {
        Comparable<?>[] keys = axis.getKeys();
        SegmentLoaderTest.assertEquals((int)4, (int)keys.length);
        SegmentLoaderTest.assertEquals((String)"Canned_Products", (String)keys[0].toString());
    }

    private void verifyGenderAxis(Aggregation.Axis axis) {
        Comparable<?>[] keys = axis.getKeys();
        SegmentLoaderTest.assertEquals((int)2, (int)keys.length);
        SegmentLoaderTest.assertEquals((String)"F", (String)keys[0].toString());
        SegmentLoaderTest.assertEquals((String)"M", (String)keys[1].toString());
    }

    private List<Object[]> getData(boolean incSummaryData) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"1997", "Food", "Deli", "F", "5990", 0});
        data.add(new Object[]{"1997", "Food", "Deli", "M", "6047", 0});
        if (incSummaryData) {
            data.add(new Object[]{"1997", "Food", "Deli", null, "12037", 1});
        }
        data.add(new Object[]{"1997", "Food", "Canned_Products", "F", "867", 0});
        data.add(new Object[]{"1997", "Food", "Canned_Products", "M", "945", 0});
        if (incSummaryData) {
            data.add(new Object[]{"1997", "Food", "Canned_Products", null, "1812", 1});
        }
        data.add(new Object[]{"1997", "Drink", "Dairy", "F", "1987", 0});
        data.add(new Object[]{"1997", "Drink", "Dairy", "M", "2199", 0});
        if (incSummaryData) {
            data.add(new Object[]{"1997", "Drink", "Dairy", null, "4186", 1});
        }
        data.add(new Object[]{"1997", "Non-Consumable", "Carousel", "F", "368", 0});
        data.add(new Object[]{"1997", "Non-Consumable", "Carousel", "M", "473", 0});
        if (incSummaryData) {
            data.add(new Object[]{"1997", "Non-Consumable", "Carousel", null, "841", 1});
        }
        return data;
    }

    private List<Object[]> getDataWithNullInRollupColumn(boolean incSummaryData) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"1997", "Food", "Deli", "F", "5990", 0});
        data.add(new Object[]{"1997", "Food", "Deli", "M", "6047", 0});
        data.add(new Object[]{"1997", "Food", "Deli", null, "867", 0});
        if (incSummaryData) {
            data.add(new Object[]{"1997", "Food", "Deli", null, "12037", 1});
        }
        return data;
    }

    private List<Object[]> getDataWithNullInAxisColumn(boolean incSummaryData) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"1997", "Food", "Deli", "F", "5990", 0});
        data.add(new Object[]{"1997", "Food", "Deli", "M", "6047", 0});
        if (incSummaryData) {
            data.add(new Object[]{"1997", "Food", "Deli", null, "12037", 1});
        }
        data.add(new Object[]{"1997", "Food", null, "F", "867", 0});
        return data;
    }
}

