/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class SharedDimensionTest
extends FoodMartTestCase {
    public static final String sharedDimension = "<Dimension name=\"Employee\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"employee_id\" primaryKeyTable=\"employee\">\n    <Join leftKey=\"supervisor_id\" rightKey=\"employee_id\">\n      <Table name=\"employee\" alias=\"employee\" />\n      <Table name=\"employee\" alias=\"employee_manager\" />\n    </Join>\n    <Level name=\"Role\" table=\"employee_manager\" column=\"management_role\" uniqueMembers=\"true\"/>\n    <Level name=\"Title\" table=\"employee_manager\" column=\"position_title\" uniqueMembers=\"false\"/>\n  </Hierarchy>\n</Dimension>";
    public static final String cubeA = "<Cube name=\"Employee Store Analysis A\">\n  <Table name=\"inventory_fact_1997\" alias=\"inventory\" />\n  <DimensionUsage name=\"Employee\" source=\"Employee\" foreignKey=\"product_id\" />\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"warehouse_id\" />\n  <Measure name=\"Employee Store Sales\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_sales\" />\n  <Measure name=\"Employee Store Cost\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_cost\" />\n</Cube>";
    public static final String cubeB = "<Cube name=\"Employee Store Analysis B\">\n  <Table name=\"inventory_fact_1997\" alias=\"inventory\" />\n  <DimensionUsage name=\"Employee\" source=\"Employee\" foreignKey=\"time_id\" />\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"store_id\" />\n  <Measure name=\"Employee Store Sales\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_sales\" />\n  <Measure name=\"Employee Store Cost\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_cost\" />\n</Cube>";
    public static final String virtualCube = "<VirtualCube name=\"Employee Store Analysis\">\n  <VirtualCubeDimension name=\"Employee\"/>\n  <VirtualCubeDimension name=\"Store Type\"/>\n  <VirtualCubeMeasure cubeName=\"Employee Store Analysis A\" name=\"[Measures].[Employee Store Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Employee Store Analysis B\" name=\"[Measures].[Employee Store Cost]\"/>\n</VirtualCube>";
    public static final String queryCubeA = "with\n  set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Employee], [*BASE_MEMBERS_Store Type])'\n  set [*BASE_MEMBERS_Measures] as '{[Measures].[Employee Store Sales], [Measures].[Employee Store Cost]}'\n  set [*BASE_MEMBERS_Employee] as '[Employee].[Role].Members'\n  set [*NATIVE_MEMBERS_Employee] as 'Generate([*NATIVE_CJ_SET], {[Employee].CurrentMember})'\n  set [*BASE_MEMBERS_Store Type] as '[Store Type].[Store Type].Members'\n  set [*NATIVE_MEMBERS_Store Type] as 'Generate([*NATIVE_CJ_SET], {[Store Type].CurrentMember})'\nselect\n  [*BASE_MEMBERS_Measures] ON COLUMNS,\n  NON EMPTY Generate([*NATIVE_CJ_SET], {([Employee].CurrentMember, [Store Type].CurrentMember)}) ON ROWS\nfrom\n  [Employee Store Analysis A]";
    public static final String queryCubeB = "with\n  set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Employee], [*BASE_MEMBERS_Store Type])'\n  set [*BASE_MEMBERS_Measures] as '{[Measures].[Employee Store Sales], [Measures].[Employee Store Cost]}'\n  set [*BASE_MEMBERS_Employee] as '[Employee].[Role].Members'\n  set [*NATIVE_MEMBERS_Employee] as 'Generate([*NATIVE_CJ_SET], {[Employee].CurrentMember})'\n  set [*BASE_MEMBERS_Store Type] as '[Store Type].[Store Type].Members'\n  set [*NATIVE_MEMBERS_Store Type] as 'Generate([*NATIVE_CJ_SET], {[Store Type].CurrentMember})'\nselect\n  [*BASE_MEMBERS_Measures] ON COLUMNS,\n  NON EMPTY Generate([*NATIVE_CJ_SET], {([Employee].CurrentMember, [Store Type].CurrentMember)}) ON ROWS\nfrom\n  [Employee Store Analysis B]";
    public static final String queryVirtualCube = "with\n  set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Employee], [*BASE_MEMBERS_Store Type])'\n  set [*BASE_MEMBERS_Measures] as '{[Measures].[Employee Store Sales], [Measures].[Employee Store Cost]}'\n  set [*BASE_MEMBERS_Employee] as '[Employee].[Role].Members'\n  set [*NATIVE_MEMBERS_Employee] as 'Generate([*NATIVE_CJ_SET], {[Employee].CurrentMember})'\n  set [*BASE_MEMBERS_Store Type] as '[Store Type].[Store Type].Members'\n  set [*NATIVE_MEMBERS_Store Type] as 'Generate([*NATIVE_CJ_SET], {[Store Type].CurrentMember})'\nselect\n  [*BASE_MEMBERS_Measures] ON COLUMNS,\n  NON EMPTY Generate([*NATIVE_CJ_SET], {([Employee].CurrentMember, [Store Type].CurrentMember)}) ON ROWS\nfrom\n  [Employee Store Analysis]";
    public static final String queryStoreCube = "with set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Store Type], [*BASE_MEMBERS_Store])'\nset [*BASE_MEMBERS_Measures] as '{[Measures].[Store Sqft]}'\nset [*BASE_MEMBERS_Store Type] as '[Store Type].[Store Type].Members'\nset [*BASE_MEMBERS_Store] as '[Store].[Store State].Members'\nselect [*BASE_MEMBERS_Measures] ON COLUMNS,\nNon Empty Generate([*NATIVE_CJ_SET], {[Store Type].CurrentMember}) on rows from [Store]";
    public static final String queryNECJMemberList = "select {[Measures].[Employee Store Sales]} on columns,\nNonEmptyCrossJoin([Store Type].[Store Type].Members,\n{[Employee].[All Employees].[Middle Management],\n [Employee].[All Employees].[Store Management]})\non rows from [Employee Store Analysis B]";
    public static final String queryNECJMultiLevelMemberList = "select {[Employee Store Sales]} on columns, NonEmptyCrossJoin([Store Type].[Store Type].Members, {[Employee].[Store Management].[Store Manager],  [Employee].[Senior Management].[President]}) on rows from [Employee Store Analysis B]";
    public static final String querySF1711865 = "select NON EMPTY {[Product].[Product Family].Members} ON COLUMNS from [Sales 2]";
    public static final String resultCubeA = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Employee Store Sales]}\n{[Measures].[Employee Store Cost]}\nAxis #2:\n{[Employee].[All Employees].[Middle Management], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Employee].[All Employees].[Middle Management], [Store Type].[All Store Types].[Supermarket]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Small Grocery]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Small Grocery]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Supermarket]}\nRow #0: $200\nRow #0: $87\nRow #1: $161\nRow #1: $68\nRow #2: $1,721\nRow #2: $739\nRow #3: $261\nRow #3: $114\nRow #4: $257\nRow #4: $111\nRow #5: $196\nRow #5: $101\nRow #6: $3,993\nRow #6: $1,858\nRow #7: $45,014\nRow #7: $20,604\nRow #8: $7,231\nRow #8: $3,211\nRow #9: $8,171\nRow #9: $3,635\nRow #10: $4,471\nRow #10: $2,045\nRow #11: $77,236\nRow #11: $34,842\n";
    public static final String resultCubeB = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Employee Store Sales]}\n{[Measures].[Employee Store Cost]}\nAxis #2:\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Small Grocery]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Supermarket]}\nRow #0: $61,860\nRow #0: $28,093\nRow #1: $10,156\nRow #1: $4,482\nRow #2: $10,212\nRow #2: $4,576\nRow #3: $5,932\nRow #3: $2,714\nRow #4: $108,610\nRow #4: $49,178\n";
    public static final String resultVirtualCube = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Employee Store Sales]}\n{[Measures].[Employee Store Cost]}\nAxis #2:\n{[Employee].[All Employees].[Middle Management], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Employee].[All Employees].[Middle Management], [Store Type].[All Store Types].[Supermarket]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Small Grocery]}\n{[Employee].[All Employees].[Senior Management], [Store Type].[All Store Types].[Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Small Grocery]}\n{[Employee].[All Employees].[Store Management], [Store Type].[All Store Types].[Supermarket]}\nRow #0: $200\nRow #0: \nRow #1: $161\nRow #1: \nRow #2: $1,721\nRow #2: \nRow #3: $261\nRow #3: \nRow #4: $257\nRow #4: \nRow #5: $196\nRow #5: \nRow #6: $3,993\nRow #6: \nRow #7: $45,014\nRow #7: $28,093\nRow #8: $7,231\nRow #8: $4,482\nRow #9: $8,171\nRow #9: $4,576\nRow #10: $4,471\nRow #10: $2,714\nRow #11: $77,236\nRow #11: $49,178\n";
    public static final String resultStoreCube = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sqft]}\nAxis #2:\n{[Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Store Type].[All Store Types].[Small Grocery]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 146,045\nRow #1: 47,447\nRow #2: 109,343\nRow #3: 75,281\nRow #4: 193,480\n";
    public static final String resultNECJMemberList = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Employee Store Sales]}\nAxis #2:\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Employee].[All Employees].[Store Management]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Employee].[All Employees].[Store Management]}\n{[Store Type].[All Store Types].[Mid-Size Grocery], [Employee].[All Employees].[Store Management]}\n{[Store Type].[All Store Types].[Small Grocery], [Employee].[All Employees].[Store Management]}\n{[Store Type].[All Store Types].[Supermarket], [Employee].[All Employees].[Store Management]}\nRow #0: $61,860\nRow #1: $10,156\nRow #2: $10,212\nRow #3: $5,932\nRow #4: $108,610\n";
    public static final String resultNECJMultiLevelMemberList = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Employee Store Sales]}\nAxis #2:\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Employee].[All Employees].[Store Management].[Store Manager]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Employee].[All Employees].[Store Management].[Store Manager]}\n{[Store Type].[All Store Types].[Supermarket], [Employee].[All Employees].[Store Management].[Store Manager]}\nRow #0: $1,783\nRow #1: $286\nRow #2: $1,020\n";
    public static final String resultSF1711865 = "Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 7,978\nRow #0: 62,445\nRow #0: 16,414\n";

    public SharedDimensionTest() {
    }

    public SharedDimensionTest(String name) {
        super(name);
    }

    public void testA() {
        TestContext testContext = this.getTestContextForSharedDimCubeACubeB();
        testContext.assertQueryReturns(queryCubeA, SharedDimensionTest.fold(resultCubeA));
    }

    public void testB() {
        TestContext testContext = this.getTestContextForSharedDimCubeACubeB();
        testContext.assertQueryReturns(queryCubeB, SharedDimensionTest.fold(resultCubeB));
    }

    public void testVirtualCube() {
        TestContext testContext = TestContext.create(sharedDimension, "<Cube name=\"Employee Store Analysis A\">\n  <Table name=\"inventory_fact_1997\" alias=\"inventory\" />\n  <DimensionUsage name=\"Employee\" source=\"Employee\" foreignKey=\"product_id\" />\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"warehouse_id\" />\n  <Measure name=\"Employee Store Sales\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_sales\" />\n  <Measure name=\"Employee Store Cost\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_cost\" />\n</Cube>\n<Cube name=\"Employee Store Analysis B\">\n  <Table name=\"inventory_fact_1997\" alias=\"inventory\" />\n  <DimensionUsage name=\"Employee\" source=\"Employee\" foreignKey=\"time_id\" />\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"store_id\" />\n  <Measure name=\"Employee Store Sales\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_sales\" />\n  <Measure name=\"Employee Store Cost\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_cost\" />\n</Cube>", virtualCube, null, null, null);
        testContext.assertQueryReturns(queryVirtualCube, SharedDimensionTest.fold(resultVirtualCube));
    }

    public void testNECJMemberList() {
        TestContext testContext = this.getTestContextForSharedDimCubeACubeB();
        testContext.assertQueryReturns(queryNECJMemberList, SharedDimensionTest.fold(resultNECJMemberList));
    }

    public void testNECJMultiLevelMemberList() {
        TestContext testContext = this.getTestContextForSharedDimCubeACubeB();
        testContext.assertQueryReturns(queryNECJMultiLevelMemberList, SharedDimensionTest.fold(resultNECJMultiLevelMemberList));
    }

    public void testSF1711865() {
        this.getTestContext().assertQueryReturns(querySF1711865, SharedDimensionTest.fold(resultSF1711865));
    }

    public void testStoreCube() {
        this.getTestContext().assertQueryReturns(queryStoreCube, SharedDimensionTest.fold(resultStoreCube));
    }

    private TestContext getTestContextForSharedDimCubeACubeB() {
        return TestContext.create(sharedDimension, "<Cube name=\"Employee Store Analysis A\">\n  <Table name=\"inventory_fact_1997\" alias=\"inventory\" />\n  <DimensionUsage name=\"Employee\" source=\"Employee\" foreignKey=\"product_id\" />\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"warehouse_id\" />\n  <Measure name=\"Employee Store Sales\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_sales\" />\n  <Measure name=\"Employee Store Cost\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_cost\" />\n</Cube>\n<Cube name=\"Employee Store Analysis B\">\n  <Table name=\"inventory_fact_1997\" alias=\"inventory\" />\n  <DimensionUsage name=\"Employee\" source=\"Employee\" foreignKey=\"time_id\" />\n  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"store_id\" />\n  <Measure name=\"Employee Store Sales\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_sales\" />\n  <Measure name=\"Employee Store Cost\" aggregator=\"sum\" formatString=\"$#,##0\" column=\"warehouse_cost\" />\n</Cube>", null, null, null, null);
    }
}

