/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.MondrianProperties;
import mondrian.rolap.CellKey;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class CellKeyTest
extends FoodMartTestCase {
    public CellKeyTest() {
    }

    public CellKeyTest(String name) {
        super(name);
    }

    public void testMany() {
        CellKey key = CellKey.Generator.newManyCellKey(5);
        CellKeyTest.assertTrue((String)"CellKey size", (key.size() == 5 ? 1 : 0) != 0);
        CellKey copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        int[] ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        boolean gotException = false;
        try {
            key.setAxis(6, 1);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey axis too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[6]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[4]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too small", (boolean)gotException);
        key.setAxis(0, 1);
        key.setAxis(1, 3);
        key.setAxis(2, 5);
        key.setAxis(3, 7);
        key.setAxis(4, 13);
        CellKeyTest.assertTrue((String)"CellKey not equals", (!key.equals(copy) ? 1 : 0) != 0);
        copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
    }

    public void testZero() {
        CellKey key2;
        CellKey key = CellKey.Generator.newCellKey(new int[0]);
        CellKeyTest.assertTrue((key == (key2 = CellKey.Generator.newCellKey(new int[0])) ? 1 : 0) != 0);
        CellKeyTest.assertEquals((int)0, (int)key.size());
        CellKey keyMany = CellKey.Generator.newManyCellKey(0);
        CellKeyTest.assertEquals((Object)keyMany, (Object)key);
        CellKey copy = key.copy();
        CellKeyTest.assertEquals((Object)copy, (Object)key);
        boolean gotException = false;
        try {
            key.setAxis(0, 0);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey axis too big", (boolean)gotException);
        int[] ordinals = key.getOrdinals();
        CellKeyTest.assertEquals((int)ordinals.length, (int)0);
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
    }

    public void testOne() {
        CellKey keyMany = CellKey.Generator.newManyCellKey(1);
        CellKey key = CellKey.Generator.newCellKey(1);
        CellKeyTest.assertTrue((String)"CellKey size", (key.size() == 1 ? 1 : 0) != 0);
        CellKeyTest.assertTrue((String)"CellKey size", (keyMany.size() == 1 ? 1 : 0) != 0);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(keyMany));
        CellKey copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        int[] ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        boolean gotException = false;
        try {
            key.setAxis(3, 1);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey axis too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[3]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[0]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too small", (boolean)gotException);
        key.setAxis(0, 1);
        CellKeyTest.assertTrue((String)"CellKey not equals", (!key.equals(keyMany) ? 1 : 0) != 0);
        keyMany.setAxis(0, 1);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(keyMany));
        copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
    }

    public void testTwo() {
        CellKey keyMany = CellKey.Generator.newManyCellKey(2);
        CellKey key = CellKey.Generator.newCellKey(2);
        CellKeyTest.assertTrue((String)"CellKey size", (key.size() == 2 ? 1 : 0) != 0);
        CellKeyTest.assertTrue((String)"CellKey size", (keyMany.size() == 2 ? 1 : 0) != 0);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(keyMany));
        CellKey copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        int[] ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        boolean gotException = false;
        try {
            key.setAxis(3, 1);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey axis too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[3]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[1]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too small", (boolean)gotException);
        key.setAxis(0, 1);
        key.setAxis(1, 3);
        CellKeyTest.assertTrue((String)"CellKey not equals", (!key.equals(keyMany) ? 1 : 0) != 0);
        keyMany.setAxis(0, 1);
        keyMany.setAxis(1, 3);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(keyMany));
        copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
    }

    public void testThree() {
        CellKey keyMany = CellKey.Generator.newManyCellKey(3);
        CellKey key = CellKey.Generator.newCellKey(3);
        CellKeyTest.assertTrue((String)"CellKey size", (key.size() == 3 ? 1 : 0) != 0);
        CellKeyTest.assertTrue((String)"CellKey size", (keyMany.size() == 3 ? 1 : 0) != 0);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(keyMany));
        CellKey copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        int[] ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        boolean gotException = false;
        try {
            key.setAxis(3, 1);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey axis too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[4]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too big", (boolean)gotException);
        gotException = false;
        try {
            key.setOrdinals(new int[1]);
        }
        catch (Exception ex) {
            gotException = true;
        }
        CellKeyTest.assertTrue((String)"CellKey array too small", (boolean)gotException);
        key.setAxis(0, 1);
        key.setAxis(1, 3);
        key.setAxis(2, 5);
        CellKeyTest.assertTrue((String)"CellKey not equals", (!key.equals(keyMany) ? 1 : 0) != 0);
        keyMany.setAxis(0, 1);
        keyMany.setAxis(1, 3);
        keyMany.setAxis(2, 5);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(keyMany));
        copy = key.copy();
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
        ordinals = key.getOrdinals();
        copy = CellKey.Generator.newCellKey(ordinals);
        CellKeyTest.assertTrue((String)"CellKey equals", (boolean)key.equals(copy));
    }

    public void testCellLookup() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String cubeDef = "<Cube name = \"SalesTest\" defaultMeasure=\"Unit Sales\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"City\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n      <Table name=\"customer\"/>\n      <Level name=\"city\" column=\"city\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Gender\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n      <Table name=\"customer\"/>\n      <Level name=\"gender\" column=\"gender\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Address2\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n      <Table name=\"customer\"/>\n      <Level name=\"addr\" column=\"address2\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n</Cube>";
        String query = "With Set [*NATIVE_CJ_SET] as NonEmptyCrossJoin([Gender].Children, [Address2].Children) Select Generate([*NATIVE_CJ_SET], {([Gender].CurrentMember, [Address2].CurrentMember)}) on columns From [SalesTest] where ([City].[Redwood City])";
        String result = "Axis #0:\n{[City].[All Citys].[Redwood City]}\nAxis #1:\n{[Gender].[All Genders].[F], [Address2].[All Address2s].[#null]}\n{[Gender].[All Genders].[F], [Address2].[All Address2s].[#2]}\n{[Gender].[All Genders].[F], [Address2].[All Address2s].[Unit H103]}\n{[Gender].[All Genders].[M], [Address2].[All Address2s].[#null]}\n{[Gender].[All Genders].[M], [Address2].[All Address2s].[#208]}\nRow #0: 71\nRow #0: 10\nRow #0: 3\nRow #0: 52\nRow #0: 8\n";
        boolean origExpandNonNative = MondrianProperties.instance().ExpandNonNative.get();
        MondrianProperties.instance().ExpandNonNative.set(false);
        TestContext testContext = TestContext.create(null, cubeDef, null, null, null, null);
        testContext.assertQueryReturns(query, CellKeyTest.fold(result));
        MondrianProperties.instance().ExpandNonNative.set(origExpandNonNative);
    }
}

