/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFileIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 1L;
    private transient WizardDescriptor.Iterator<WizardDescriptor> simpleIterator;
    private transient WizardDescriptor.Panel<WizardDescriptor> panel;
    private transient WizardDescriptor wiz;
    private transient Project currentProject;
    private transient boolean isFolder;

    private NewFileIterator(boolean bl) {
        this.isFolder = bl;
    }

    public static NewFileIterator genericFileIterator() {
        return new NewFileIterator(false);
    }

    public static NewFileIterator folderIterator() {
        return new NewFileIterator(true);
    }

    public static NewFileIterator emptyFileIterator() {
        return new NewFileIterator(false);
    }

    private WizardDescriptor.Iterator<WizardDescriptor> getSimpleIterator() {
        if (this.simpleIterator == null) {
            assert (this.panel != null);
            this.simpleIterator = new WizardDescriptor.ArrayIterator(Collections.singletonList(this.panel));
        }
        return this.simpleIterator;
    }

    private WizardDescriptor.Panel<WizardDescriptor> getPanel(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        assert (project != null) : wizardDescriptor;
        if (!project.equals(this.currentProject) || this.panel == null) {
            this.currentProject = project;
            Sources sources = ProjectUtils.getSources((Project)project);
            this.panel = this.isFolder ? new SimpleTargetChooserPanel(project, sources.getSourceGroups("generic"), null, true) : Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sources.getSourceGroups("generic"));
        }
        return this.panel;
    }

    private String[] createSteps(String[] stringArray) {
        assert (this.panel != null);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panel.getComponent().getName();
        }
        return stringArray2;
    }

    public Set instantiate() throws IOException {
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wiz));
        return Collections.singleton(dataObject2.getPrimaryFile());
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.panel = this.getPanel(wizardDescriptor);
        this.wiz = wizardDescriptor;
        String[] stringArray = null;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray);
        for (int i = 0; i < 1; ++i) {
            Component component = this.panel.getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.simpleIterator = null;
        this.wiz = null;
        this.panel = null;
    }

    public String name() {
        return this.getSimpleIterator().name();
    }

    public boolean hasNext() {
        return this.getSimpleIterator().hasNext();
    }

    public boolean hasPrevious() {
        return this.getSimpleIterator().hasPrevious();
    }

    public void nextPanel() {
        this.getSimpleIterator().nextPanel();
    }

    public void previousPanel() {
        this.getSimpleIterator().previousPanel();
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getSimpleIterator().current();
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.getSimpleIterator().addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.getSimpleIterator().removeChangeListener(changeListener);
    }
}

