/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataObject;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionItems
implements Iterable<SQLCompletionItem> {
    private final List<SQLCompletionItem> items = new ArrayList<SQLCompletionItem>();
    private final SQLIdentifiers.Quoter quoter;
    private final int itemOffset;

    public SQLCompletionItems(SQLIdentifiers.Quoter quoter, int n) {
        this.quoter = quoter;
        this.itemOffset = n;
    }

    public Set<String> addCatalogs(Metadata metadata, Set<String> set, String string, final boolean bl, final int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(metadata.getCatalogs(), set, string, new Handler<Catalog>(){

            @Override
            public void handle(Catalog catalog) {
                String string = catalog.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.catalog(string, SQLCompletionItems.this.doQuote(string, bl), SQLCompletionItems.this.itemOffset + n));
            }
        });
        return treeSet;
    }

    public Set<String> addSchemas(Catalog catalog, Set<String> set, String string, final boolean bl, final int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(catalog.getSchemas(), set, string, new Handler<Schema>(){

            @Override
            public void handle(Schema schema) {
                if (!schema.isSynthetic()) {
                    String string = schema.getName();
                    SQLCompletionItems.this.items.add(SQLCompletionItem.schema(string, SQLCompletionItems.this.doQuote(string, bl), SQLCompletionItems.this.itemOffset + n));
                }
            }
        });
        return treeSet;
    }

    public void addTables(Schema schema, Set<String> set, String string, final boolean bl, final int n) {
        SQLCompletionItems.filterMetadata(schema.getTables(), set, string, new Handler<Table>(){

            @Override
            public void handle(Table table) {
                String string = table.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.table(string, SQLCompletionItems.this.doQuote(string, bl), SQLCompletionItems.this.itemOffset + n));
            }
        });
    }

    public void addAliases(Map<String, QualIdent> map, String string, boolean bl, final int n) {
        SQLCompletionItems.filterMap(map, null, string, new ParamHandler<String, QualIdent>(){

            @Override
            public void handle(String string, QualIdent qualIdent) {
                SQLCompletionItems.this.items.add(SQLCompletionItem.alias(string, qualIdent, string, SQLCompletionItems.this.itemOffset + n));
            }
        });
    }

    public void addColumns(Table table, String string, final boolean bl, final int n) {
        Schema schema = table.getParent();
        Catalog catalog = schema.getParent();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (!catalog.isDefault()) {
            arrayList.add(catalog.getName());
        }
        if (!schema.isSynthetic() && !schema.isDefault()) {
            arrayList.add(schema.getName());
        }
        arrayList.add(table.getName());
        final QualIdent qualIdent = new QualIdent(arrayList);
        SQLCompletionItems.filterMetadata(table.getColumns(), null, string, new Handler<Column>(){

            @Override
            public void handle(Column column) {
                String string = column.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.column(qualIdent, string, SQLCompletionItems.this.doQuote(string, bl), SQLCompletionItems.this.itemOffset + n));
            }
        });
    }

    public void fill(CompletionResultSet completionResultSet) {
        completionResultSet.addAllItems(this.items);
    }

    @Override
    public Iterator<SQLCompletionItem> iterator() {
        return this.items.iterator();
    }

    private String doQuote(String string, boolean bl) {
        if (bl) {
            return this.quoter.quoteAlways(string);
        }
        return this.quoter.quoteIfNeeded(string);
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    private static boolean filter(String string, String string2) {
        return string2 == null || SQLCompletionItems.startsWithIgnoreCase(string, string2);
    }

    private static <P> void filterMap(Map<String, P> map, Set<String> set, String string, ParamHandler<String, P> paramHandler) {
        for (Map.Entry<String, P> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (set != null && !set.contains(string2) || !SQLCompletionItems.filter(string2, string)) continue;
            paramHandler.handle(string2, entry.getValue());
        }
    }

    private static <T extends MetadataObject> void filterMetadata(Collection<T> collection, Set<String> set, String string, Handler<T> handler) {
        for (MetadataObject metadataObject : collection) {
            String string2 = metadataObject.getName();
            if (string2 == null || set != null && !set.contains(string2) || !SQLCompletionItems.filter(string2, string)) continue;
            handler.handle(metadataObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParamHandler<T, P> {
        public void handle(T var1, P var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler<T> {
        public void handle(T var1);
    }
}

