/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.DeleteElementUndoableEdit;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;

public class DeletePerformer {
    private List<JRDesignElement> elementsToDelete = new ArrayList<JRDesignElement>();
    private Timer t = null;

    public void deleteElement(JRDesignElement element) {
        if (!this.elementsToDelete.contains(element)) {
            this.elementsToDelete.add(element);
        }
        if (this.t == null) {
            this.t = new Timer();
            this.t.schedule(new TimerTask(){

                public void run() {
                    DeletePerformer.this.deleteElements();
                }
            }, 100L);
        }
    }

    private void deleteElements() {
        ArrayList<JRDesignElement> elements = new ArrayList<JRDesignElement>(this.elementsToDelete);
        this.elementsToDelete.clear();
        this.t = null;
        ArrayList<JRElementGroup> containers = new ArrayList<JRElementGroup>();
        boolean first = true;
        for (JRDesignElement jRDesignElement : elements) {
            JRElementGroup container = jRDesignElement.getElementGroup();
            if (!containers.contains(container)) {
                containers.add(container);
            }
            int index = 0;
            if (container instanceof JRDesignElementGroup) {
                index = ((JRDesignElementGroup)container).getChildren().indexOf(jRDesignElement);
                ((JRDesignElementGroup)container).getChildren().remove(jRDesignElement);
                jRDesignElement.setElementGroup(null);
            }
            if (container instanceof JRDesignFrame) {
                index = ((JRDesignFrame)container).getChildren().indexOf(jRDesignElement);
                ((JRDesignFrame)container).getChildren().remove(jRDesignElement);
                jRDesignElement.setElementGroup(null);
            }
            DeleteElementUndoableEdit edit = new DeleteElementUndoableEdit(jRDesignElement, container, index);
            IReportManager.getInstance().addUndoableEdit(edit, !first);
            first = false;
        }
        for (Object e : containers) {
            if (e instanceof JRDesignElementGroup) {
                ((JRDesignElementGroup)e).getEventSupport().firePropertyChange("children", null, (Object)0);
                continue;
            }
            if (e instanceof JRDesignFrame) {
                ((JRDesignFrame)e).getEventSupport().firePropertyChange("children", null, (Object)0);
                continue;
            }
            System.out.println("Unknown container: " + e);
        }
    }
}

