/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.undo.AddElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AddElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

public class ElementPasteType
extends PasteType {
    private static Node[] lastPastedNodes = null;
    private static List movingObjects = new ArrayList();
    private static Point boxTopLeft = null;
    JRElementGroup newContainer = null;
    JRElementGroup oldContainer = null;
    Object element = null;
    int dropAction = 0;
    Node destinatioNode = null;
    AggregatedUndoableEdit unduableEdit = new AggregatedUndoableEdit("paste");

    public static void setLastPastedNodes(Node[] dropNodes) {
        lastPastedNodes = dropNodes;
    }

    public static Node[] getLastPastedNodes() {
        return lastPastedNodes;
    }

    public ElementPasteType(JRElementGroup oldContainer, JRElementGroup newContainer, Object element, int dropAction, Node destinatioNode) {
        this.oldContainer = oldContainer;
        this.newContainer = newContainer;
        this.element = element;
        this.dropAction = dropAction;
        this.destinatioNode = destinatioNode;
    }

    public Transferable paste() throws IOException {
        Object ele;
        List list = this.newContainer.getChildren();
        int currentIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            ele = list.get(i);
            if (ele != this.element) continue;
            currentIndex = i;
        }
        if ((this.dropAction & 6) != 0) {
            this.calculateNewBoxTopLeft();
            if (boxTopLeft != null) {
                this.adjustPosition(this.element);
                movingObjects.remove(this.element);
            }
            int newIndex = -1;
            if (currentIndex == -1) {
                Node[] nodes = this.destinatioNode.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i] instanceof ElementNode && ((ElementNode)nodes[i]).getElement() == this.element) {
                        newIndex = i;
                        break;
                    }
                    if (!(nodes[i] instanceof ElementGroupNode) || ((ElementGroupNode)nodes[i]).getElementGroup() != this.element) continue;
                    newIndex = i;
                    break;
                }
                if (this.element instanceof JRDesignElement) {
                    this.removeElement(this.oldContainer, (JRDesignElement)this.element);
                } else if (this.element instanceof JRDesignElementGroup) {
                    this.removeElementGroup(this.oldContainer, (JRDesignElementGroup)this.element);
                }
                if (newIndex == -1) {
                    if (this.element instanceof JRDesignElement) {
                        this.addElement(this.newContainer, (JRDesignElement)this.element);
                    } else if (this.element instanceof JRDesignElementGroup) {
                        this.addElementGroup(this.newContainer, (JRDesignElementGroup)this.element);
                    }
                } else {
                    if (this.element instanceof JRDesignElement) {
                        ((JRDesignElement)this.element).setElementGroup(this.newContainer);
                    } else if (this.element instanceof JRDesignElementGroup) {
                        ((JRDesignElementGroup)this.element).setElementGroup(this.newContainer);
                    }
                    this.newContainer.getChildren().add(newIndex, this.element);
                    this.getEventSupport(this.newContainer).fireCollectionElementAddedEvent("children", this.element, this.newContainer.getChildren().size() - 1);
                    IReportManager.getInstance().setSelectedObject(this.element);
                }
            }
        } else if (this.element instanceof JRCloneable) {
            Object newElement = ((JRCloneable)this.element).clone();
            this.calculateNewBoxTopLeft();
            if (boxTopLeft != null) {
                this.adjustPosition(newElement);
                movingObjects.remove(this.element);
            }
            if (newElement instanceof JRDesignElement) {
                ele = (JRDesignElement)newElement;
                ele.setX(ele.getX() + 10);
                ele.setY(ele.getY() + 10);
                this.addElement(this.newContainer, (JRDesignElement)newElement);
            } else if (newElement instanceof JRDesignElementGroup) {
                this.addElementGroup(this.newContainer, (JRDesignElementGroup)newElement);
            }
            IReportManager.getInstance().addSelectedObject(newElement);
            IReportManager.getInstance().removeSelectedObject(this.element);
        }
        if (this.unduableEdit.getAggregatedEditCount() > 0) {
            IReportManager.getInstance().addUndoableEdit(this.unduableEdit, true);
        }
        return null;
    }

    private void adjustPosition(Object elementToAdjust) {
        if (elementToAdjust instanceof JRDesignElement) {
            this.adjustPositionElement((JRDesignElement)elementToAdjust);
        } else if (elementToAdjust instanceof JRDesignElementGroup) {
            List children = ((JRDesignElementGroup)elementToAdjust).getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.adjustPosition(children.get(i));
            }
        }
    }

    private void adjustPositionElement(JRDesignElement ele) {
        ele.setX(ele.getX() - ElementPasteType.boxTopLeft.x);
        ObjectPropertyUndoableEdit edit = new ObjectPropertyUndoableEdit(this.element, "X", Integer.TYPE, ele.getX() + ElementPasteType.boxTopLeft.x, ele.getX());
        this.unduableEdit.concatenate(edit);
        ele.setY(ele.getY() - ElementPasteType.boxTopLeft.y);
        edit = new ObjectPropertyUndoableEdit(this.element, "Y", Integer.TYPE, ele.getY() + ElementPasteType.boxTopLeft.y, ele.getY());
        this.unduableEdit.concatenate(edit);
    }

    private void calculateNewBoxTopLeft() {
        boolean sameContainer;
        if (movingObjects.size() > 0) {
            return;
        }
        boxTopLeft = null;
        Node[] nodes = ElementPasteType.getLastPastedNodes();
        boolean bl = sameContainer = this.oldContainer == this.newContainer;
        if (sameContainer) {
            boxTopLeft = new Point(0, 0);
        }
        for (int i = 0; nodes != null && i < nodes.length; ++i) {
            JRDesignElement ele;
            IRIndexedNode node;
            if (nodes[i] instanceof ElementNode) {
                node = (ElementNode)nodes[i];
                ele = ((ElementNode)node).getElement();
                if (!sameContainer) {
                    if (boxTopLeft == null) {
                        boxTopLeft = new Point(ele.getX(), ele.getY());
                    } else {
                        ElementPasteType.boxTopLeft.x = Math.min(ElementPasteType.boxTopLeft.x, ele.getX());
                        ElementPasteType.boxTopLeft.y = Math.min(ElementPasteType.boxTopLeft.y, ele.getY());
                    }
                }
                movingObjects.add(((ElementNode)node).getElement());
                continue;
            }
            if (!(nodes[i] instanceof ElementGroupNode)) continue;
            node = (ElementGroupNode)nodes[i];
            ele = ((ElementGroupNode)node).getElementGroup();
            if (!sameContainer) {
                Point p = this.getMinXY(ele.getChildren());
                if (boxTopLeft == null) {
                    boxTopLeft = p;
                } else {
                    ElementPasteType.boxTopLeft.x = Math.min(ElementPasteType.boxTopLeft.x, p.x);
                    ElementPasteType.boxTopLeft.y = Math.min(ElementPasteType.boxTopLeft.y, p.y);
                }
            }
            movingObjects.add(ele);
        }
    }

    private Point getMinXY(List elems) {
        Point minTopLeft = null;
        for (int i = 0; i < elems.size(); ++i) {
            JRDesignElement ele;
            if (elems.get(i) instanceof JRDesignElement) {
                ele = (JRDesignElement)elems.get(i);
                if (minTopLeft == null) {
                    minTopLeft = new Point(ele.getX(), ele.getY());
                    continue;
                }
                minTopLeft.x = Math.min(minTopLeft.x, ele.getX());
                minTopLeft.y = Math.min(minTopLeft.y, ele.getY());
                continue;
            }
            if (!(elems.get(i) instanceof JRDesignElementGroup)) continue;
            ele = (JRDesignElementGroup)elems.get(i);
            Point p = this.getMinXY(ele.getChildren());
            if (minTopLeft == null) {
                minTopLeft = p;
                continue;
            }
            minTopLeft.x = Math.min(minTopLeft.x, p.x);
            minTopLeft.y = Math.min(minTopLeft.y, p.y);
        }
        return minTopLeft;
    }

    private void removeElement(JRElementGroup container, JRDesignElement element) {
        int index = 0;
        if (container instanceof JRDesignElementGroup) {
            index = ((JRDesignElementGroup)container).getChildren().indexOf(element);
            ((JRDesignElementGroup)container).removeElement(element);
        } else if (container instanceof JRDesignFrame) {
            index = ((JRDesignFrame)container).getChildren().indexOf(element);
            ((JRDesignFrame)container).removeElement((JRElement)element);
        }
        DeleteElementUndoableEdit edit = new DeleteElementUndoableEdit(element, container, index);
        this.unduableEdit.concatenate(edit);
    }

    private void removeElementGroup(JRElementGroup container, JRDesignElementGroup group) {
        int index = 0;
        if (container instanceof JRDesignElementGroup) {
            index = ((JRDesignElementGroup)container).getChildren().indexOf(group);
            ((JRDesignElementGroup)container).removeElementGroup(group);
        } else if (container instanceof JRDesignFrame) {
            index = ((JRDesignFrame)container).getChildren().indexOf(group);
            ((JRDesignFrame)container).removeElementGroup((JRElementGroup)group);
        }
        DeleteElementGroupUndoableEdit edit = new DeleteElementGroupUndoableEdit(group, container, index);
        this.unduableEdit.concatenate(edit);
    }

    private void addElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).addElement(element);
        } else if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).addElement((JRElement)element);
        }
        AddElementUndoableEdit edit = new AddElementUndoableEdit(element, container);
        this.unduableEdit.concatenate(edit);
    }

    private void addElementGroup(JRElementGroup container, JRDesignElementGroup group) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).addElementGroup(group);
        } else if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).addElementGroup((JRElementGroup)group);
        }
        AddElementGroupUndoableEdit edit = new AddElementGroupUndoableEdit(group, container);
        this.unduableEdit.concatenate(edit);
    }

    private JRPropertyChangeSupport getEventSupport(JRElementGroup container) {
        if (container instanceof JRDesignElementGroup) {
            return ((JRDesignElementGroup)container).getEventSupport();
        }
        if (container instanceof JRDesignFrame) {
            return ((JRDesignFrame)container).getEventSupport();
        }
        return null;
    }
}

