/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.fonts.InstallFontVisualPanel1TTFSelection;
import com.jaspersoft.ireport.designer.fonts.InstallFontWizardDescriptor;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public class InstallFontWizardPanel2TTFSelection
implements WizardDescriptor.AsynchronousValidatingPanel {
    private InstallFontWizardDescriptor wizard = null;
    private InstallFontVisualPanel1TTFSelection component;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public InstallFontWizardPanel2TTFSelection(InstallFontWizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new InstallFontVisualPanel1TTFSelection(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        try {
            this.component.validateForm();
            this.getWizard().putProperty("WizardPanel_errorMessage", null);
            return true;
        }
        catch (Exception ex) {
            this.getWizard().putProperty("WizardPanel_errorMessage", ex.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        this.component.readSettings(settings);
    }

    public void storeSettings(Object settings) {
        this.component.storeSettings(settings);
    }

    public InstallFontWizardDescriptor getWizard() {
        return this.wizard;
    }

    public void setWizard(InstallFontWizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void prepareValidation() {
    }

    public void validate() throws WizardValidationException {
        File file = new File("" + this.getWizard().getProperty("normal_ttf_file"));
        if (!file.exists()) {
            String err = "Unable to file the file: " + file.getPath();
            throw new WizardValidationException((JComponent)this.component, err, err);
        }
        Font f = null;
        try {
            f = Font.createFont(0, new FileInputStream(file));
            this.getWizard().putProperty("family_name", f.getFamily());
        }
        catch (IllegalArgumentException ett) {
            String err = ett.getMessage() + " No TrueType font";
            throw new WizardValidationException((JComponent)this.component, err, err);
        }
        catch (FontFormatException ef) {
            String err = ef.getMessage() + " Invalid font.";
            throw new WizardValidationException((JComponent)this.component, err, err);
        }
        catch (IOException ioex) {
            String err = ioex.getMessage() + " Error loading the file.";
            throw new WizardValidationException((JComponent)this.component, err, err);
        }
        catch (Exception ex) {
            String err = ex.getMessage() + " Unknown error.";
            throw new WizardValidationException((JComponent)this.component, err, err);
        }
    }
}

