/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseContext
extends DatabaseItem {
    private DatabaseContext parent;
    private String type;
    private List<DatabaseUsage> usages;
    private List<DatabaseContext> contexts;
    private List<DatabaseDefinition> definitions;
    private boolean usagesSorted = false;
    private boolean contextsSorted = false;
    private boolean definitionsSorted = false;
    private DatabaseDefinition enclosingDefinition;
    private List<DatabaseDefinition> definitionsCache;

    public DatabaseContext(DatabaseContext databaseContext, String string, int n, int n2) {
        super(n, n2);
        this.parent = databaseContext;
        this.type = string;
    }

    protected void setParent(DatabaseContext databaseContext) {
        this.parent = databaseContext;
    }

    public DatabaseContext getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public void setEnclosingDefinition(DatabaseDefinition databaseDefinition) {
        this.enclosingDefinition = databaseDefinition;
    }

    public DatabaseDefinition getEnclosingDefinition() {
        if (this.enclosingDefinition != null) {
            return this.enclosingDefinition;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingDefinition();
        }
        return null;
    }

    public void addDefinition(DatabaseDefinition databaseDefinition) {
        this.definitionsCache = null;
        if (this.definitions == null) {
            this.definitions = new ArrayList<DatabaseDefinition>();
        }
        this.definitions.add(databaseDefinition);
        this.definitionsSorted = false;
    }

    public void addUsage(DatabaseUsage databaseUsage) {
        if (this.usages == null) {
            this.usages = new ArrayList<DatabaseUsage>();
        }
        this.usages.add(databaseUsage);
        this.usagesSorted = false;
    }

    public void addUsage(ASTToken aSTToken, DatabaseDefinition databaseDefinition) {
        DatabaseUsage databaseUsage = new DatabaseUsage("", aSTToken.getOffset(), aSTToken.getEndOffset());
        databaseDefinition.addUsage(databaseUsage);
        databaseUsage.setDatabaseDefinition(databaseDefinition);
        this.addUsage(databaseUsage);
    }

    public void addContext(ASTItem aSTItem, DatabaseContext databaseContext) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<DatabaseContext>();
        }
        this.contexts.add(databaseContext);
        this.contextsSorted = false;
    }

    private void addItem(DatabaseItem databaseItem) {
        if (databaseItem instanceof DatabaseUsage) {
            this.addUsage((DatabaseUsage)databaseItem);
        } else if (databaseItem instanceof DatabaseDefinition) {
            this.addDefinition((DatabaseDefinition)databaseItem);
        } else if (databaseItem instanceof DatabaseContext) {
            this.addContext(null, (DatabaseContext)databaseItem);
        }
    }

    public List<DatabaseDefinition> getDefinitions() {
        if (this.definitionsCache == null) {
            if (this.definitions == null) {
                this.definitionsCache = Collections.emptyList();
            } else {
                this.definitionsCache = new ArrayList<DatabaseDefinition>();
                Iterator<DatabaseDefinition> iterator = this.definitions.iterator();
                while (iterator.hasNext()) {
                    this.definitionsCache.add(iterator.next());
                }
            }
        }
        return this.definitionsCache;
    }

    public List<DatabaseDefinition> getAllVisibleDefinitions(int n) {
        HashMap<String, DatabaseDefinition> hashMap = new HashMap<String, DatabaseDefinition>();
        this.addDefinitions(hashMap, n);
        return new ArrayList<DatabaseDefinition>(hashMap.values());
    }

    private void addDefinitions(Map<String, DatabaseDefinition> map, int n) {
        if (this.definitions != null) {
            for (DatabaseDefinition databaseItem : this.definitions) {
                map.put(databaseItem.getName(), databaseItem);
            }
        }
        if (this.contexts != null) {
            for (DatabaseContext databaseContext : this.contexts) {
                if (databaseContext.getOffset() > n || n >= databaseContext.getEndOffset()) continue;
                databaseContext.addDefinitions(map, n);
            }
        }
    }

    public DatabaseItem getDatabaseItem(int n) {
        DatabaseItem databaseItem;
        int n2;
        int n3;
        int n4;
        if (this.definitions != null) {
            if (!this.definitionsSorted) {
                Collections.sort(this.definitions, new ItemsComparator());
                this.definitionsSorted = true;
            }
            n4 = 0;
            n3 = this.definitions.size() - 1;
            while (n4 <= n3) {
                n2 = n4 + n3 >> 1;
                databaseItem = this.definitions.get(n2);
                if (n < databaseItem.getOffset()) {
                    n3 = n2 - 1;
                    continue;
                }
                if (n >= databaseItem.getEndOffset()) {
                    n4 = n2 + 1;
                    continue;
                }
                return databaseItem;
            }
        }
        if (this.usages != null) {
            if (!this.usagesSorted) {
                Collections.sort(this.usages, new ItemsComparator());
                this.usagesSorted = true;
            }
            n4 = 0;
            n3 = this.usages.size() - 1;
            while (n4 <= n3) {
                n2 = n4 + n3 >> 1;
                databaseItem = this.usages.get(n2);
                if (n < databaseItem.getOffset()) {
                    n3 = n2 - 1;
                    continue;
                }
                if (n >= databaseItem.getEndOffset()) {
                    n4 = n2 + 1;
                    continue;
                }
                return databaseItem;
            }
        }
        if (this.contexts != null) {
            if (!this.contextsSorted) {
                Collections.sort(this.contexts, new ItemsComparator());
                this.contextsSorted = true;
            }
            n4 = 0;
            n3 = this.contexts.size() - 1;
            while (n4 <= n3) {
                n2 = n4 + n3 >> 1;
                databaseItem = this.contexts.get(n2);
                if (n < databaseItem.getOffset()) {
                    n3 = n2 - 1;
                    continue;
                }
                if (n >= databaseItem.getEndOffset()) {
                    n4 = n2 + 1;
                    continue;
                }
                return ((DatabaseContext)databaseItem).getDatabaseItem(n);
            }
        }
        return null;
    }

    public DatabaseContext getDatabaseContext(int n) {
        if (this.contexts == null || this.contexts.isEmpty()) {
            return this;
        }
        if (!this.contextsSorted) {
            Collections.sort(this.contexts, new ItemsComparator());
        }
        this.contextsSorted = true;
        int n2 = 0;
        int n3 = this.contexts.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            DatabaseContext databaseContext = this.contexts.get(n4);
            if (n < databaseContext.getOffset()) {
                n3 = n4 - 1;
                continue;
            }
            if (n >= databaseContext.getEndOffset()) {
                n2 = n4 + 1;
                continue;
            }
            DatabaseContext databaseContext2 = databaseContext.getDatabaseContext(n);
            if (databaseContext2 == null) {
                return databaseContext;
            }
            return databaseContext2;
        }
        return this;
    }

    public DatabaseDefinition getDefinition(String string, int n) {
        if (this.definitions != null) {
            if (!this.definitionsSorted) {
                Collections.sort(this.definitions, new ItemsComparator());
            }
            this.definitionsSorted = true;
            for (DatabaseDefinition databaseDefinition : this.definitions) {
                if (!databaseDefinition.getName().equals(string)) continue;
                return databaseDefinition;
            }
        }
        if (this.parent != null) {
            return this.parent.getDefinition(string, n);
        }
        return null;
    }

    public List<DatabaseContext> getContexts() {
        if (this.contexts == null) {
            return Collections.emptyList();
        }
        return this.contexts;
    }

    public void addContext(DatabaseContext databaseContext) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<DatabaseContext>();
        }
        databaseContext.setParent(this);
        this.contexts.add(databaseContext);
    }

    public DatabaseContext getClosestContext(int n) {
        DatabaseContext databaseContext = null;
        if (this.contexts != null) {
            for (DatabaseContext databaseContext2 : this.contexts) {
                if (!databaseContext2.contains(n)) continue;
                databaseContext = databaseContext2.getClosestContext(n);
                break;
            }
        }
        if (databaseContext != null) {
            return databaseContext;
        }
        if (this.contains(n)) {
            return this;
        }
        return null;
    }

    private boolean contains(int n) {
        return n >= this.getOffset() && n < this.getEndOffset();
    }

    public <T extends DatabaseDefinition> T getFirstDefinition(Class<T> clazz) {
        if (this.definitions == null) {
            return null;
        }
        for (DatabaseDefinition databaseDefinition : this.definitions) {
            if (!clazz.isInstance(databaseDefinition)) continue;
            return (T)databaseDefinition;
        }
        return null;
    }

    public <T extends DatabaseDefinition> Collection<T> getDefinitions(Class<T> clazz) {
        if (this.definitions == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseDefinition> arrayList = new ArrayList<DatabaseDefinition>();
        for (DatabaseDefinition databaseDefinition : this.definitions) {
            if (!clazz.isInstance(databaseDefinition)) continue;
            arrayList.add(databaseDefinition);
        }
        return arrayList;
    }

    public void collectDefinitionsInScope(Collection<DatabaseDefinition> collection) {
        if (this.definitions != null) {
            collection.addAll(this.definitions);
        }
        if (this.parent != null) {
            this.parent.collectDefinitionsInScope(collection);
        }
    }

    public <T extends DatabaseDefinition> T getDefinitionInScopeByName(Class<T> clazz, String string) {
        DatabaseDefinition databaseDefinition = null;
        if (this.definitions != null) {
            for (DatabaseDefinition databaseDefinition2 : this.definitions) {
                if (!clazz.isInstance(databaseDefinition2) || !string.equals(databaseDefinition2.getName())) continue;
                databaseDefinition = databaseDefinition2;
                break;
            }
        }
        if (databaseDefinition != null) {
            return (T)databaseDefinition;
        }
        if (this.parent != null) {
            return this.parent.getDefinitionInScopeByName(clazz, string);
        }
        return null;
    }

    public <T extends DatabaseDefinition> T getEnclosingDefinition(Class<T> clazz, int n) {
        DatabaseContext databaseContext = this.getClosestContext(n);
        return databaseContext.getEnclosingDefinitionRecursively(clazz);
    }

    public <T extends DatabaseDefinition> T getEnclosingDefinition(Class<T> clazz) {
        return this.getEnclosingDefinitionRecursively(clazz);
    }

    private <T extends DatabaseDefinition> T getEnclosingDefinitionRecursively(Class<T> clazz) {
        DatabaseDefinition databaseDefinition = this.getEnclosingDefinition();
        if (databaseDefinition != null && clazz.isInstance(databaseDefinition)) {
            return (T)databaseDefinition;
        }
        DatabaseContext databaseContext = this.getParent();
        if (databaseContext != null) {
            return databaseContext.getEnclosingDefinition(clazz);
        }
        return null;
    }

    public String toString() {
        return "Context " + this.getOffset() + "-" + this.getEndOffset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ItemsComparator
    implements Comparator<DatabaseItem> {
        private ItemsComparator() {
        }

        @Override
        public int compare(DatabaseItem databaseItem, DatabaseItem databaseItem2) {
            return databaseItem.getOffset() < databaseItem2.getOffset() ? -1 : 1;
        }
    }
}

