/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.ServerDialog;
import com.jaspersoft.ireport.jasperserver.ui.actions.PublishReportUnitAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.RunReportUnitButton;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ServerChildren;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RepositoryTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static RepositoryTopComponent instance;
    private final ExplorerManager manager = new ExplorerManager();
    private static final String PREFERRED_ID = "RepositoryTopComponent";
    private JButton jButtonAddServer;
    private JToolBar jToolBar1;

    private RepositoryTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(RepositoryTopComponent.class, (String)"CTL_RepositoryTopComponent"));
        this.setToolTipText(NbBundle.getMessage(RepositoryTopComponent.class, (String)"HINT_RepositoryTopComponent"));
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        BeanTreeView view = new BeanTreeView();
        view.setRootVisible(false);
        this.manager.setRootContext((Node)new AbstractNode((Children)new ServerChildren()));
        this.add((Component)view, "Center");
        this.jToolBar1.add((Action)SystemAction.get(PublishReportUnitAction.class));
        this.jToolBar1.add(((RunReportUnitButton)SystemAction.get(RunReportUnitButton.class)).createContextAwareInstance(Utilities.actionsGlobalContext()));
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonAddServer = new JButton();
        this.setLayout(new BorderLayout());
        this.jButtonAddServer.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/server_add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddServer, (String)"\n");
        this.jButtonAddServer.setToolTipText("Add new server");
        this.jButtonAddServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryTopComponent.this.jButtonAddServerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddServer);
        this.add(this.jToolBar1, "North");
    }

    private void jButtonAddServerActionPerformed(ActionEvent evt) {
        ServerDialog sd = new ServerDialog(Misc.getMainFrame(), true);
        sd.setVisible(true);
        if (sd.getDialogResult() == 0) {
            JasperServerManager.getMainInstance().getJServers().add(sd.getJServer());
            JasperServerManager.getMainInstance().saveConfiguration();
            ((ServerChildren)this.getExplorerManager().getRootContext().getChildren()).recalculateKeys();
        }
    }

    public static synchronized RepositoryTopComponent getDefault() {
        if (instance == null) {
            instance = new RepositoryTopComponent();
        }
        return instance;
    }

    public static synchronized RepositoryTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(RepositoryTopComponent.class.getName()).warning("Cannot find RepositoryTopComponent component. It will not be located properly in the window system.");
            return RepositoryTopComponent.getDefault();
        }
        if (win instanceof RepositoryTopComponent) {
            return (RepositoryTopComponent)win;
        }
        Logger.getLogger(RepositoryTopComponent.class.getName()).warning("There seem to be multiple components with the 'RepositoryTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return RepositoryTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return RepositoryTopComponent.getDefault();
        }
    }
}

