/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.design.JRDesignElement;

    
/**
 *  Class to manage the JRDesignElement.PROPERTY_WIDTH property
 */
public final class WidthProperty extends IntegerProperty
{
    private final JRDesignElement element;

    @SuppressWarnings("unchecked")
    public WidthProperty(JRDesignElement element)
    {
        super(element);
        this.element = element;
    }

    @Override
    public String getName()
    {
        return JRDesignElement.PROPERTY_WIDTH;
    }

    @Override
    public String getDisplayName()
    {
        return I18n.getString("Global.Property.Width");
    }

    @Override
    public String getShortDescription()
    {
        return I18n.getString("Global.Property.Widthdetail");
    }

    @Override
    public Integer getInteger()
    {
        return element.getWidth();
    }

    @Override
    public Integer getOwnInteger()
    {
        return element.getWidth();
    }

    @Override
    public Integer getDefaultInteger()
    {
        return 10;//FIXMETD is this a fair default? do we even have a default?
    }

    @Override
    public void setInteger(Integer width)
    {
        element.setWidth(width);
    }

    @Override
    public void validateInteger(Integer width)
    {
        if (width < 0)
        {
            throw annotateException(I18n.getString("Global.Property.Widthexception"));
        }
    }
}
