/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.DefaultVisuals;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentProvider<T extends JComponent>
implements Serializable {
    protected T rendererComponent;
    protected DefaultVisuals<T> defaultVisuals;
    protected int alignment;
    protected StringValue formatter;

    public ComponentProvider() {
        this(null, 10);
    }

    public ComponentProvider(StringValue converter, int alignment) {
        this.setHorizontalAlignment(alignment);
        this.setToStringConverter(converter);
        this.rendererComponent = this.createRendererComponent();
        this.defaultVisuals = this.createRendererController();
    }

    public T getRendererComponent(CellContext context) {
        if (context != null) {
            this.configureVisuals(context);
            this.configureContent(context);
        }
        return this.rendererComponent;
    }

    public void setHorizontalAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public void setToStringConverter(StringValue formatter) {
        if (formatter == null) {
            formatter = StringValue.TO_STRING;
        }
        this.formatter = formatter;
    }

    public StringValue getToStringConverter() {
        return this.formatter;
    }

    public String getStringValue(CellContext context) {
        Object value = null;
        if (context != null) {
            value = context.getValue();
        }
        return this.formatter.getString(value);
    }

    protected String getValueAsString(CellContext context) {
        Object value = context.getValue();
        return this.formatter.getString(value);
    }

    protected Icon getValueAsIcon(CellContext context) {
        Object value = context.getValue();
        if (this.formatter instanceof IconValue) {
            return ((IconValue)((Object)this.formatter)).getIcon(value);
        }
        return null;
    }

    protected void configureVisuals(CellContext context) {
        this.defaultVisuals.configureVisuals(this.rendererComponent, context);
    }

    protected void configureContent(CellContext context) {
        this.configureState(context);
        this.format(context);
    }

    protected abstract void format(CellContext var1);

    protected abstract void configureState(CellContext var1);

    protected abstract T createRendererComponent();

    protected DefaultVisuals<T> createRendererController() {
        return new DefaultVisuals();
    }

    protected DefaultVisuals<T> getRendererController() {
        return this.defaultVisuals;
    }
}

