/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.test.DiffRepository;
import mondrian.test.TestContext;
import mondrian.tui.MockHttpServletRequest;
import mondrian.tui.MockHttpServletResponse;
import mondrian.tui.XmlaSupport;
import mondrian.util.Base64;
import mondrian.xmla.XmlaBaseTestCase;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequestCallback;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaErrorTest
extends XmlaBaseTestCase
implements XmlaConstants {
    private static final String XMLA_DIRECTORY = "testsrc/main/mondrian/xmla/";
    private static final boolean DEBUG = false;
    static boolean doAuthorization = false;
    static String user = null;
    static String password = null;
    private static PrintStream systemErr;

    static boolean isEquals(String s1, String s2) {
        return s1 == s2 || s1 != null && s2 != null && s1.equals(s2);
    }

    static Element[] getChildElements(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nlist = node.getChildNodes();
        int len = nlist.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = nlist.item(i);
            if (!(child instanceof Element)) continue;
            list.add(child);
        }
        return list.toArray(new Element[0]);
    }

    static CharacterData getCharacterData(Node node) {
        NodeList nlist = node.getChildNodes();
        int len = nlist.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = nlist.item(i);
            if (!(child instanceof CharacterData)) continue;
            return (CharacterData)child;
        }
        return null;
    }

    static String getNodeContent(Node n) {
        CharacterData cd = XmlaErrorTest.getCharacterData(n);
        return cd != null ? cd.getData() : null;
    }

    public XmlaErrorTest() {
    }

    public XmlaErrorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        systemErr = System.err;
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
    }

    @Override
    protected void tearDown() throws Exception {
        System.setErr(systemErr);
        super.tearDown();
    }

    @Override
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(XmlaErrorTest.class);
    }

    @Override
    protected Class<? extends XmlaRequestCallback> getServletCallbackClass() {
        return Callback.class;
    }

    @Override
    protected Map<String, String> getCatalogNameUrls(TestContext testContext) {
        if (this.catalogNameUrls == null) {
            String connectString = testContext.getConnectString();
            Util.PropertyList connectProperties = Util.parseConnectString(connectString);
            String catalog = connectProperties.get(RolapConnectionProperties.Catalog.name());
            this.catalogNameUrls = new TreeMap();
            this.catalogNameUrls.put("FoodMart", catalog);
        }
        return this.catalogNameUrls;
    }

    public void testJunk() throws Exception {
        String reqFileName = "Junk_in.error";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00USMC02"), "DOM parse errors occur", "Mondrian", "http://mondrian.sourceforge.net", "00USMC02", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadXml01() throws Exception {
        String reqFileName = "BadXml01_in.error";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00USMC02"), "DOM parse errors occur", "Mondrian", "http://mondrian.sourceforge.net", "00USMC02", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadXml02() throws Exception {
        String reqFileName = "BadXml02_in.error";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00USMC02"), "DOM parse errors occur", "Mondrian", "http://mondrian.sourceforge.net", "00USMC02", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadAction01() throws Exception {
        String reqFileName = "BadAction01_in.error";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBA01"), "SOAP Body not correctly formed", "Mondrian", "http://mondrian.sourceforge.net", "00HSBA01", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadAction02() throws Exception {
        String reqFileName = "BadAction02_in.error";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBA01"), "SOAP Body not correctly formed", "Mondrian", "http://mondrian.sourceforge.net", "00HSBA01", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadAction03() throws Exception {
        String reqFileName = "BadAction03_in.error";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBA01"), "SOAP Body not correctly formed", "Mondrian", "http://mondrian.sourceforge.net", "00HSBA01", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadSoap01() throws Exception {
        String reqFileName = "DoubleHeader.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00USMC02"), "DOM parse errors occur", "Mondrian", "http://mondrian.sourceforge.net", "00USMC02", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadSoap02() throws Exception {
        String reqFileName = "DoubleBody.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00USMC02"), "DOM parse errors occur", "Mondrian", "http://mondrian.sourceforge.net", "00USMC02", null);
        this.doTest(reqFileName, expectedFault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuth01() throws Exception {
        String reqFileName = "EmptyExecute.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00CHHA02"), "Error in Callback processHttpHeader Authorization", "Mondrian", "http://mondrian.sourceforge.net", "00CHHA02", null);
        doAuthorization = true;
        try {
            this.doTest(reqFileName, expectedFault);
        }
        finally {
            this.clearServlet();
            doAuthorization = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuth02() throws Exception {
        String reqFileName = "EmptyExecute.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00CHHA02"), "Error in Callback processHttpHeader Authorization", "Mondrian", "http://mondrian.sourceforge.net", "00CHHA02", null);
        doAuthorization = true;
        String requestText = this.fileToString(reqFileName);
        byte[] reqBytes = requestText.getBytes();
        MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
        req.setMethod("POST");
        req.setContentType("text/xml");
        req.setAuthType("BASIC");
        req.setHeader("Authorization", "BASIC");
        req.setHeader("Authorization", "FOOBAR");
        try {
            this.doTest(req, expectedFault);
        }
        finally {
            this.clearServlet();
            doAuthorization = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuth03() throws Exception {
        String reqFileName = "EmptyExecute.xml";
        Fault expectedFault = null;
        doAuthorization = true;
        String requestText = this.fileToString(reqFileName);
        byte[] reqBytes = requestText.getBytes();
        MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
        req.setMethod("POST");
        req.setContentType("text/xml");
        req.setAuthType("BASIC");
        req.setHeader("Authorization", "BASIC");
        String user = "MY_USER";
        String password = "MY_PASSWORD";
        XmlaErrorTest.user = user;
        XmlaErrorTest.password = password;
        String credential = user + ':' + password;
        String encoded = Base64.encodeBytes(credential.getBytes());
        req.setHeader("Authorization", encoded);
        try {
            this.doTest(req, expectedFault);
            req.setHeader("Expect", "100-continue");
            this.doTest(req, expectedFault);
        }
        finally {
            this.clearServlet();
            doAuthorization = false;
            XmlaErrorTest.user = null;
            XmlaErrorTest.password = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuth04() throws Exception {
        String reqFileName = "EmptyExecute.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00CHHA02"), "Error in Callback processHttpHeader Authorization", "Mondrian", "http://mondrian.sourceforge.net", "00CHHA02", null);
        doAuthorization = true;
        String requestText = this.fileToString(reqFileName);
        byte[] reqBytes = requestText.getBytes();
        MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
        req.setMethod("POST");
        req.setContentType("text/xml");
        req.setAuthType("BASIC");
        req.setHeader("Authorization", "BASIC");
        String user = "MY_USER";
        String password = "MY_PASSWORD";
        XmlaErrorTest.user = user + "FOO";
        XmlaErrorTest.password = password;
        String credential = user + ':' + password;
        String encoded = Base64.encodeBytes(credential.getBytes());
        req.setHeader("Authorization", encoded);
        try {
            this.doTest(req, expectedFault);
        }
        finally {
            this.clearServlet();
            doAuthorization = false;
            XmlaErrorTest.user = null;
            XmlaErrorTest.password = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuth05() throws Exception {
        String reqFileName = "EmptyExecute.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00CHHA02"), "Error in Callback processHttpHeader Authorization", "Mondrian", "http://mondrian.sourceforge.net", "00CHHA02", null);
        doAuthorization = true;
        String requestText = this.fileToString(reqFileName);
        byte[] reqBytes = requestText.getBytes();
        MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
        req.setMethod("POST");
        req.setContentType("text/xml");
        req.setAuthType("BASIC");
        req.setHeader("Authorization", "BASIC");
        String user = "MY_USER";
        String password = "MY_PASSWORD";
        XmlaErrorTest.user = user;
        XmlaErrorTest.password = password + "FOO";
        String credential = user + ':' + password;
        String encoded = Base64.encodeBytes(credential.getBytes());
        req.setHeader("Authorization", encoded);
        try {
            this.doTest(req, expectedFault);
        }
        finally {
            this.clearServlet();
            doAuthorization = false;
            XmlaErrorTest.user = null;
            XmlaErrorTest.password = null;
        }
    }

    public void testBadHeader01() throws Exception {
        String reqFileName = "MustUnderstand.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("MustUnderstand", "00HSHA01"), "SOAP Header must understand element not recognized", "Mondrian", null, null, null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody01() throws Exception {
        String reqFileName = "DiscoveryExecute.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBA01"), "SOAP Body not correctly formed", "Mondrian", "http://mondrian.sourceforge.net", "00HSBA01", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody02() throws Exception {
        String reqFileName = "BadMethod.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBA01"), "SOAP Body not correctly formed", "Mondrian", "http://mondrian.sourceforge.net", "00HSBA01", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody03() throws Exception {
        String reqFileName = "BadMethodNS.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBA01"), "SOAP Body not correctly formed", "Mondrian", "http://mondrian.sourceforge.net", "00HSBA01", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody04() throws Exception {
        String reqFileName = "Discovery01.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB04"), "XMLA SOAP bad Discover RequestType element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB04", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody05() throws Exception {
        String reqFileName = "Discovery02.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB05"), "XMLA SOAP bad Discover Restrictions element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB05", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody06() throws Exception {
        String reqFileName = "Discovery03.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB06"), "XMLA SOAP bad Discover or Execute Properties element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB06", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody07() throws Exception {
        String reqFileName = "Execute01.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB07"), "XMLA SOAP bad Execute Command element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB07", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody08() throws Exception {
        String reqFileName = "Execute02.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB06"), "XMLA SOAP bad Discover or Execute Properties element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB06", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody09() throws Exception {
        String reqFileName = "Discovery04.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB08"), "XMLA SOAP too many Discover RestrictionList element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB08", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody10() throws Exception {
        String reqFileName = "Discovery05.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB09"), "XMLA SOAP bad Discover or Execute PropertyList element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB09", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody11() throws Exception {
        String reqFileName = "Execute03.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB09"), "XMLA SOAP bad Discover or Execute PropertyList element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB09", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody12() throws Exception {
        String reqFileName = "Execute04.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB10"), "XMLA SOAP bad Execute Statement element", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB10", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody13() throws Exception {
        String reqFileName = "Execute05.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB11"), "XMLA SOAP Drilldown Execute Statement non-positive maxrows", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB11", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody14() throws Exception {
        String reqFileName = "Execute06.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB12"), "XMLA SOAP Drilldown Execute Statement non-positive first rowset", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB12", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void testBadBody15() throws Exception {
        String reqFileName = "Execute07.xml";
        Fault expectedFault = new Fault(XmlaException.formatFaultCode("Client", "00HSBB13"), "XMLA SOAP Drilldown Execute Statement error", "Mondrian", "http://mondrian.sourceforge.net", "00HSBB13", null);
        this.doTest(reqFileName, expectedFault);
    }

    public void doTest(MockHttpServletRequest req, Fault expectedFault) throws Exception {
        MockHttpServletResponse res = new MockHttpServletResponse();
        res.setCharacterEncoding("UTF-8");
        Servlet servlet = this.getServlet(this.getTestContext());
        servlet.service((ServletRequest)req, (ServletResponse)res);
        int statusCode = res.getStatusCode();
        if (statusCode == 200) {
            byte[] bytes = res.toByteArray();
            this.processResults(bytes, expectedFault);
        } else if (statusCode == 401) {
            byte[] bytes = res.toByteArray();
            this.processResults(bytes, expectedFault);
        } else if (statusCode == 100) {
            req.clearHeader("Expect");
            req.clearHeader("Authorization");
            doAuthorization = false;
            servlet.service((ServletRequest)req, (ServletResponse)res);
            statusCode = res.getStatusCode();
            if (statusCode == 200) {
                byte[] bytes = res.toByteArray();
                this.processResults(bytes, expectedFault);
            } else {
                XmlaErrorTest.fail((String)("Bad status code: " + statusCode));
            }
        } else {
            XmlaErrorTest.fail((String)("Bad status code: " + statusCode));
        }
    }

    public void doTest(String reqFileName, Fault expectedFault) throws Exception {
        String requestText = this.fileToString(reqFileName);
        Servlet servlet = this.getServlet(this.getTestContext());
        byte[] bytes = XmlaSupport.processSoapXmla(requestText, servlet);
        this.processResults(bytes, expectedFault);
    }

    protected void processResults(byte[] results, Fault expectedFault) throws Exception {
        Node[] fnodes = XmlaSupport.extractFaultNodesFromSoap(results);
        if ((fnodes == null || fnodes.length == 0) && expectedFault != null) {
            XmlaErrorTest.fail((String)"Failed to get SOAP Fault element in SOAP Body node");
        }
        if (expectedFault != null) {
            Fault fault = new Fault(fnodes);
            fault.checkSame(expectedFault);
        }
    }

    @Override
    protected String getSessionId(XmlaBaseTestCase.Action action) {
        return XmlaErrorTest.getSessionId("XmlaExcelXPTest", action);
    }

    static class Fault {
        String faultCode;
        String faultString;
        String faultActor;
        String errorNS;
        String errorCode;
        String errorDesc;

        Fault(String faultCode, String faultString, String faultActor, String errorNS, String errorCode, String errorDesc) {
            this.faultCode = faultCode;
            this.faultString = faultString;
            this.faultActor = faultActor;
            this.errorNS = errorNS;
            this.errorCode = errorCode;
            this.errorDesc = errorDesc;
        }

        Fault(Node[] faultNodes) throws Exception {
            if (faultNodes.length < 3 || faultNodes.length > 4) {
                throw new Exception("SOAP Fault node has " + faultNodes.length + " children");
            }
            Node node = faultNodes[0];
            this.faultCode = XmlaErrorTest.getNodeContent(node);
            node = faultNodes[1];
            this.faultString = XmlaErrorTest.getNodeContent(node);
            node = faultNodes[2];
            this.faultActor = XmlaErrorTest.getNodeContent(node);
            if (faultNodes.length > 3) {
                node = faultNodes[3];
                if ((faultNodes = XmlaErrorTest.getChildElements(node)).length != 1) {
                    throw new Exception("SOAP Fault detail node has " + faultNodes.length + " children");
                }
                node = faultNodes[0];
                this.errorNS = node.getNamespaceURI();
                faultNodes = XmlaErrorTest.getChildElements(node);
                if (faultNodes.length != 2) {
                    throw new Exception("SOAP Fault detail error node has " + faultNodes.length + " children");
                }
                node = faultNodes[0];
                this.errorCode = XmlaErrorTest.getNodeContent(node);
                node = faultNodes[1];
                this.errorDesc = XmlaErrorTest.getNodeContent(node);
            }
        }

        Fault(Node faultNode) throws Exception {
            this(XmlaErrorTest.getChildElements(faultNode));
        }

        String getFaultCode() {
            return this.faultCode;
        }

        String getFaultString() {
            return this.faultString;
        }

        String getFaultActor() {
            return this.faultActor;
        }

        boolean hasDetailError() {
            return this.errorCode != null;
        }

        String getDetailErrorCode() {
            return this.errorCode;
        }

        String getDetailErrorDesc() {
            return this.errorDesc;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(100);
            buf.append("faultCode=");
            buf.append(this.faultCode);
            buf.append(", faultString=");
            buf.append(this.faultString);
            buf.append(", faultActor=");
            buf.append(this.faultActor);
            buf.append(", errorNS=");
            buf.append(this.errorNS);
            buf.append(", errorCode=");
            buf.append(this.errorCode);
            buf.append(", errorDesc=");
            buf.append(this.errorDesc);
            return buf.toString();
        }

        void checkSame(Fault expectedFault) throws Exception {
            if (!XmlaErrorTest.isEquals(this.faultCode, expectedFault.faultCode)) {
                this.notSame("faultcode", this.faultCode, expectedFault.faultCode);
            }
            if (!XmlaErrorTest.isEquals(this.faultString, expectedFault.faultString)) {
                this.notSame("faultstring", this.faultString, expectedFault.faultString);
            }
            if (!XmlaErrorTest.isEquals(this.faultActor, expectedFault.faultActor)) {
                this.notSame("faultactor", this.faultActor, expectedFault.faultActor);
            }
            if (!XmlaErrorTest.isEquals(this.errorNS, expectedFault.errorNS)) {
                throw new Exception("For error element namespace  Expected " + this.errorNS + " but Got " + expectedFault.errorNS);
            }
            if (!XmlaErrorTest.isEquals(this.errorCode, expectedFault.errorCode)) {
                this.notSame("error.code", this.errorCode, expectedFault.errorCode);
            }
        }

        private void notSame(String elementName, String expected, String got) throws Exception {
            throw new Exception("For element " + elementName + " Expected " + expected + " but Got " + got);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Callback
    implements XmlaRequestCallback {
        static String MY_SESSION_ID = "my_session_id";

        Callback() {
        }

        @Override
        public void init(ServletConfig servletConfig) throws ServletException {
        }

        @Override
        public boolean processHttpHeader(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws Exception {
            String expect;
            if (doAuthorization) {
                Enumeration values = request.getHeaders("Authorization");
                if (values == null || !values.hasMoreElements()) {
                    throw XmlaRequestCallback.Helper.authorizationException(new Exception("Authorization: no header value"));
                }
                String authScheme = (String)values.nextElement();
                if (!values.hasMoreElements()) {
                    throw XmlaRequestCallback.Helper.authorizationException(new Exception("Authorization: too few header value"));
                }
                String encoded = (String)values.nextElement();
                byte[] bytes = Base64.decode(encoded);
                String userPass = new String(bytes);
                if (!authScheme.equals("BASIC")) {
                    throw XmlaRequestCallback.Helper.authorizationException(new Exception("Authorization: bad schema: " + authScheme));
                }
                int index = userPass.indexOf(58);
                if (index == -1) {
                    throw XmlaRequestCallback.Helper.authorizationException(new Exception("Authorization: badly formed userPass in encoding: " + encoded));
                }
                String userid = userPass.substring(0, index);
                String password = userPass.substring(index + 1, userPass.length());
                if (!XmlaErrorTest.isEquals(userid, user)) {
                    throw XmlaRequestCallback.Helper.authorizationException(new Exception("Authorization: bad userid: " + userid + " should be: " + user));
                }
                if (!XmlaErrorTest.isEquals(password, XmlaErrorTest.password)) {
                    throw XmlaRequestCallback.Helper.authorizationException(new Exception("Authorization: bad password: " + password + " should be: " + XmlaErrorTest.password));
                }
            }
            if ((expect = request.getHeader("Expect")) != null && expect.equalsIgnoreCase("100-continue")) {
                XmlaRequestCallback.Helper.generatedExpectResponse(request, response, context);
                return false;
            }
            return true;
        }

        @Override
        public void preAction(HttpServletRequest request, Element[] requestSoapParts, Map<String, Object> context) throws Exception {
            context.put(MY_SESSION_ID, XmlaBaseTestCase.getSessionId("XmlaExcelXPTest", XmlaBaseTestCase.Action.CREATE));
        }

        @Override
        public String generateSessionId(Map<String, Object> context) {
            return (String)context.get(MY_SESSION_ID);
        }

        @Override
        public void postAction(HttpServletRequest request, HttpServletResponse response, byte[][] responseSoapParts, Map<String, Object> context) throws Exception {
        }
    }
}

