/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import mondrian.calc.ResultStyle;
import mondrian.olap.Connection;
import mondrian.olap.MemoryLimitExceededException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.test.FoodMartTestCase;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import mondrian.util.NotificationMemoryMonitor;

public class MemoryMonitorTest
extends FoodMartTestCase {
    static final int PERCENT_100 = 100;
    protected boolean enabled;
    private static int THRESHOLD_PERCENTAGE = 90;

    protected static int convertThresholdToPercentage(long threshold, long maxMemory) {
        return (int)(100L * threshold / maxMemory);
    }

    public boolean causeGC(MemoryMonitor mm) {
        int i;
        long usedMemory;
        int nosOfChunks = 1000;
        long maxMemory = mm.getMaxMemory();
        long delta = (maxMemory - (usedMemory = mm.getUsedMemory())) / 1000L;
        if (delta == 0L) {
            delta = 1024L;
        } else if (delta > Integer.MAX_VALUE) {
            delta = Integer.MAX_VALUE;
        }
        int size = 2000;
        Object[] byteArrayHolder = new Object[2000];
        for (i = 0; i < 2000; ++i) {
            try {
                byteArrayHolder[i] = new SoftReference<byte[]>(new byte[(int)delta]);
                continue;
            }
            catch (OutOfMemoryError ex) {
                return true;
            }
        }
        for (i = 0; i < 2000; ++i) {
            SoftReference ref = (SoftReference)byteArrayHolder[i];
            if (ref.get() != null) continue;
            return true;
        }
        return false;
    }

    public MemoryMonitorTest() {
    }

    public MemoryMonitorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.enabled = MondrianProperties.instance().MemoryMonitor.get();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeltaUsage() throws Exception {
        if (Util.PreJdk15 || !this.enabled) {
            return;
        }
        class Listener
        implements MemoryMonitor.Listener {
            boolean wasNotified = false;

            Listener() {
            }

            public void memoryUsageNotification(long used, long max) {
                this.wasNotified = true;
            }
        }
        Listener listener = new Listener();
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        long maxMemory = mm.getMaxMemory();
        long usedMemory = mm.getUsedMemory();
        int currentPercentage = MemoryMonitorTest.convertThresholdToPercentage(usedMemory, maxMemory);
        int delta = (int)(maxMemory - usedMemory) / 10;
        int percentage = MemoryMonitorTest.convertThresholdToPercentage(delta, maxMemory);
        try {
            Object bytes = new byte[10][];
            mm.addListener(listener, percentage + currentPercentage);
            for (int i = 0; i < ((byte[][])bytes).length; ++i) {
                bytes[i] = new byte[delta];
                if (!listener.wasNotified) continue;
                bytes = null;
                break;
            }
            if (!listener.wasNotified) {
                MemoryMonitorTest.fail((String)"Listener callback not called");
            }
        }
        finally {
            mm.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testQuery() throws Exception {
        if (Util.PreJdk15 || !this.enabled) {
            return;
        }
        class Listener
        implements MemoryMonitor.Listener {
            boolean wasNotified = false;

            Listener() {
            }

            public void memoryUsageNotification(long used, long max) {
                this.wasNotified = true;
            }
        }
        Listener listener = new Listener();
        String queryString = "select \n{ \n[Measures].[Store Sales], \n[Measures].[Sales Count], \n[Measures].[Customer Count] \n} \nON COLUMNS, \nCrossjoin(\n  Descendants([Store].[All Stores]), \n  Descendants([Product].[All Products]) \n) \nON ROWS \nfrom [Sales]";
        ArrayList<Result> list = new ArrayList<Result>();
        MemoryMonitor mm = null;
        try {
            long buf;
            MemoryMonitorFactory.setThreadLocalClassName(TestMM.class.getName());
            mm = MemoryMonitorFactory.getMemoryMonitor();
            boolean b = this.causeGC(mm);
            long neededMemory = 5000000L;
            long maxMemory = mm.getMaxMemory();
            long usedMemory = mm.getUsedMemory();
            long tenPercentMaxMemory = maxMemory / 10L;
            long level = maxMemory - tenPercentMaxMemory;
            if (level > usedMemory) {
                buf = level - usedMemory - neededMemory;
                if (buf <= 0L) {
                    buf = level - usedMemory;
                }
                THRESHOLD_PERCENTAGE = 90;
            } else {
                buf = 0L;
                double dp = 100.0 * (double)(maxMemory - usedMemory) / (double)maxMemory;
                THRESHOLD_PERCENTAGE = 100 - (int)Math.ceil(dp);
            }
            byte[] bytes = new byte[(int)(buf > 0L ? buf : 0L)];
            mm.addListener(listener);
            if (listener.wasNotified) {
                return;
            }
            Connection conn = this.getConnection();
            int MAX = 100;
            for (int i = 0; i < 100; ++i) {
                Query query = conn.parseQuery("select \n{ \n[Measures].[Store Sales], \n[Measures].[Sales Count], \n[Measures].[Customer Count] \n} \nON COLUMNS, \nCrossjoin(\n  Descendants([Store].[All Stores]), \n  Descendants([Product].[All Products]) \n) \nON ROWS \nfrom [Sales]");
                query.setResultStyle(ResultStyle.MUTABLE_LIST);
                Result result = conn.execute(query);
                list.add(result);
                if (listener.wasNotified) break;
            }
            MemoryMonitorTest.fail((String)"Memory Notification Exception did not occur");
        }
        catch (MemoryLimitExceededException ex) {
            if (!listener.wasNotified) {
                MemoryMonitorTest.fail((String)"Listener callback not called");
            }
        }
        finally {
            if (mm != null) {
                mm.removeListener(listener);
            }
            for (Result result : list) {
                result.close();
            }
            MemoryMonitorFactory.clearThreadLocalClassName();
        }
    }

    public static class TestMM2
    extends NotificationMemoryMonitor {
        public int getDefaultThresholdPercentage() {
            return 98;
        }
    }

    public static class TestMM
    extends NotificationMemoryMonitor {
        public int getDefaultThresholdPercentage() {
            return THRESHOLD_PERCENTAGE;
        }
    }
}

