/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.olap.MondrianProperties;
import mondrian.test.FoodMartTestCase;

public class IgnoreMeasureForNonJoiningDimensionInAggregationTest
extends FoodMartTestCase {
    boolean originalNonEmptyFlag;
    boolean originalEliminateUnrelatedDimensions;
    private final MondrianProperties prop = MondrianProperties.instance();

    protected void setUp() throws Exception {
        this.originalNonEmptyFlag = this.prop.EnableNonEmptyOnAllAxis.get();
        this.originalEliminateUnrelatedDimensions = this.prop.IgnoreMeasureForNonJoiningDimension.get();
        this.prop.EnableNonEmptyOnAllAxis.set(true);
        this.prop.IgnoreMeasureForNonJoiningDimension.set(true);
    }

    protected void tearDown() throws Exception {
        this.prop.EnableNonEmptyOnAllAxis.set(this.originalNonEmptyFlag);
        this.prop.IgnoreMeasureForNonJoiningDimension.set(this.originalEliminateUnrelatedDimensions);
    }

    public void testNoTotalsForCompoundMeasureWithComponentsHavingNonJoiningDims() {
        this.assertQueryReturns("with member [Measures].[Total Sales] as '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'member [Product].x as 'sum({Product.members  * Gender.members})' select {[Measures].[Total Sales]} on 0, {Product.x} on 1 from [Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Product].[x]}\nRow #0: 7,913,333.82\n"));
    }

    public void testNonJoiningDimsWhenAggFunctionIsUsedOrNotUsed() {
        String query = "WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Warehouse].[AggSP1] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\n([Product].[All Products], [Warehouse].[All Warehouses]))'\nMEMBER [Warehouse].[AggPreSP] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\nAggregate({([Product].[All Products], [Warehouse].[All Warehouses])}))'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{{([Warehouse].[AggPreSP])},\n{([Warehouse].[AggSP1])}} ON AXIS(1)\nFROM\n[Warehouse and Sales]";
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Warehouse].[AggSP1] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\n([Product].[All Products], [Warehouse].[All Warehouses]))'\nMEMBER [Warehouse].[AggPreSP] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\nAggregate({([Product].[All Products], [Warehouse].[All Warehouses])}))'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{{([Warehouse].[AggPreSP])},\n{([Warehouse].[AggSP1])}} ON AXIS(1)\nFROM\n[Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Warehouse].[AggPreSP]}\n{[Warehouse].[AggSP1]}\nRow #0: 196,770.89\nRow #1: 196,770.89\n"));
        this.prop.IgnoreMeasureForNonJoiningDimension.set(false);
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Warehouse].[AggSP1] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\n([Product].[All Products], [Warehouse].[All Warehouses]))'\nMEMBER [Warehouse].[AggPreSP] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\nAggregate({([Product].[All Products], [Warehouse].[All Warehouses])}))'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{{([Warehouse].[AggPreSP])},\n{([Warehouse].[AggSP1])}} ON AXIS(1)\nFROM\n[Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Warehouse].[AggPreSP]}\n{[Warehouse].[AggSP1]}\nRow #0: 762,009.02\nRow #1: 762,009.02\n"));
    }

    public void testNonJoiningDimForAMemberDefinedOnJoiningDim() {
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Product].[AggSP1] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\n([Warehouse].[All Warehouses]))'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{[Product].[AggSP1]} ON AXIS(1)\nFROM\n[Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Product].[AggSP1]}\nRow #0: 196,770.89\n"));
    }

    public void testNonJoiningDimWithNumericIif() {
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Warehouse].[AggSP1_1] AS\n'IIF(1=0,\n([Warehouse].[All Warehouses], [Measures].[Total Sales]),\n([Warehouse].[All Warehouses]))'\nMEMBER [Warehouse].[AggSP1_2] AS\n'IIF(1=0,\n111,\n([Warehouse].[All Warehouses], [Store].[All Stores]))'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{([Warehouse].[AggSP1_1]), ([Warehouse].[AggSP1_2])} ON AXIS(1)\nFROM\n[Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Warehouse].[AggSP1_1]}\n{[Warehouse].[AggSP1_2]}\nRow #0: 196,770.89\nRow #1: 196,770.89\n"));
    }

    public void testNonJoiningDimAtMemberValueCalcMultipleScenarios() {
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Warehouse].[AggSP1_1] AS\n'IIF(1=0,\n([Warehouse].[All Warehouses]),\n([Warehouse].[All Warehouses]))'\nMEMBER [Warehouse].[AggSP1_2] AS\n'IIF(1=0,\n[Warehouse].[All Warehouses],\n([Warehouse].[All Warehouses]))'\nMEMBER [Warehouse].[AggSP1_3] AS\n'IIF(1=0,\n([Warehouse].[All Warehouses]),\n[Warehouse].[All Warehouses])'\nMEMBER [Warehouse].[AggSP1_4] AS\n'IIF(1=0,\nStrToMember(\"[Warehouse].[All Warehouses]\"),\n[Warehouse].[All Warehouses])'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{([Warehouse].[AggSP1_1]),([Warehouse].[AggSP1_2]),([Warehouse].[AggSP1_3]),([Warehouse].[AggSP1_4])} ON AXIS(1)\nFROM\n[Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Warehouse].[AggSP1_1]}\n{[Warehouse].[AggSP1_2]}\n{[Warehouse].[AggSP1_3]}\n{[Warehouse].[AggSP1_4]}\nRow #0: 196,770.89\nRow #1: 196,770.89\nRow #2: 196,770.89\nRow #3: 196,770.89\n"));
    }

    public void testNonJoiningDimAtTupleValueCalcMultipleScenarios() {
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Warehouse].[AggSP1_1] AS\n'IIF(1=0,\n([Warehouse].[All Warehouses], [Store].[All Stores]),\n([Warehouse].[All Warehouses], [Store].[All Stores]))'\nMEMBER [Warehouse].[AggSP1_2] AS\n'IIF(1=0,\n([Warehouse].[All Warehouses]),\n([Warehouse].[All Warehouses], [Store].[All Stores]))'\nMEMBER [Warehouse].[AggSP1_3] AS\n'IIF(1=0,\n([Warehouse].[All Warehouses], [Store].[All Stores]),\n([Warehouse].[All Warehouses]))'\nMEMBER [Warehouse].[AggSP1_4] AS\n'IIF(1=0,\nStrToTuple(\"([Warehouse].[All Warehouses])\", [Warehouse]),\n([Warehouse].[All Warehouses], [Store].[All Stores]))'\nMEMBER [Warehouse].[AggSP1_5] AS\n'IIF(1=0,\n([Warehouse].[All Warehouses], [Store].[All Stores]),\n[Warehouse].[All Warehouses])'\nMEMBER [Warehouse].[AggSP1_6] AS\n'IIF(1=0,\n[Warehouse].[All Warehouses],\n([Warehouse].[All Warehouses], [Store].[All Stores]))'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{[Warehouse].[AggSP1_1],[Warehouse].[AggSP1_2],[Warehouse].[AggSP1_3],[Warehouse].[AggSP1_4],[Warehouse].[AggSP1_5],[Warehouse].[AggSP1_6]} ON AXIS(1)\nFROM\n[Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Warehouse].[AggSP1_1]}\n{[Warehouse].[AggSP1_2]}\n{[Warehouse].[AggSP1_3]}\n{[Warehouse].[AggSP1_4]}\n{[Warehouse].[AggSP1_5]}\n{[Warehouse].[AggSP1_6]}\nRow #0: 196,770.89\nRow #1: 196,770.89\nRow #2: 196,770.89\nRow #3: 196,770.89\nRow #4: 196,770.89\nRow #5: 196,770.89\n"));
    }

    public void testNoTotalsForCompoundMeasureWithNonJoiningDimAtAllLevel() {
        this.assertQueryReturns("with member [Measures].[Total Sales] as '[Measures].[Store Sales]'member [Product].x as 'sum({Product.members  * Gender.[All Gender]})' select {[Measures].[Total Sales]} on 0, {Product.x} on 1 from [Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Product].[x]}\nRow #0: 3,956,666.91\n"));
    }

    public void testNoTotalForMeasureWithCrossJoinOfJoiningAndNonJoiningDims() {
        this.assertQueryReturns("with member [Product].x as 'sum({Product.members}  * {Gender.members})' select {[Measures].[Warehouse Sales]} on 0, {Product.x} on 1 from [Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\nAxis #2:\n"));
    }

    public void testShouldTotalAMeasureWithAllJoiningDimensions() {
        this.assertQueryReturns("with member [Product].x as 'sum({Product.members})' select {[Measures].[Warehouse Sales]} on 0, {Product.x} on 1 from [Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Warehouse Sales]}\nAxis #2:\n{[Product].[x]}\nRow #0: 1,377,396.213\n"));
    }

    public void testShouldNotTotalAMeasureWithANonJoiningDimension() {
        this.assertQueryReturns("with member [Gender].x as 'sum({Gender.members})'select {[Measures].[Warehouse Sales]} on 0, {Gender.x} on 1 from [Warehouse and Sales]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\nAxis #2:\n"));
    }

    public void testGetMeasureCubeForCalcMeasureDoesNotThrowCastException() {
        this.getTestContext().assertQueryReturns("WITH MEMBER [Measures].[My Profit] AS 'Measures.[Profit]', SOLVE_ORDER = 3000 MEMBER Gender.G AS 'sum(CROSSJOIN({GENDER.[M]},{[Product].[All Products].[Drink]}))',SOLVE_ORDER = 4 SELECT {[Measures].[My Profit]} ON 0, {Gender.G} ON 1 FROM [SALES]", IgnoreMeasureForNonJoiningDimensionInAggregationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[My Profit]}\nAxis #2:\n{[Gender].[G]}\nRow #0: $14,652.70\n"));
    }
}

