/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatenableList<T>
extends AbstractList<T> {
    private static int nextHashCode = 1000;
    private final List<List<T>> lists;
    private List<T> plainList = null;
    private final int hashCode = nextHashCode++;
    private Iterator<T> getIterator = null;
    private int previousIndex = -200;
    private T previousElement = null;
    private T prePreviousElement = null;

    public ConcatenableList() {
        this.lists = new ArrayList<List<T>>();
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        this.consolidate();
        return this.plainList.toArray(a);
    }

    @Override
    public Object[] toArray() {
        this.consolidate();
        return this.plainList.toArray();
    }

    public void consolidate() {
        if (this.plainList == null) {
            this.plainList = new ArrayList<T>();
            for (List<T> list : this.lists) {
                for (T t : list) {
                    this.plainList.add(t);
                }
            }
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.plainList == null) {
            List list = (List)collection;
            return this.lists.add(list);
        }
        for (T e : collection) {
            this.plainList.add(e);
        }
        return true;
    }

    @Override
    public T get(int index) {
        if (this.plainList == null) {
            if (index == 0) {
                this.getIterator = this.iterator();
                this.previousIndex = index;
                if (this.getIterator.hasNext()) {
                    this.previousElement = this.getIterator.next();
                    return this.previousElement;
                }
                this.getIterator = null;
                this.previousIndex = -200;
                throw new IndexOutOfBoundsException("Index " + index + " out of concatenable list range");
            }
            if (this.previousIndex + 1 == index && this.getIterator != null) {
                this.previousIndex = index;
                if (this.getIterator.hasNext()) {
                    this.prePreviousElement = this.previousElement;
                    this.previousElement = this.getIterator.next();
                    return this.previousElement;
                }
                this.getIterator = null;
                this.previousIndex = -200;
                throw new IndexOutOfBoundsException("Index " + index + " out of concatenable list range");
            }
            if (this.previousIndex == index) {
                return this.previousElement;
            }
            if (this.previousIndex - 1 == index) {
                return this.prePreviousElement;
            }
            this.previousIndex = -200;
            this.getIterator = null;
            Iterator<T> it = this.iterator();
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("Index " + index + " out of concatenable list range");
            }
            for (int i = 0; i < index; ++i) {
                if (!it.hasNext()) {
                    throw new IndexOutOfBoundsException("Index " + index + " out of concatenable list range");
                }
                this.prePreviousElement = it.next();
            }
            this.previousElement = it.next();
            this.previousIndex = index;
            this.getIterator = it;
            return this.previousElement;
        }
        this.previousElement = this.plainList.get(index);
        return this.previousElement;
    }

    @Override
    public boolean add(T t) {
        if (this.plainList == null) {
            return this.lists.add(Collections.singletonList(t));
        }
        return this.plainList.add(t);
    }

    @Override
    public void add(int index, T t) {
        if (this.plainList == null) {
            throw new UnsupportedOperationException();
        }
        this.plainList.add(index, t);
    }

    @Override
    public T set(int index, T t) {
        if (this.plainList == null) {
            throw new UnsupportedOperationException();
        }
        return this.plainList.set(index, t);
    }

    @Override
    public int size() {
        if (this.plainList == null) {
            int size = 0;
            for (List<T> list : this.lists) {
                size += list.size();
            }
            return size;
        }
        return this.plainList.size();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.plainList == null) {
            return new Iterator<T>(){
                private final Iterator<List<T>> listsIt;
                private Iterator<T> currentListIt;
                {
                    this.listsIt = ConcatenableList.this.lists.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.currentListIt == null) {
                        if (this.listsIt.hasNext()) {
                            this.currentListIt = this.listsIt.next().iterator();
                        } else {
                            return false;
                        }
                    }
                    if (this.currentListIt.hasNext()) {
                        return true;
                    }
                    if (this.listsIt.hasNext()) {
                        this.currentListIt = this.listsIt.next().iterator();
                        return this.currentListIt.hasNext();
                    }
                    return false;
                }

                @Override
                public T next() {
                    if (this.currentListIt.hasNext()) {
                        return this.currentListIt.next();
                    }
                    this.currentListIt = this.listsIt.next().iterator();
                    return this.currentListIt.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.plainList.iterator();
    }

    @Override
    public boolean isEmpty() {
        if (this.plainList != null) {
            return this.plainList.isEmpty();
        }
        if (this.lists.isEmpty()) {
            return true;
        }
        for (List<T> l : this.lists) {
            if (l.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.plainList = null;
        this.lists.clear();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

