/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractMemberListCalc;
import mondrian.calc.impl.AbstractTupleListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.SetType;

class HierarchizeFunDef
extends FunDefBase {
    static final String[] prePost = new String[]{"PRE", "POST"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Hierarchize", "Hierarchize(<Set>[, POST])", "Orders the members of a set in a hierarchy.", new String[]{"fxx", "fxxy"}, HierarchizeFunDef.class, prePost);

    public HierarchizeFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        String order = HierarchizeFunDef.getLiteralArg(call, 1, "PRE", prePost);
        final boolean post = order.equals("POST");
        final int arity = ((SetType)listCalc.getType()).getArity();
        if (arity == 1) {
            final MemberListCalc memberListCalc = (MemberListCalc)listCalc;
            return new AbstractMemberListCalc(call, new Calc[]{listCalc}){

                @Override
                public List<Member> evaluateMemberList(Evaluator evaluator) {
                    List<Member> list = memberListCalc.evaluateMemberList(evaluator);
                    FunUtil.hierarchizeMemberList(list, post);
                    return list;
                }
            };
        }
        final TupleListCalc tupleListCalc = (TupleListCalc)listCalc;
        return new AbstractTupleListCalc(call, new Calc[]{listCalc}){

            @Override
            public List<Member[]> evaluateTupleList(Evaluator evaluator) {
                List<Member[]> list = tupleListCalc.evaluateTupleList(evaluator);
                FunUtil.hierarchizeTupleList(list, post, arity);
                return list;
            }
        };
    }
}

