/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 * 
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 * 
 * This program is part of iReport.
 * 
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.charts.datasets.wizards;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.crosstab.wizard.DatasetListCellRenderer;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.NbBundle;

public final class PieVisualPanel1 extends JPanel {

    /** Creates new form PieVisualPanel1 */
    public PieVisualPanel1() {
        initComponents();
        jComboBoxDataset.setRenderer( new DatasetListCellRenderer() );
        updateDatasets();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(PieVisualPanel1.class, "PieVisualPanel1.name");
    }

    public void updateDatasets() {

        DefaultComboBoxModel model = (DefaultComboBoxModel)jComboBoxDataset.getModel();
        model.removeAllElements();

        JasperDesign design = IReportManager.getInstance().getActiveReport();
        if (design == null) return;

        List datasets = design.getDatasetsList();
        model.addElement( design.getMainDataset());
        for (int i=0; i<datasets.size(); ++i)
        {
            model.addElement( datasets.get(i));
        }

        jComboBoxDataset.setSelectedIndex(0);
        jComboBoxDataset.updateUI();
    }


    /**
     * 
     * @return the selected dataset
     */
    public JRDesignDataset getDataset()
    {
        return (JRDesignDataset)jComboBoxDataset.getSelectedItem();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelDataset = new javax.swing.JLabel();
        jComboBoxDataset = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(jLabelDataset, org.openide.util.NbBundle.getMessage(PieVisualPanel1.class, "PieVisualPanel1.jLabelDataset.text")); // NOI18N

        jLabel2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/charts/datasets/wizards/pie_gray.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PieVisualPanel1.class, "PieVisualPanel1.jLabel2.text")); // NOI18N
        jLabel2.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabel2.setVerticalTextPosition(javax.swing.SwingConstants.TOP);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 365, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(jLabelDataset, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 222, Short.MAX_VALUE)
                        .add(143, 143, 143))
                    .add(layout.createSequentialGroup()
                        .add(jComboBoxDataset, 0, 355, Short.MAX_VALUE)
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(31, 31, 31)
                .add(jLabelDataset)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jComboBoxDataset, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(36, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxDataset;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelDataset;
    // End of variables declaration//GEN-END:variables
}

