/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Util;
import mondrian.rolap.CacheControlImpl;
import mondrian.rolap.RolapSchema;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.impl.DefaultXmlaServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDatasourceXmlaServlet
extends DefaultXmlaServlet {
    protected URL dataSourcesConfigUrl;
    protected String lastDataSourcesConfigString;

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.reloadDataSources();
        super.doPost(request, response);
    }

    void reloadDataSources() {
        try {
            DataSourcesConfig.DataSources newDataSources;
            String dataSourcesConfigString = this.readDataSourcesContent(this.dataSourcesConfigUrl);
            if (this.hasDataSourcesContentChanged(dataSourcesConfigString) && (newDataSources = this.parseDataSources(dataSourcesConfigString)) != null) {
                this.flushObsoleteCatalogs(newDataSources);
                this.dataSources = newDataSources;
                this.xmlaHandler = null;
                this.lastDataSourcesConfigString = dataSourcesConfigString;
            }
        }
        catch (Exception e) {
            throw Util.newError(e, "Failed to parse data sources config '" + this.dataSourcesConfigUrl.toExternalForm() + "'");
        }
    }

    protected boolean hasDataSourcesContentChanged(String dataSourcesConfigString) {
        return dataSourcesConfigString != null && !dataSourcesConfigString.equals(this.lastDataSourcesConfigString);
    }

    @Override
    protected DataSourcesConfig.DataSources parseDataSourcesUrl(URL dataSourcesConfigUrl) {
        this.dataSourcesConfigUrl = dataSourcesConfigUrl;
        try {
            String dataSourcesConfigString = this.readDataSourcesContent(dataSourcesConfigUrl);
            if (this.lastDataSourcesConfigString == null) {
                this.lastDataSourcesConfigString = dataSourcesConfigString;
            }
            return this.parseDataSources(dataSourcesConfigString);
        }
        catch (Exception e) {
            throw Util.newError(e, "Failed to parse data sources config '" + dataSourcesConfigUrl.toExternalForm() + "'");
        }
    }

    void flushObsoleteCatalogs(DataSourcesConfig.DataSources newDataSources) {
        Map<String, DataSourcesConfig.Catalog> newDatasourceCatalogs = this.createCatalogMap(newDataSources);
        for (DataSourcesConfig.DataSource oldDataSource : this.dataSources.dataSources) {
            for (DataSourcesConfig.Catalog oldCatalog : oldDataSource.catalogs.catalogs) {
                DataSourcesConfig.Catalog newCatalog = newDatasourceCatalogs.get(oldCatalog.name);
                if (newCatalog != null && this.areCatalogsEqual(oldCatalog, newCatalog)) continue;
                this.flushCatalog(oldCatalog.name);
            }
        }
    }

    private Map<String, DataSourcesConfig.Catalog> createCatalogMap(DataSourcesConfig.DataSources newDataSources) {
        HashMap<String, DataSourcesConfig.Catalog> newDatasourceCatalogNames = new HashMap<String, DataSourcesConfig.Catalog>();
        for (DataSourcesConfig.DataSource dataSource : newDataSources.dataSources) {
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                newDatasourceCatalogNames.put(catalog.name, catalog);
            }
        }
        return newDatasourceCatalogNames;
    }

    void flushCatalog(String catalogName) {
        Iterator<RolapSchema> schemas = RolapSchema.getRolapSchemas();
        while (schemas.hasNext()) {
            RolapSchema curSchema = schemas.next();
            if (!curSchema.getName().equals(catalogName)) continue;
            new CacheControlImpl().flushSchema(curSchema);
        }
    }

    boolean areCatalogsEqual(DataSourcesConfig.Catalog catalog1, DataSourcesConfig.Catalog catalog2) {
        if (catalog1.getDataSourceInfo() != null && catalog2.getDataSourceInfo() == null || catalog2.getDataSourceInfo() != null && catalog1.getDataSourceInfo() == null) {
            return false;
        }
        if (catalog1.getDataSourceInfo() == null && catalog2.getDataSourceInfo() == null || catalog1.getDataSourceInfo().equals(catalog2.getDataSourceInfo())) {
            return catalog1.name.equals(catalog2.name) && catalog1.definition.equals(catalog2.definition);
        }
        return false;
    }
}

