/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTupleReader
implements TupleReader {
    protected final TupleConstraint constraint;
    List<Target> targets = new ArrayList<Target>();
    int maxRows = 0;
    private int missedMemberCount;

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReader.class);
        for (Target target : this.targets) {
            if (target.srcMembers == null) continue;
            key.add(target.getLevel());
        }
        return key;
    }

    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (Target target : this.targets) {
            if (target.srcMembers == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    protected void prepareTuples(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        String message = "Populating member cache with members for " + this.targets;
        SqlStatement stmt = null;
        boolean execQuery = partialResult == null;
        try {
            boolean moreRows;
            ResultSet resultSet;
            if (execQuery) {
                ArrayList<Target> partialTargets = new ArrayList<Target>();
                for (Target target : this.targets) {
                    if (target.srcMembers != null) continue;
                    partialTargets.add(target);
                }
                String sql = this.makeLevelMembersSql(dataSource);
                assert (sql != null && !sql.equals(""));
                stmt = RolapUtil.executeQuery(dataSource, sql, this.maxRows, "SqlTupleReader.readTuples " + partialTargets, message, -1, -1);
                resultSet = stmt.getResultSet();
            } else {
                resultSet = null;
            }
            for (Target target : this.targets) {
                target.open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int fetchCount = 0;
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                moreRows = resultSet.next();
                if (moreRows) {
                    ++stmt.rowCount;
                }
            } else {
                boolean bl = moreRows = currPartialResultIdx < partialResult.size();
            }
            while (moreRows) {
                if (limit > 0 && limit < ++fetchCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                if (enumTargetCount == 0) {
                    int column = 0;
                    for (Target target : this.targets) {
                        target.currMember = null;
                        column = target.addRow(resultSet, column);
                    }
                } else {
                    int firstEnumTarget;
                    for (firstEnumTarget = 0; firstEnumTarget < this.targets.size() && this.targets.get(firstEnumTarget).srcMembers == null; ++firstEnumTarget) {
                    }
                    List<RolapMember> partialRow = execQuery ? null : partialResult.get(currPartialResultIdx);
                    this.resetCurrMembers(partialRow);
                    this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, resultSet, message);
                    if (newPartialResult != null) {
                        this.savePartialResult(newPartialResult);
                    }
                }
                if (execQuery) {
                    moreRows = resultSet.next();
                    if (!moreRows) continue;
                    ++stmt.rowCount;
                    continue;
                }
                moreRows = ++currPartialResultIdx < partialResult.size();
            }
        }
        catch (SQLException e) {
            if (stmt == null) {
                throw Util.newError(e, message);
            }
            throw stmt.handle(e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<RolapMember> readMembers(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        block2: {
            int memberCountBefore;
            int memberCount = this.countMembers();
            do {
                this.missedMemberCount = 0;
                memberCountBefore = memberCount;
                this.prepareTuples(dataSource, partialResult, newPartialResult);
                memberCount = this.countMembers();
                if (this.missedMemberCount == 0) break block2;
            } while (memberCount != memberCountBefore);
            throw Util.newError("Parent-child hierarchy contains cyclic data");
        }
        assert (this.targets.size() == 1);
        return this.targets.get(0).close();
    }

    private int countMembers() {
        int n = 0;
        for (Target target : this.targets) {
            if (target.list == null) continue;
            n += target.list.size();
        }
        return n;
    }

    @Override
    public List<RolapMember[]> readTuples(DataSource jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        int n = this.targets.size();
        ArrayList<RolapMember[]> tupleList = new ArrayList<RolapMember[]>();
        Iterator[] iter = new Iterator[n];
        for (int i = 0; i < n; ++i) {
            Target t = this.targets.get(i);
            iter[i] = t.close().iterator();
        }
        while (iter[0].hasNext()) {
            RolapMember[] tuples = new RolapMember[n];
            for (int i = 0; i < n; ++i) {
                tuples[i] = (RolapMember)iter[i].next();
            }
            tupleList.add(tuples);
        }
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            FunUtil.hierarchizeTupleList(Util.cast(tupleList), false, n);
        }
        return tupleList;
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            if (partialRow != null) {
                target.currMember = partialRow.get(nativeTarget++);
                continue;
            }
            target.currMember = null;
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, ResultSet resultSet, String message) {
        Target currTarget = this.targets.get(currTargetIdx);
        for (int i = 0; i < currTarget.srcMembers.size(); ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && this.targets.get(nextTargetIdx).srcMembers == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, resultSet, message);
                continue;
            }
            int column = 0;
            int enumTargetIdx = 0;
            for (Target target : this.targets) {
                if (target.srcMembers == null) {
                    try {
                        column = target.addRow(resultSet, column);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newError(e, message);
                    }
                }
                RolapMember member = (RolapMember)target.srcMembers.get(srcMemberIdxes[enumTargetIdx++]);
                target.list.add(member);
            }
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            row.add(target.currMember);
        }
        partialResult.add(row);
    }

    private String makeLevelMembersSql(DataSource dataSource) {
        Query query;
        SqlContextConstraint sqlConstraint;
        RolapCube cube = null;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint && (sqlConstraint = (SqlContextConstraint)this.constraint).isJoinRequired()) {
            query = this.constraint.getEvaluator().getQuery();
            cube = (RolapCube)query.getCube();
            virtualCube = cube.isVirtual();
        }
        if (virtualCube) {
            String selectString = "";
            query = this.constraint.getEvaluator().getQuery();
            RolapCube.CubeComparator cubeComparator = new RolapCube.CubeComparator();
            TreeSet<RolapCube> baseCubes = new TreeSet<RolapCube>(cubeComparator);
            baseCubes.addAll(query.getBaseCubes());
            int k = -1;
            Member originalMeasure = this.constraint.getEvaluator().getMembers()[0];
            for (RolapCube baseCube : baseCubes) {
                Member measureInCurrentbaseCube = baseCube.getMeasures().get(0);
                this.constraint.getEvaluator().setContext(measureInCurrentbaseCube);
                boolean finalSelect = ++k == baseCubes.size() - 1;
                WhichSelect whichSelect = finalSelect ? WhichSelect.LAST : WhichSelect.NOT_LAST;
                selectString = selectString + this.generateSelectForLevels(dataSource, baseCube, whichSelect);
                if (finalSelect) continue;
                selectString = selectString + " union ";
            }
            this.constraint.getEvaluator().setContext(originalMeasure);
            return selectString;
        }
        return this.generateSelectForLevels(dataSource, cube, WhichSelect.ONLY);
    }

    private String generateSelectForLevels(DataSource dataSource, RolapCube baseCube, WhichSelect whichSelect) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, s);
        Evaluator evaluator = this.getEvaluator(this.constraint);
        AggStar aggStar = this.chooseAggStar(evaluator);
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            this.addLevelMemberSql(sqlQuery, target.getLevel(), baseCube, whichSelect, aggStar);
        }
        this.constraint.addConstraint(sqlQuery, baseCube, aggStar);
        return sqlQuery.toString();
    }

    protected void addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level, RolapCube baseCube, WhichSelect whichSelect, AggStar aggStar) {
        RolapHierarchy hierarchy = level.getHierarchy();
        if (hierarchy instanceof RolapCubeHierarchy) {
            RolapCubeHierarchy cubeHierarchy = (RolapCubeHierarchy)hierarchy;
            if (baseCube != null && !cubeHierarchy.getDimension().getCube().equals(baseCube)) {
                hierarchy = baseCube.findBaseCubeHierarchy(hierarchy);
            }
        }
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        boolean levelCollapsed = aggStar != null && this.isLevelCollapsed(aggStar, (RolapCubeLevel)level);
        for (int i = 0; i <= levelDepth; ++i) {
            RolapLevel currLevel = levels[i];
            if (currLevel.isAll()) continue;
            if (!levelCollapsed) {
                RolapProperty[] properties;
                MondrianDef.Expression keyExp = currLevel.getKeyExp();
                MondrianDef.Expression ordinalExp = currLevel.getOrdinalExp();
                MondrianDef.Expression captionExp = currLevel.getCaptionExp();
                MondrianDef.Expression parentExp = currLevel.getParentExp();
                if (parentExp != null) {
                    hierarchy.addToFrom(sqlQuery, parentExp);
                    String parentSql = parentExp.getExpression(sqlQuery);
                    sqlQuery.addSelectGroupBy(parentSql);
                    sqlQuery.addOrderBy(parentSql, true, false, true);
                }
                String keySql = keyExp.getExpression(sqlQuery);
                String ordinalSql = ordinalExp.getExpression(sqlQuery);
                hierarchy.addToFrom(sqlQuery, keyExp);
                hierarchy.addToFrom(sqlQuery, ordinalExp);
                String captionSql = null;
                if (captionExp != null) {
                    captionSql = captionExp.getExpression(sqlQuery);
                    hierarchy.addToFrom(sqlQuery, captionExp);
                }
                sqlQuery.addSelectGroupBy(keySql);
                if (!ordinalSql.equals(keySql)) {
                    sqlQuery.addSelectGroupBy(ordinalSql);
                }
                if (captionSql != null) {
                    sqlQuery.addSelectGroupBy(captionSql);
                }
                this.constraint.addLevelConstraint(sqlQuery, baseCube, aggStar, currLevel);
                switch (whichSelect) {
                    case LAST: {
                        sqlQuery.addOrderBy(Integer.toString(sqlQuery.getCurrentSelectListSize()), true, false, true);
                        break;
                    }
                    case ONLY: {
                        sqlQuery.addOrderBy(ordinalSql, true, false, true);
                    }
                }
                for (RolapProperty property : properties = currLevel.getProperties()) {
                    String propSql = property.getExp().getExpression(sqlQuery);
                    sqlQuery.addSelectGroupBy(propSql);
                }
                continue;
            }
            RolapStar.Column starColumn = ((RolapCubeLevel)currLevel).getStarKeyColumn();
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            String q = aggColumn.generateExprString(sqlQuery);
            sqlQuery.addSelectGroupBy(q);
            sqlQuery.addOrderBy(q, true, false, true);
            aggColumn.getTable().addToFrom(sqlQuery, false, true);
        }
    }

    protected Evaluator getEvaluator(TupleConstraint constraint) {
        Evaluator evaluator = null;
        if (!(constraint instanceof SqlContextConstraint)) {
            DescendantsConstraint descConstraint;
            MemberChildrenConstraint mcc;
            if (constraint instanceof DescendantsConstraint && (mcc = (descConstraint = (DescendantsConstraint)constraint).getMemberChildrenConstraint(null)) instanceof SqlContextConstraint) {
                SqlContextConstraint scc = (SqlContextConstraint)mcc;
                evaluator = scc.getEvaluator();
            }
        } else {
            evaluator = constraint.getEvaluator();
        }
        return evaluator;
    }

    protected boolean levelContainsMultipleColumns(RolapLevel level) {
        RolapProperty[] properties;
        MondrianDef.Expression keyExp = level.getKeyExp();
        MondrianDef.Expression ordinalExp = level.getOrdinalExp();
        MondrianDef.Expression captionExp = level.getCaptionExp();
        if (!keyExp.equals((Object)ordinalExp)) {
            return true;
        }
        if (captionExp != null && !keyExp.equals((Object)captionExp)) {
            return true;
        }
        for (RolapProperty property : properties = level.getProperties()) {
            if (property.getExp().equals((Object)keyExp)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLevelCollapsed(AggStar aggStar, RolapCubeLevel level) {
        boolean levelCollapsed = false;
        if (level.isAll()) {
            return levelCollapsed;
        }
        RolapStar.Column starColumn = level.getStarKeyColumn();
        int bitPos = starColumn.getBitPosition();
        AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
        if (aggColumn.getTable() instanceof AggStar.FactTable) {
            levelCollapsed = true;
        }
        return levelCollapsed;
    }

    private AggStar chooseAggStar(Evaluator evaluator) {
        RolapStar.Column[] columns;
        if (evaluator == null) {
            return null;
        }
        RolapCube cube = (RolapCube)evaluator.getCube();
        if (cube.isVirtual()) {
            return null;
        }
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getMembers();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = ((RolapStar.Measure)measure.getStarMeasure()).getBitPosition();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        for (Target target : this.targets) {
            RolapLevel level = target.level;
            if (level.isAll()) continue;
            RolapStar.Column column = ((RolapCubeLevel)level).getStarKeyColumn();
            levelBitKey.set(column.getBitPosition());
        }
        measureBitKey.set(bitPosition);
        AggStar aggStar = AggregationManager.instance().findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
        if (aggStar == null) {
            return null;
        }
        for (Target target : this.targets) {
            RolapLevel level = target.level;
            if (level.isAll() || !this.isLevelCollapsed(aggStar, (RolapCubeLevel)level) || !this.levelContainsMultipleColumns(level)) continue;
            return null;
        }
        return aggStar;
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WhichSelect {
        ONLY,
        NOT_LAST,
        LAST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Target {
        final RolapLevel level;
        final MemberCache cache;
        final Object cacheLock;
        RolapLevel[] levels;
        List<RolapMember> list;
        int levelDepth;
        boolean parentChild;
        List<RolapMember> members;
        List<List<RolapMember>> siblings;
        final TupleReader.MemberBuilder memberBuilder;
        private final List<RolapMember> srcMembers;
        private RolapMember currMember;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
            this.level = level;
            this.cache = memberBuilder.getMemberCache();
            this.cacheLock = memberBuilder.getMemberCacheLock();
            this.memberBuilder = memberBuilder;
            this.srcMembers = srcMembers;
        }

        public void open() {
            int i;
            this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
            this.list = new ArrayList<RolapMember>();
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            this.members = new ArrayList<RolapMember>();
            for (i = 0; i < this.levels.length; ++i) {
                this.members.add(null);
            }
            this.siblings = new ArrayList<List<RolapMember>>();
            for (i = 0; i < this.levels.length + 1; ++i) {
                this.siblings.add(new ArrayList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addRow(ResultSet resultSet, int column) throws SQLException {
            Object object = this.cacheLock;
            synchronized (object) {
                return this.internalAddRow(resultSet, column);
            }
        }

        private int internalAddRow(ResultSet resultSet, int column) throws SQLException {
            RolapMember member = null;
            if (this.currMember != null) {
                member = this.currMember;
            } else {
                boolean checkCacheStatus = true;
                for (int i = 0; i <= this.levelDepth; ++i) {
                    MemberChildrenConstraint mcc;
                    Object value;
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = this.level.getHierarchy().getAllMember();
                        continue;
                    }
                    RolapMember parentMember = member;
                    if (this.parentChild) {
                        Object parentKey;
                        Object parentValue;
                        if ((parentValue = resultSet.getObject(++column)) == null) {
                            parentValue = RolapUtil.sqlNullValue;
                        } else if (!parentValue.toString().equals(childLevel.getNullParentValue()) && (parentMember = this.cache.getMember(parentKey = this.cache.makeKey(member, parentValue))) == null) {
                            ++SqlTupleReader.this.missedMemberCount;
                            return -1;
                        }
                    }
                    if ((value = resultSet.getObject(++column)) == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    Object captionValue = childLevel.hasCaptionColumn() ? resultSet.getObject(++column) : null;
                    Object key = this.parentChild ? this.cache.makeKey(member, value) : this.cache.makeKey(parentMember, value);
                    member = this.cache.getMember(key, checkCacheStatus);
                    checkCacheStatus = false;
                    if (member == null) {
                        member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, resultSet, key, column);
                    }
                    if (!childLevel.getOrdinalExp().equals((Object)childLevel.getKeyExp())) {
                        ++column;
                    }
                    column += childLevel.getProperties().length;
                    if (member == this.members.get(i)) continue;
                    List<RolapMember> children = this.siblings.get(i + 1);
                    if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members.get(i))) != null) {
                        this.cache.putChildren(this.members.get(i), mcc, children);
                    }
                    mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                    List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                    if (i < this.levelDepth && cachedChildren == null) {
                        this.siblings.set(i + 1, new ArrayList());
                    } else {
                        this.siblings.set(i + 1, null);
                    }
                    this.members.set(i, member);
                    if (this.siblings.get(i) == null) continue;
                    if (value == RolapUtil.sqlNullValue) {
                        this.addAsOldestSibling(this.siblings.get(i), member);
                        continue;
                    }
                    this.siblings.get(i).add(member);
                }
                this.currMember = member;
            }
            this.list.add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<RolapMember> close() {
            Object object = this.cacheLock;
            synchronized (object) {
                return this.internalClose();
            }
        }

        public List<RolapMember> internalClose() {
            for (int i = 0; i < this.members.size(); ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members.get(i);
                List<RolapMember> children = this.siblings.get(i + 1);
                if (member == null || children == null || member.getDepth() < this.level.getDepth() || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return this.list;
        }

        private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public String toString() {
            return this.level.getUniqueName();
        }
    }
}

