/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jrx.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.tools.codec.Base64Encoder;

public class JRXPathQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jrx$query$JRXPathQueryExecuter == null ? (class$com$jaspersoft$jrx$query$JRXPathQueryExecuter = JRXPathQueryExecuter.class$("com.jaspersoft.jrx.query.JRXPathQueryExecuter")) : class$com$jaspersoft$jrx$query$JRXPathQueryExecuter));
    private final Document document;
    static /* synthetic */ Class class$com$jaspersoft$jrx$query$JRXPathQueryExecuter;

    public JRXPathQueryExecuter(JRDataset dataset, Map parametersMap) {
        super(dataset, parametersMap);
        Document tmpDocument = (Document)this.getParameterValue("XML_DATA_DOCUMENT");
        if (tmpDocument == null) {
            String url = (String)this.getParameterValue("XML_URL");
            if (url != null && url.trim().length() > 0) {
                try {
                    tmpDocument = this.getDocumentFromUrl(parametersMap);
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    tmpDocument = null;
                }
            }
            if (tmpDocument == null) {
                log.warn((Object)"The supplied org.w3c.dom.Document object is null.");
            }
        }
        this.document = tmpDocument;
        this.parseQuery();
    }

    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    public JRDataSource createDatasource() throws JRException {
        JRXmlDataSource datasource = null;
        String xPath = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("XPath query: " + xPath));
        }
        if (this.document != null && xPath != null) {
            datasource = new JRXmlDataSource(this.document, xPath);
            datasource.setLocale((Locale)this.getParameterValue("XML_LOCALE"));
            datasource.setDatePattern((String)this.getParameterValue("XML_DATE_PATTERN"));
            datasource.setNumberPattern((String)this.getParameterValue("XML_NUMBER_PATTERN"));
            datasource.setTimeZone((TimeZone)this.getParameterValue("XML_TIME_ZONE"));
        }
        return datasource;
    }

    public void close() {
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }

    private Document getDocumentFromUrl(Map parametersMap) throws Exception {
        String urlString = (String)this.getParameterValue("XML_URL");
        Iterator i = parametersMap.keySet().iterator();
        String div = "?";
        URL url = new URL(urlString);
        if (url.getQuery() != null) {
            div = "&";
        }
        while (i.hasNext()) {
            String keyName = "" + i.next();
            if (!keyName.startsWith("XML_GET_PARAM_")) continue;
            String paramName = keyName.substring("XML_GET_PARAM_".length());
            String value = (String)this.getParameterValue(keyName);
            urlString = urlString + div + URLEncoder.encode(paramName, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
            div = "&";
        }
        url = new URL(urlString);
        if (url.getProtocol().toLowerCase().equals("file")) {
            return JRXmlUtils.parse((InputStream)url.openStream());
        }
        if (url.getProtocol().toLowerCase().equals("http") || url.getProtocol().toLowerCase().equals("https")) {
            String username = (String)this.getParameterValue("XML_USERNAME");
            String password = (String)this.getParameterValue("XML_PASSWORD");
            if (url.getProtocol().toLowerCase().equals("https")) {
                String socketFactory = JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.xPath.DefaultSSLSocketFactory");
                if (socketFactory == null) {
                    socketFactory = JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.XPath.DefaultSSLSocketFactory");
                }
                if (socketFactory != null) {
                    Class clazz = class$com$jaspersoft$jrx$query$JRXPathQueryExecuter == null ? (class$com$jaspersoft$jrx$query$JRXPathQueryExecuter = JRXPathQueryExecuter.class$("com.jaspersoft.jrx.query.JRXPathQueryExecuter")) : class$com$jaspersoft$jrx$query$JRXPathQueryExecuter;
                    HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)Class.forName(socketFactory).newInstance());
                } else {
                    log.debug((Object)"No SSLSocketFactory defined, using default");
                }
                String hostnameVerifyer = JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.xPath.DefaultHostnameVerifier");
                if (hostnameVerifyer == null) {
                    hostnameVerifyer = JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.XPath.DefaultHostnameVerifier");
                }
                if (hostnameVerifyer != null) {
                    Class clazz = class$com$jaspersoft$jrx$query$JRXPathQueryExecuter == null ? (class$com$jaspersoft$jrx$query$JRXPathQueryExecuter = JRXPathQueryExecuter.class$("com.jaspersoft.jrx.query.JRXPathQueryExecuter")) : class$com$jaspersoft$jrx$query$JRXPathQueryExecuter;
                    HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)Class.forName(hostnameVerifyer).newInstance());
                } else {
                    log.debug((Object)"No HostnameVerifier defined, using default");
                }
            }
            URLConnection conn = url.openConnection();
            if (username != null && username.length() > 0 && password != null) {
                ByteArrayInputStream bytesIn = new ByteArrayInputStream((username + ":" + password).getBytes());
                ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
                Base64Encoder enc = new Base64Encoder((InputStream)bytesIn, (OutputStream)dataOut);
                enc.process();
                String encoding = dataOut.toString();
                conn.setRequestProperty("Authorization", "Basic " + encoding);
            }
            i = parametersMap.keySet().iterator();
            String data = "";
            div = "";
            while (i.hasNext()) {
                String keyName = "" + i.next();
                if (!keyName.startsWith("XML_POST_PARAM_")) continue;
                String paramName = keyName.substring("XML_POST_PARAM_".length());
                String value = (String)this.getParameterValue(keyName);
                data = data + div + URLEncoder.encode(paramName, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                div = "&";
            }
            conn.setDoOutput(true);
            if (data.length() > 0) {
                conn.setDoInput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data);
                wr.flush();
            }
            return JRXmlUtils.parse((InputStream)conn.getInputStream());
        }
        throw new JRException("URL protocol not supported");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

