/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.validation.ElementValidationItem;
import com.jaspersoft.ireport.jasperserver.validation.ImageElementValidationItem;
import com.jaspersoft.ireport.jasperserver.validation.SubReportElementValidationItem;
import com.jaspersoft.ireport.jasperserver.validation.TemplateElementValidationItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;

public class RepositoryJrxmlFile
extends RepositoryFile {
    public RepositoryJrxmlFile(JServer server, ResourceDescriptor descriptor) {
        super(server, descriptor);
    }

    public String toString() {
        if (this.getDescriptor() != null) {
            return "" + this.getDescriptor().getLabel();
        }
        return "???";
    }

    public String getExtension() {
        return "jrxml";
    }

    public static String getValidName(String name, ResourceDescriptor ruDesc) {
        return RepositoryJrxmlFile.getValidName(name, ruDesc, 0);
    }

    private static String getValidName(String name, ResourceDescriptor ruDesc, int k) {
        String ext = "";
        String base = name;
        if (name.lastIndexOf(".") > 0) {
            ext = name.substring(name.lastIndexOf("."));
            base = name.substring(0, name.lastIndexOf("."));
        }
        String newName = base + (k == 0 ? "" : "-" + k) + ext;
        for (int i = 0; i < ruDesc.getChildren().size(); ++i) {
            ResourceDescriptor rd = (ResourceDescriptor)ruDesc.getChildren().get(i);
            if (!rd.getName().equals(newName)) continue;
            return RepositoryJrxmlFile.getValidName(name, ruDesc, ++k);
        }
        return newName;
    }

    public static File getFileFromExpression(String exp, String clazz, String baseDir) {
        if (clazz == null || clazz.equals("java.lang.String")) {
            File f;
            if (!baseDir.endsWith(File.separator)) {
                baseDir = baseDir + File.separator;
            }
            if (exp.startsWith("$P{SUBREPORT_DIR} + ")) {
                exp = exp.substring("$P{SUBREPORT_DIR} + ".length());
                if (baseDir != null) {
                    exp = baseDir + exp;
                }
            } else if (exp.startsWith("\".\\\\")) {
                exp = baseDir + exp.substring(4);
            } else if (exp.startsWith("\"./")) {
                exp = baseDir + exp.substring(3);
            }
            exp = Misc.string_replace((String)"\\", (String)"\\\\", (String)exp);
            if ((exp = Misc.string_replace((String)"", (String)"\"", (String)exp)).toLowerCase().endsWith(".jasper")) {
                exp = exp.substring(0, exp.lastIndexOf(".jasper")) + ".jrxml";
            }
            if (!((f = new File(exp)).exists() || f.getParent() != null && !f.getParent().equals("") || (f = new File(baseDir, f.getName())).exists())) {
                return null;
            }
            return f;
        }
        return null;
    }

    public static List identifyElementValidationItems(JasperDesign report, ResourceDescriptor parentDescriptor, String reportDir) {
        String name;
        ElementValidationItem ievi;
        File f;
        String fname;
        JRReportTemplate[] templates;
        ArrayList<ElementValidationItem> elementValidationItems = new ArrayList<ElementValidationItem>();
        for (JRReportTemplate template : templates = report.getTemplates()) {
            fname = Misc.getExpressionText((JRExpression)template.getSourceExpression());
            f = RepositoryJrxmlFile.getFileFromExpression(fname, "java.lang.String", reportDir);
            if (f == null) continue;
            ievi = new TemplateElementValidationItem(template);
            ievi.setOriginalFileName(f);
            name = RepositoryJrxmlFile.getValidName(f.getName(), parentDescriptor);
            ievi.setParentFolder(parentDescriptor.getParentFolder());
            ievi.setResourceName(name);
            ievi.setProposedExpression("\"repo:" + name + "\"");
            elementValidationItems.add(ievi);
        }
        List elements = ModelUtils.getAllElements((JasperDesign)report, (boolean)true);
        for (JRDesignElement re : elements) {
            JRDesignSubreport sre;
            if (re instanceof JRDesignImage) {
                JRDesignImage ire = (JRDesignImage)re;
                if (ire.getExpression() == null || (f = RepositoryJrxmlFile.getFileFromExpression(fname = ire.getExpression().getText(), ire.getExpression().getValueClassName(), reportDir)) == null) continue;
                ievi = new ImageElementValidationItem();
                ievi.setOriginalFileName(f);
                name = RepositoryJrxmlFile.getValidName(f.getName(), parentDescriptor);
                ievi.setParentFolder(parentDescriptor.getParentFolder());
                ievi.setResourceName(name);
                ievi.setProposedExpression("\"repo:" + name + "\"");
                ievi.setReportElement((JRDesignElement)ire);
                elementValidationItems.add(ievi);
                continue;
            }
            if (!(re instanceof JRDesignSubreport) || (sre = (JRDesignSubreport)re).getExpression() == null || (f = RepositoryJrxmlFile.getFileFromExpression(fname = sre.getExpression().getText(), sre.getExpression().getValueClassName(), reportDir)) == null) continue;
            ievi = new SubReportElementValidationItem();
            ievi.setOriginalFileName(f);
            name = RepositoryJrxmlFile.getValidName(f.getName(), parentDescriptor);
            ievi.setParentFolder(parentDescriptor.getParentFolder());
            ievi.setResourceName(name);
            ievi.setProposedExpression("\"repo:" + name + "\"");
            ievi.setReportElement((JRDesignElement)sre);
            elementValidationItems.add(ievi);
        }
        return elementValidationItems;
    }
}

