/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.highlighting.CompoundHighlightsContainer;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerFilter;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public final class HighlightingManager {
    private static final Logger LOG = Logger.getLogger(HighlightingManager.class.getName());
    private static HighlightingManager instance;

    public static synchronized HighlightingManager getInstance() {
        if (instance == null) {
            instance = new HighlightingManager();
        }
        return instance;
    }

    public synchronized HighlightsContainer getHighlights(JTextComponent jTextComponent, HighlightsLayerFilter highlightsLayerFilter) {
        Highlighting highlighting = (Highlighting)jTextComponent.getClientProperty(Highlighting.class);
        if (highlighting == null) {
            highlighting = new Highlighting(jTextComponent);
            jTextComponent.putClientProperty(Highlighting.class, highlighting);
        }
        return highlighting.getContainer(highlightsLayerFilter == null ? HighlightsLayerFilter.IDENTITY : highlightsLayerFilter);
    }

    private HighlightingManager() {
    }

    private static String simpleToString(Object object) {
        return object == null ? "null" : object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    private static String mimePathsToString(MimePath ... mimePathArray) {
        if (mimePathArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (MimePath mimePath : mimePathArray) {
            stringBuilder.append('\'').append(mimePath.getPath()).append('\'');
            stringBuilder.append(",");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegExpFilter
    implements HighlightsLayerFilter {
        private final List<Pattern> includes;
        private final List<Pattern> excludes;

        public RegExpFilter(Object object, Object object2) {
            this.includes = RegExpFilter.buildPatterns(object);
            this.excludes = RegExpFilter.buildPatterns(object2);
        }

        @Override
        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            List<? extends HighlightsLayer> list2 = this.includes.isEmpty() ? list : RegExpFilter.filter(list, this.includes, true);
            List<? extends HighlightsLayer> list3 = this.excludes.isEmpty() ? list2 : RegExpFilter.filter(list2, this.excludes, false);
            return list3;
        }

        private static List<? extends HighlightsLayer> filter(List<? extends HighlightsLayer> list, List<Pattern> list2, boolean bl) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                for (Pattern pattern : list2) {
                    boolean bl2 = pattern.matcher(highlightsLayerAccessor.getLayerTypeId()).matches();
                    if (bl2 && bl) {
                        arrayList.add(highlightsLayer);
                    }
                    if (bl2 || bl) continue;
                    arrayList.add(highlightsLayer);
                }
            }
            return arrayList;
        }

        private static List<Pattern> buildPatterns(Object object) {
            ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
            if (object instanceof String) {
                try {
                    arrayList.add(Pattern.compile((String)object));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    LOG.log(Level.WARNING, "Ignoring invalid regexp for the HighlightsLayer filtering.", patternSyntaxException);
                }
            } else if (object instanceof String[]) {
                for (String string : (String[])object) {
                    try {
                        arrayList.add(Pattern.compile(string));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        LOG.log(Level.WARNING, "Ignoring invalid regexp for the HighlightsLayer filtering.", patternSyntaxException);
                    }
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Highlighting
    implements PropertyChangeListener {
        private static final String PROP_MIME_TYPE = "mimeType";
        private static final String PROP_DOCUMENT = "document";
        private static final String PROP_HL_INCLUDES = "HighlightsLayerIncludes";
        private static final String PROP_HL_EXCLUDES = "HighlightsLayerExcludes";
        private Lookup.Result<HighlightsLayerFactory> factories = null;
        private LookupListener factoriesTracker = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                Highlighting.this.rebuildAllLayers();
            }
        };
        private Lookup.Result<FontColorSettings> settings = null;
        private LookupListener settingsTracker = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                Highlighting.this.rebuildAllLayers();
            }
        };
        private final JTextComponent pane;
        private HighlightsLayerFilter paneFilter;
        private Reference<Document> lastKnownDocumentRef;
        private MimePath[] lastKnownMimePaths = null;
        private boolean inRebuildAllLayers = false;
        private List<? extends HighlightsLayer> allLayers = null;
        private List<HighlightsContainer> allLayerContainers = null;
        private final WeakHashMap<HighlightsLayerFilter, WeakReference<CompoundHighlightsContainer>> containers = new WeakHashMap();

        public Highlighting(JTextComponent jTextComponent) {
            this.pane = jTextComponent;
            this.paneFilter = new RegExpFilter(jTextComponent.getClientProperty(PROP_HL_INCLUDES), jTextComponent.getClientProperty(PROP_HL_EXCLUDES));
            this.pane.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jTextComponent));
            this.rebuildAll();
        }

        public synchronized HighlightsContainer getContainer(HighlightsLayerFilter highlightsLayerFilter) {
            CompoundHighlightsContainer compoundHighlightsContainer;
            WeakReference<CompoundHighlightsContainer> weakReference = this.containers.get(highlightsLayerFilter);
            CompoundHighlightsContainer compoundHighlightsContainer2 = compoundHighlightsContainer = weakReference == null ? null : (CompoundHighlightsContainer)weakReference.get();
            if (compoundHighlightsContainer == null) {
                compoundHighlightsContainer = new CompoundHighlightsContainer();
                this.rebuildContainer(this.pane.getDocument(), highlightsLayerFilter, compoundHighlightsContainer);
                this.containers.put(highlightsLayerFilter, new WeakReference<CompoundHighlightsContainer>(compoundHighlightsContainer));
            }
            return compoundHighlightsContainer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || PROP_DOCUMENT.equals(propertyChangeEvent.getPropertyName())) {
                this.rebuildAll();
            }
            if (PROP_HL_INCLUDES.equals(propertyChangeEvent.getPropertyName()) || PROP_HL_EXCLUDES.equals(propertyChangeEvent.getPropertyName())) {
                Highlighting highlighting = this;
                synchronized (highlighting) {
                    this.paneFilter = new RegExpFilter(this.pane.getClientProperty(PROP_HL_INCLUDES), this.pane.getClientProperty(PROP_HL_EXCLUDES));
                    this.rebuildAllContainers(this.pane.getDocument());
                }
            }
        }

        private MimePath[] getAllDocumentMimePath() {
            Document document = this.pane.getDocument();
            Object object = document.getProperty(PROP_MIME_TYPE);
            String string = object != null ? object.toString() : this.pane.getUI().getEditorKit(this.pane).getContentType();
            return new MimePath[]{MimePath.parse((String)string)};
        }

        private synchronized void rebuildAll() {
            Document document;
            ProxyLookup proxyLookup = this.getAllDocumentMimePath();
            Document document2 = document = this.lastKnownDocumentRef == null ? null : this.lastKnownDocumentRef.get();
            if (!Utilities.compareObjects((Object)document, (Object)this.pane.getDocument()) || !Arrays.equals(this.lastKnownMimePaths, (Object[])proxyLookup)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("rebuildAll: lastKnownDocument = " + HighlightingManager.simpleToString(document) + ", document = " + HighlightingManager.simpleToString(this.pane.getDocument()) + ", lastKnownMimePaths = " + HighlightingManager.mimePathsToString(this.lastKnownMimePaths) + ", mimePaths = " + HighlightingManager.mimePathsToString((MimePath[])proxyLookup));
                }
                if (this.factories != null) {
                    this.factories.removeLookupListener(this.factoriesTracker);
                }
                if (this.settings != null) {
                    this.settings.removeLookupListener(this.settingsTracker);
                }
                if (proxyLookup != null) {
                    ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
                    for (Object object : proxyLookup) {
                        arrayList.add(MimeLookup.getLookup((MimePath)object));
                    }
                    ProxyLookup proxyLookup2 = new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
                    this.factories = proxyLookup2.lookup(new Lookup.Template(HighlightsLayerFactory.class));
                    this.settings = proxyLookup2.lookup(new Lookup.Template(FontColorSettings.class));
                } else {
                    this.factories = null;
                    this.settings = null;
                }
                if (this.factories != null) {
                    this.factories.addLookupListener(this.factoriesTracker);
                    this.factories.allItems();
                }
                if (this.settings != null) {
                    this.settings.addLookupListener(this.settingsTracker);
                    this.settings.allItems();
                }
                document = this.pane.getDocument();
                this.lastKnownMimePaths = proxyLookup;
                this.rebuildAllLayers();
            }
        }

        private synchronized void resetAllContainers() {
            for (HighlightsLayerFilter highlightsLayerFilter : this.containers.keySet()) {
                WeakReference<CompoundHighlightsContainer> weakReference = this.containers.get(highlightsLayerFilter);
                CompoundHighlightsContainer compoundHighlightsContainer = weakReference == null ? null : (CompoundHighlightsContainer)weakReference.get();
                if (compoundHighlightsContainer == null) continue;
                compoundHighlightsContainer.resetCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void rebuildAllLayers() {
            if (this.inRebuildAllLayers) {
                return;
            }
            this.inRebuildAllLayers = true;
            try {
                Document document = this.pane.getDocument();
                if (this.factories != null) {
                    HighlightsLayer highlightsLayer;
                    HighlightsLayer highlightsLayer2;
                    Object object2;
                    Collection collection = this.factories.allInstances();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    HighlightsLayerFactory.Context context = HighlightingSpiPackageAccessor.get().createFactoryContext(document, this.pane);
                    for (Object object2 : collection) {
                        highlightsLayer2 = object2.createLayers(context);
                        if (highlightsLayer2 == null) continue;
                        for (Object object3 : highlightsLayer2) {
                            HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor((HighlightsLayer)object3);
                            String string = highlightsLayerAccessor.getLayerTypeId();
                            if (hashMap.containsKey(string)) continue;
                            hashMap.put(string, object3);
                        }
                    }
                    try {
                        highlightsLayer = HighlightingSpiPackageAccessor.get().sort(hashMap.values());
                    }
                    catch (TopologicalSortException topologicalSortException) {
                        ErrorManager.getDefault().notify((Throwable)topologicalSortException);
                        highlightsLayer = highlightsLayer2 = topologicalSortException.partialSort();
                    }
                    object2 = new ArrayList();
                    highlightsLayer2 = highlightsLayer.iterator();
                    while (highlightsLayer2.hasNext()) {
                        HighlightsLayer highlightsLayer3 = (HighlightsLayer)highlightsLayer2.next();
                        HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer3);
                        ((ArrayList)object2).add(highlightsLayerAccessor.getContainer());
                    }
                    this.allLayers = highlightsLayer;
                    this.allLayerContainers = object2;
                } else {
                    this.allLayers = null;
                    this.allLayerContainers = null;
                }
                this.rebuildAllContainers(document);
            }
            finally {
                this.inRebuildAllLayers = false;
            }
        }

        private synchronized void rebuildAllContainers(Document document) {
            if (LOG.isLoggable(Level.FINE)) {
                Iterator<HighlightsLayerFilter> iterator = this.lastKnownDocumentRef == null ? null : this.lastKnownDocumentRef.get();
                LOG.fine("rebuildAllContainers: lastKnownDocument = " + HighlightingManager.simpleToString(iterator) + ", lastKnownMimePaths = " + HighlightingManager.mimePathsToString(this.lastKnownMimePaths));
            }
            for (HighlightsLayerFilter highlightsLayerFilter : this.containers.keySet()) {
                WeakReference<CompoundHighlightsContainer> weakReference = this.containers.get(highlightsLayerFilter);
                CompoundHighlightsContainer compoundHighlightsContainer = weakReference == null ? null : (CompoundHighlightsContainer)weakReference.get();
                if (compoundHighlightsContainer == null) continue;
                this.rebuildContainer(document, highlightsLayerFilter, compoundHighlightsContainer);
            }
        }

        private synchronized void rebuildContainer(Document document, HighlightsLayerFilter highlightsLayerFilter, CompoundHighlightsContainer compoundHighlightsContainer) {
            if (this.allLayers != null) {
                List<? extends HighlightsLayer> list = this.paneFilter.filterLayers(Collections.unmodifiableList(this.allLayers));
                list = highlightsLayerFilter.filterLayers(Collections.unmodifiableList(list));
                ArrayList<HighlightsContainer> arrayList = new ArrayList<HighlightsContainer>();
                for (HighlightsLayer highlightsLayer : list) {
                    int n = this.allLayers.indexOf(highlightsLayer);
                    HighlightsContainer highlightsContainer = this.allLayerContainers.get(n);
                    arrayList.add(highlightsContainer);
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    Highlighting.logLayers(this.pane.getDocument(), this.lastKnownMimePaths, list, Level.FINEST);
                }
                compoundHighlightsContainer.setLayers(document, arrayList.toArray(new HighlightsContainer[arrayList.size()]));
            } else {
                compoundHighlightsContainer.setLayers(null, null);
            }
        }

        private static void logLayers(Document document, MimePath[] mimePathArray, List<? extends HighlightsLayer> list, Level level) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HighlighsLayers {\n");
            stringBuilder.append(" * document : ");
            stringBuilder.append(document.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(document)));
            Object object = document.getProperty("stream");
            stringBuilder.append(" [").append(object == null ? "no stream descriptor" : object.toString()).append(']');
            stringBuilder.append("\n");
            stringBuilder.append(" * mime paths : \n");
            for (MimePath mimePath : mimePathArray) {
                stringBuilder.append("    ");
                stringBuilder.append(mimePath.getPath());
                stringBuilder.append("\n");
            }
            stringBuilder.append(" * layers : \n");
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                stringBuilder.append("    ");
                stringBuilder.append(highlightsLayerAccessor.getLayerTypeId());
                stringBuilder.append('[');
                stringBuilder.append(highlightsLayerAccessor.getZOrder().toString());
                stringBuilder.append(']');
                stringBuilder.append('@');
                stringBuilder.append(Integer.toHexString(System.identityHashCode(highlightsLayer)));
                stringBuilder.append("\n");
            }
            stringBuilder.append("}\n");
            LOG.log(level, stringBuilder.toString());
        }
    }
}

