/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import mondrian.tui.XmlaSupport;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxy;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianInprocProxy
implements XmlaOlap4jProxy {
    private final Map<String, String> catalogNameUrls;
    private final String urlString;
    private static final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    public MondrianInprocProxy(Map<String, String> catalogNameUrls, String urlString) {
        this.catalogNameUrls = catalogNameUrls;
        if (!urlString.startsWith("jdbc:mondrian:")) {
            throw new IllegalArgumentException();
        }
        this.urlString = urlString.substring("jdbc:mondrian:".length());
    }

    public byte[] get(URL url, String request) throws IOException {
        try {
            return XmlaSupport.processSoapXmla(request, this.urlString, this.catalogNameUrls, null);
        }
        catch (ServletException e) {
            throw new RuntimeException("Error while reading '" + url + "'", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error while reading '" + url + "'", e);
        }
    }

    public Future<byte[]> submit(final URL url, final String request) {
        return singleThreadExecutor.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return MondrianInprocProxy.this.get(url, request);
            }
        });
    }

    public String getEncodingCharsetName() {
        return "UTF-8";
    }
}

