/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.type.SetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemberListCalc
extends AbstractCalc
implements MemberListCalc {
    private final Calc[] calcs;
    private final boolean mutable;

    protected AbstractMemberListCalc(Exp exp, Calc[] calcs) {
        this(exp, calcs, true);
    }

    protected AbstractMemberListCalc(Exp exp, Calc[] calcs, boolean mutable) {
        super(exp);
        this.calcs = calcs;
        this.mutable = mutable;
        assert (this.type instanceof SetType) : "expecting a set: " + this.getType();
        assert (this.getType().getArity() == 1);
    }

    @Override
    public SetType getType() {
        return (SetType)super.getType();
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        List<Member> memberList = this.evaluateMemberList(evaluator);
        assert (memberList != null) : "null as empty memberList is deprecated";
        return memberList;
    }

    @Override
    public Calc[] getCalcs() {
        return this.calcs;
    }

    @Override
    public ResultStyle getResultStyle() {
        return this.mutable ? ResultStyle.MUTABLE_LIST : ResultStyle.LIST;
    }

    public String toString() {
        return "AbstractMemberListCalc object";
    }

    @Override
    public List<Member> evaluateList(Evaluator evaluator) {
        return this.evaluateMemberList(evaluator);
    }

    public List<Member[]> evaluateTupleList(Evaluator evaluator) {
        throw new UnsupportedOperationException();
    }
}

