/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.Commands;
import org.netbeans.modules.glassfish.common.RestartTask;
import org.netbeans.modules.glassfish.common.StartTask;
import org.netbeans.modules.glassfish.common.StopTask;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonServerSupport
implements GlassfishModule,
RefreshModulesCookie {
    public static final String URI_PREFIX = "deployer:gfv3";
    private final transient Lookup lookup;
    private final Map<String, String> properties = Collections.synchronizedMap(new HashMap(37));
    private volatile GlassfishModule.ServerState serverState = GlassfishModule.ServerState.STOPPED;
    private final Object stateMonitor = new Object();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject instanceFO;
    private volatile boolean startedByIde = false;
    private final AtomicBoolean refreshRunning = new AtomicBoolean(false);

    CommonServerSupport(Lookup lookup, Map<String, String> map) {
        this.lookup = lookup;
        String string = CommonServerSupport.updateString(map, "host", "localhost");
        String string2 = CommonServerSupport.updateString(map, "homefolder", "");
        int n = CommonServerSupport.updateInt(map, "httpportnumber", 8080);
        CommonServerSupport.updateString(map, "displayName", "GlassFish V3 Prelude");
        CommonServerSupport.updateInt(map, "adminPort", 4848);
        CommonServerSupport.updateString(map, "domainsfolder", string2 + File.separator + "domains");
        CommonServerSupport.updateString(map, "domainname", "domain1");
        CommonServerSupport.updateString(map, "preserveSessionsOn", "true");
        if (map.get("url") == null) {
            String string3 = CommonServerSupport.formatUri(string2, string, n);
            map.put("url", string3);
        }
        map.put("jvmMode", "normalMode");
        this.properties.putAll(map);
        this.properties.put("username", "admin");
        this.properties.put("password", "adminadmin");
        this.instanceFO = this.getInstanceFileObject();
        if (CommonServerSupport.isRunning(string, n)) {
            this.refresh();
        }
    }

    public static String formatUri(String string, String string2, int n) {
        return "[" + string + "]" + URI_PREFIX + ":" + string2 + ":" + n;
    }

    private static String updateString(Map<String, String> map, String string, String string2) {
        String string3 = map.get(string);
        if (string3 == null) {
            map.put(string, string2);
            string3 = string2;
        }
        return string3;
    }

    private static int updateInt(Map<String, String> map, String string, int n) {
        int n2;
        String string2 = map.get(string);
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            map.put(string, Integer.toString(n));
            n2 = n;
        }
        return n2;
    }

    private FileObject getInstanceFileObject() {
        String string;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("/GlassFish/Instances");
        if (fileObject != null && (string = this.properties.get("InstanceFOPath")) != null) {
            return fileObject.getFileObject(string);
        }
        return null;
    }

    public String getInstallRoot() {
        return this.properties.get("installfolder");
    }

    public String getGlassfishRoot() {
        return this.properties.get("homefolder");
    }

    public String getDisplayName() {
        return this.properties.get("displayName");
    }

    public String getDeployerUri() {
        return this.properties.get("url");
    }

    public String getUserName() {
        return this.properties.get("username");
    }

    public String getPassword() {
        return this.properties.get("password");
    }

    public String getAdminPort() {
        return this.properties.get("adminPort");
    }

    public String getHttpPort() {
        return this.properties.get("httpportnumber");
    }

    public int getHttpPortNumber() {
        int n = -1;
        try {
            n = Integer.parseInt(this.properties.get("httpportnumber"));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish").log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
        }
        return n;
    }

    public String getHostName() {
        return this.properties.get("host");
    }

    public String getDomainsRoot() {
        String string = this.properties.get("domainsfolder");
        if (null == string) {
            string = this.properties.get("homefolder") + File.separator + "domains";
        }
        return string;
    }

    public String getDomainName() {
        String string = this.properties.get("domainname");
        if (null == string) {
            string = "domain1";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerState(GlassfishModule.ServerState serverState) {
        boolean bl = false;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.serverState != serverState) {
                this.serverState = serverState;
                bl = true;
            }
        }
        if (bl) {
            this.changeSupport.fireChange();
        }
    }

    boolean isStartedByIde() {
        return this.startedByIde;
    }

    @Override
    public Map<String, String> getInstanceProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener operationStateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"" + Thread.currentThread().getName() + "\"");
        OperationStateListener operationStateListener2 = new OperationStateListener(){

            public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                if (operationState == GlassfishModule.OperationState.RUNNING) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
                } else if (operationState == GlassfishModule.OperationState.COMPLETED) {
                    CommonServerSupport.this.startedByIde = true;
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                } else if (operationState == GlassfishModule.OperationState.FAILED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                }
            }
        };
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, this.getRecognizers(), operationStateListener2, operationStateListener));
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener operationStateListener, FileObject fileObject, String[] stringArray) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"" + Thread.currentThread().getName() + "\"");
        OperationStateListener operationStateListener2 = new OperationStateListener(){

            public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                if (operationState == GlassfishModule.OperationState.RUNNING) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
                } else if (operationState == GlassfishModule.OperationState.COMPLETED) {
                    CommonServerSupport.this.startedByIde = true;
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                } else if (operationState == GlassfishModule.OperationState.FAILED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                }
            }
        };
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, this.getRecognizers(), fileObject, stringArray, operationStateListener2, operationStateListener));
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    private List<Recognizer> getRecognizers() {
        List<Recognizer> list;
        Collection collection = this.lookup.lookupAll(RecognizerCookie.class);
        if (!collection.isEmpty()) {
            list = new LinkedList();
            for (RecognizerCookie recognizerCookie : collection) {
                list.addAll(recognizerCookie.getRecognizers());
            }
            list = Collections.unmodifiableList(list);
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public Future<GlassfishModule.OperationState> stopServer(OperationStateListener operationStateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.stopServer called on thread \"" + Thread.currentThread().getName() + "\"");
        OperationStateListener operationStateListener2 = new OperationStateListener(){

            public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                if (operationState == GlassfishModule.OperationState.RUNNING) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
                } else if (operationState == GlassfishModule.OperationState.COMPLETED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                } else if (operationState == GlassfishModule.OperationState.FAILED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                }
            }
        };
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new StopTask(this, operationStateListener2, operationStateListener));
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    @Override
    public Future<GlassfishModule.OperationState> restartServer(OperationStateListener operationStateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.restartServer called on thread \"" + Thread.currentThread().getName() + "\"");
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new RestartTask(this, operationStateListener));
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener operationStateListener, File file, String string) {
        return this.deploy(operationStateListener, file, string, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener operationStateListener, File file, String string, String string2) {
        CommandRunner commandRunner = new CommandRunner(this.getInstanceProperties(), operationStateListener);
        return commandRunner.deploy(file, string, string2);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener operationStateListener, String string) {
        return this.redeploy(operationStateListener, string, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener operationStateListener, String string, String string2) {
        CommandRunner commandRunner = new CommandRunner(this.getInstanceProperties(), operationStateListener);
        return commandRunner.redeploy(string, string2);
    }

    @Override
    public Future<GlassfishModule.OperationState> undeploy(OperationStateListener operationStateListener, String string) {
        CommandRunner commandRunner = new CommandRunner(this.getInstanceProperties(), operationStateListener);
        return commandRunner.undeploy(string);
    }

    @Override
    public Future<GlassfishModule.OperationState> execute(ServerCommand serverCommand) {
        CommandRunner commandRunner = new CommandRunner(this.getInstanceProperties(), new OperationStateListener[0]);
        return commandRunner.execute(serverCommand);
    }

    @Override
    public AppDesc[] getModuleList(String string) {
        CommandRunner commandRunner = new CommandRunner(this.getInstanceProperties(), new OperationStateListener[0]);
        int n = 0;
        Map<String, List<AppDesc>> map = commandRunner.getApplications(string);
        Collection<List<AppDesc>> collection = map.values();
        for (List<AppDesc> list : collection) {
            n += list.size();
        }
        AppDesc[] appDescArray = new AppDesc[n];
        int n2 = 0;
        for (List<AppDesc> list : collection) {
            for (AppDesc appDesc : list) {
                appDescArray[n2++] = appDesc;
            }
        }
        return appDescArray;
    }

    @Override
    public GlassfishModule.ServerState getServerState() {
        return this.serverState;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setEnvironmentProperty(String string, String string2, boolean bl) {
        String string3 = null;
        Map<String, String> map = this.properties;
        synchronized (map) {
            string3 = this.properties.get(string);
            if (string3 == null || bl) {
                this.properties.put(string, string2);
                this.setInstanceAttr(string, string2);
                string3 = string2;
            }
        }
        return string3;
    }

    void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    void getProperty(String string) {
        this.properties.get(string);
    }

    void setInstanceAttr(String string, String string2) {
        if (this.instanceFO == null || !this.instanceFO.isValid()) {
            this.instanceFO = this.getInstanceFileObject();
        }
        if (this.instanceFO != null) {
            try {
                this.instanceFO.setAttribute(string, (Object)string2);
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute " + string + " for " + this.getDeployerUri(), iOException);
            }
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute " + string + " for " + this.getDeployerUri());
        }
    }

    void setFileObject(FileObject fileObject) {
        this.instanceFO = fileObject;
    }

    public static boolean isRunning(String string, int n) {
        if (null == string) {
            return false;
        }
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            Socket socket = new Socket();
            socket.connect(inetSocketAddress, 1);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isReallyRunning() {
        return CommonServerSupport.isRunning(this.getHostName(), this.getHttpPortNumber()) && this.isReady(false);
    }

    public boolean isReady(boolean bl) {
        boolean bl2 = false;
        int n = bl ? 3 : 1;
        int n2 = 0;
        while (!bl2 && n2++ < n) {
            long l = System.nanoTime();
            Commands.LocationCommand locationCommand = new Commands.LocationCommand();
            try {
                long l2;
                Future<GlassfishModule.OperationState> future = this.execute(locationCommand);
                if (future.get(30L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                    l2 = System.nanoTime();
                    Logger.getLogger("glassfish").log(Level.FINE, locationCommand.getCommand() + " responded in " + (l2 - l) / 1000000L + "ms");
                    String string = this.getGlassfishRoot();
                    String string2 = locationCommand.getInstallRoot();
                    if (string != null && string2 != null) {
                        File file = FileUtil.normalizeFile((File)new File(string));
                        File file2 = FileUtil.normalizeFile((File)new File(string2));
                        bl2 = file.equals(file2);
                        break;
                    }
                    bl2 = false;
                    break;
                }
                if (!locationCommand.retry()) {
                    future = this.execute(new Commands.VersionCommand());
                    bl2 = future.get(30L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED;
                    break;
                }
                l2 = System.nanoTime();
                Logger.getLogger("glassfish").log(Level.FINE, locationCommand.getCommand() + " timed out inside server after " + (l2 - l) / 1000000L + "ms");
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.FINE, locationCommand.getCommand() + " timed out.", exception);
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    private static Future<GlassfishModule.OperationState> failedOperation() {
        return new Future<GlassfishModule.OperationState>(){

            @Override
            public boolean cancel(boolean bl) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public GlassfishModule.OperationState get() throws InterruptedException, ExecutionException {
                return GlassfishModule.OperationState.FAILED;
            }

            @Override
            public GlassfishModule.OperationState get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return GlassfishModule.OperationState.FAILED;
            }
        };
    }

    private static Future<GlassfishModule.OperationState> successfulOperation() {
        return new Future<GlassfishModule.OperationState>(){

            @Override
            public boolean cancel(boolean bl) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public GlassfishModule.OperationState get() throws InterruptedException, ExecutionException {
                return GlassfishModule.OperationState.COMPLETED;
            }

            @Override
            public GlassfishModule.OperationState get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return GlassfishModule.OperationState.COMPLETED;
            }
        };
    }

    @Override
    public void refresh() {
        if (this.refreshRunning.compareAndSet(false, true)) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    boolean bl = CommonServerSupport.this.isReallyRunning();
                    GlassfishModule.ServerState serverState = CommonServerSupport.this.getServerState();
                    if (serverState == GlassfishModule.ServerState.STOPPED && bl) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                    } else if (serverState == GlassfishModule.ServerState.RUNNING && !bl) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                    }
                    CommonServerSupport.this.refreshRunning.set(false);
                }
            });
        }
    }
}

