/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.resourcebundle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import org.jdesktop.layout.GroupLayout;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ResourceBundleTopComponent
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static ResourceBundleTopComponent instance;
    protected transient TreeView view;
    private final InstanceContent ic;
    private final Lookup lookup;
    private transient boolean valid = true;
    private final ExplorerManager manager = new ExplorerManager();
    private static final String PREFERRED_ID = "ResourceBundleTopComponent";
    TopComponent lastSelectedTopComponent = null;

    private ResourceBundleTopComponent() {
        this.initComponents();
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{this.lookup, ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map)}));
        this.setLayout(new BorderLayout());
        this.view = new BeanTreeView();
        this.add((Component)this.view, "Center");
        this.setName(NbBundle.getMessage(ResourceBundleTopComponent.class, (String)"CTL_ResourceBundleTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ResourceBundleTopComponent.class, (String)"HINT_ResourceBundleTopComponent"));
    }

    private DataObject findDataObject(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        System.out.println(tc.getLookup().lookupAll(Object.class));
        System.out.flush();
        DataObject dObj = (DataObject)tc.getLookup().lookup(DataObject.class);
        if (dObj != null) {
            return dObj;
        }
        DataEditorSupport des = (DataEditorSupport)tc.getLookup().lookup(DataEditorSupport.class);
        if (des != null) {
            return des.getDataObject();
        }
        return null;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ResourceBundleTopComponent getDefault() {
        if (instance == null) {
            instance = new ResourceBundleTopComponent();
        }
        return instance;
    }

    public static synchronized ResourceBundleTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ResourceBundleTopComponent.class.getName()).warning("Cannot find ResourceBundleTopComponent component. It will not be located properly in the window system.");
            return ResourceBundleTopComponent.getDefault();
        }
        if (win instanceof ResourceBundleTopComponent) {
            return (ResourceBundleTopComponent)win;
        }
        Logger.getLogger(ResourceBundleTopComponent.class.getName()).warning("There seem to be multiple components with the 'ResourceBundleTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ResourceBundleTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("activated")) {
            System.out.println("TopComponent activated... " + evt.getPropertyName() + " " + evt.getNewValue());
            System.out.flush();
            this.updateTree(false);
        } else if (evt.getPropertyName().equals("opened")) {
            System.out.println("TopComponent opened... " + evt.getPropertyName() + " " + evt.getNewValue());
            System.out.flush();
            this.updateTree(false);
        } else if (evt.getPropertyName().equals("tcOpened")) {
            System.out.println("TopComponent TC opened... " + evt.getPropertyName() + " " + evt.getNewValue());
            System.out.flush();
            this.updateTree(false);
        } else if (evt.getPropertyName().equals("tcClosed")) {
            this.lastSelectedTopComponent = null;
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
            System.out.println("TopComponent TC closed... " + evt.getPropertyName() + " " + evt.getNewValue());
            System.out.println("Still open: " + WindowManager.getDefault().getRegistry().getOpened() + "");
            System.out.flush();
        }
    }

    public void updateTree(boolean closing) {
        TopComponent selectedTc = WindowManager.getDefault().getRegistry().getActivated();
        if (selectedTc != null && !WindowManager.getDefault().isEditorTopComponent(selectedTc)) {
            System.out.println("Activated not an editor...");
            this.lastSelectedTopComponent = null;
            return;
        }
        if (this.lastSelectedTopComponent == null || WindowManager.getDefault().getRegistry().getActivated() != this.lastSelectedTopComponent && !closing) {
            this.lastSelectedTopComponent = WindowManager.getDefault().getRegistry().getActivated();
            if (this.lastSelectedTopComponent != null) {
                DataObject dobj = this.findDataObject(this.lastSelectedTopComponent);
                System.out.println("Found data object: " + dobj);
                if (dobj != null) {
                    DataObject nDO = null;
                    if (dobj.getPrimaryFile() != null && dobj.getPrimaryFile().getParent() != null) {
                        try {
                            nDO = DataObject.find((FileObject)dobj.getPrimaryFile().getParent());
                            if (nDO != null) {
                                this.getExplorerManager().setRootContext(nDO.getNodeDelegate());
                                return;
                            }
                        }
                        catch (DataObjectNotFoundException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.lastSelectedTopComponent == null || !this.lastSelectedTopComponent.isValid() || !this.lastSelectedTopComponent.isVisible()) {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }
}

