/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.ElementDecorator;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.NotRealElementNode;
import com.jaspersoft.ireport.designer.actions.BringElementForwardAction;
import com.jaspersoft.ireport.designer.actions.BringElementToFrontAction;
import com.jaspersoft.ireport.designer.actions.CopyFormatAction;
import com.jaspersoft.ireport.designer.actions.EditTextfieldExpressionAction;
import com.jaspersoft.ireport.designer.actions.EditTextfieldPatternAction;
import com.jaspersoft.ireport.designer.actions.GroupElementsAction;
import com.jaspersoft.ireport.designer.actions.OpenSubreportAction;
import com.jaspersoft.ireport.designer.actions.PaddingAndBordersAction;
import com.jaspersoft.ireport.designer.actions.PasteFormatAction;
import com.jaspersoft.ireport.designer.actions.SendElementBackwardAction;
import com.jaspersoft.ireport.designer.actions.SendElementToBackAction;
import com.jaspersoft.ireport.designer.actions.TransformElementAction;
import com.jaspersoft.ireport.designer.actions.UnGroupElementsAction;
import com.jaspersoft.ireport.designer.charts.ChartDataAction;
import com.jaspersoft.ireport.designer.charts.multiaxis.AddAxisChartAction;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.formatting.actions.OrganizeAsTableAction;
import com.jaspersoft.ireport.designer.menu.HyperlinkAction;
import com.jaspersoft.ireport.designer.outline.nodes.ElementContainerChildren;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNameVisitor;
import com.jaspersoft.ireport.designer.outline.nodes.ElementPasteType;
import com.jaspersoft.ireport.designer.outline.nodes.ExpressionHolder;
import com.jaspersoft.ireport.designer.outline.nodes.HasExpressionVisitor;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.properties.ElementPropertiesFactory;
import com.jaspersoft.ireport.designer.sheet.properties.ExpressionProperty;
import com.jaspersoft.ireport.designer.undo.DeleteElementUndoableEdit;
import com.jaspersoft.ireport.designer.utils.SubMenuAction;
import com.jaspersoft.ireport.designer.utils.WeakPreferenceChangeListener;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignEllipse;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ElementNode
extends IRIndexedNode
implements PropertyChangeListener,
ExpressionHolder,
PreferenceChangeListener {
    JasperDesign jd = null;
    JRDesignElement element = null;
    private ElementNameVisitor elemenNameVisitor = null;

    public JRDesignElement getElement() {
        return this.element;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public void setElement(JRDesignElement element) {
        this.element = element;
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        this.fireDisplayNameChange(null, this.getDisplayName());
    }

    public ElementNode(JasperDesign jd, JRDesignElement element, Children children, Index index, Lookup doLkp) {
        super(children, index, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, element})}));
        this.elemenNameVisitor = new ElementNameVisitor(jd);
        this.jd = jd;
        this.element = element;
        element.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        Preferences preferences = IReportManager.getPreferences();
        IReportManager.getInstance();
        preferences.addPreferenceChangeListener(new WeakPreferenceChangeListener(this, IReportManager.getPreferences()));
        if (element instanceof JRDesignGraphicElement) {
            JRDesignGraphicElement gele = (JRDesignGraphicElement)element;
            ((JRBasePen)gele.getLinePen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        if (element instanceof JRBoxContainer) {
            JRBoxContainer boxcontainer = (JRBoxContainer)element;
            JRBaseLineBox baseBox = (JRBaseLineBox)boxcontainer.getLineBox();
            baseBox.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getTopPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getBottomPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getLeftPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getRightPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public ElementNode(JasperDesign jd, JRDesignElement element, Lookup doLkp) {
        this(jd, element, Children.LEAF, null, doLkp);
    }

    public ElementNode(JasperDesign jd, JRDesignElement element, ElementContainerChildren children, Lookup doLkp) {
        this(jd, element, (Children)children, children.getIndex(), doLkp);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        List<Sheet.Set> propertiesSets = ElementPropertiesFactory.getPropertySets(this.element, this.jd);
        for (int i = 0; i < propertiesSets.size(); ++i) {
            sheet.put(propertiesSets.get(i));
        }
        return sheet;
    }

    public String getDisplayName() {
        if (this.elemenNameVisitor != null && this.getElement() != null) {
            return this.elemenNameVisitor.getName((JRVisitable)this.getElement());
        }
        return super.getDisplayName();
    }

    public boolean canCut() {
        return true;
    }

    public boolean canPaste() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        JRElementGroup container = this.element.getElementGroup();
        int index = 0;
        if (container instanceof JRDesignElementGroup) {
            index = ((JRDesignElementGroup)container).getChildren().indexOf(this.element);
            ((JRDesignElementGroup)container).removeElement(this.element);
        }
        if (container instanceof JRDesignFrame) {
            index = ((JRDesignFrame)container).getChildren().indexOf(this.element);
            ((JRDesignFrame)container).removeElement((JRElement)this.element);
        }
        DeleteElementUndoableEdit edit = new DeleteElementUndoableEdit(this.element, container, index);
        IReportManager.getInstance().addUndoableEdit(edit, true);
        super.destroy();
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Transferable drag() throws IOException {
        return this.clipboardCut();
    }

    public Action[] getActions(boolean popup) {
        List<ElementDecorator> decorators;
        JRDesignElement multiaxischart;
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getElement() instanceof JRDesignSubreport) {
            list.add(SystemAction.get(OpenSubreportAction.class));
            list.add(null);
        }
        if (this.element instanceof JRDesignTextField) {
            list.add(SystemAction.get(EditTextfieldExpressionAction.class));
            list.add(SystemAction.get(EditTextfieldPatternAction.class));
        }
        if (this.getElement() instanceof JRDesignChart && ((JRDesignChart)this.getElement()).getChartType() != 19) {
            list.add((Object)ChartDataAction.getInstance());
            list.add(null);
        }
        if (this.getElement() instanceof JRDesignChart && ((JRDesignChart)this.getElement()).getChartType() == 19) {
            list.add((Object)AddAxisChartAction.getInstance());
            list.add(null);
        }
        if (this.getElement() instanceof JRBoxContainer) {
            list.add(SystemAction.get(PaddingAndBordersAction.class));
        }
        if (this.getElement() instanceof JRHyperlink) {
            list.add((Object)HyperlinkAction.getInstance());
            list.add(null);
        }
        list.add(SystemAction.get(CopyAction.class));
        list.add(SystemAction.get(CutAction.class));
        if (this.canPaste()) {
            list.add(SystemAction.get(PasteAction.class));
        }
        list.add(SystemAction.get(DeleteAction.class));
        list.add(null);
        list.add(SystemAction.get(CopyFormatAction.class));
        list.add(SystemAction.get(PasteFormatAction.class));
        if (this.getElement() instanceof JRDesignRectangle || this.getElement() instanceof JRDesignEllipse || this.getElement() instanceof JRDesignTextField || this.getElement() instanceof JRDesignStaticText || this.getElement() instanceof JRDesignChart) {
            list.add(SystemAction.get(TransformElementAction.class));
        }
        list.add(null);
        list.add(SystemAction.get(GroupElementsAction.class));
        list.add(SystemAction.get(UnGroupElementsAction.class));
        boolean showFormattingTools = true;
        if (this.getParentNode() != null && this.getParentNode() instanceof ElementNode && (multiaxischart = ((ElementNode)this.getParentNode()).getElement()) instanceof JRDesignChart && ((JRDesignChart)multiaxischart).getChartType() == 19) {
            showFormattingTools = false;
        }
        if (showFormattingTools) {
            list.add(SystemAction.get(BringElementToFrontAction.class));
            list.add(SystemAction.get(BringElementForwardAction.class));
            list.add(SystemAction.get(SendElementBackwardAction.class));
            list.add(SystemAction.get(SendElementToBackAction.class));
            list.add(null);
            list.add(SubMenuAction.getAction("Menu/Format/Align"));
            list.add(SubMenuAction.getAction("Menu/Format/Size"));
            list.add(SubMenuAction.getAction("Menu/Format/Position"));
            list.add(null);
            list.add(SubMenuAction.getAction("Menu/Format/Horizontal Spacing"));
            list.add(SubMenuAction.getAction("Menu/Format/Vertical Spacing"));
            list.add(null);
            list.add(SystemAction.get(OrganizeAsTableAction.class));
        }
        if ((decorators = IReportManager.getElementDecorators(this.getElement())).size() > 0) {
            list.add(null);
        }
        for (ElementDecorator decorator : decorators) {
            list.addAll(Arrays.asList(decorator.getActions((Node)this)));
        }
        return list.toArray(new Action[list.size()]);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("key") || evt.getPropertyName().equals("expression") || evt.getPropertyName().equals("expression")) {
            this.fireNameChange(null, this.getName());
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
        if (evt.getPropertyName().equals("parentStyle")) {
            this.firePropertyChange("parentStyleNameReference", evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("expression")) {
            this.firePropertyChange("valueClassName", evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("connectionExpression")) {
            this.firePropertyChange("dataSourceExpression", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("PROPERTY_CONNECTION_TYPE", evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("dataSourceExpression")) {
            this.firePropertyChange("connectionExpression", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("PROPERTY_CONNECTION_TYPE", evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("dataRange") || evt.getPropertyName().equals("dataRange")) {
            this.firePropertyChange("highExpression", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("lowExpression", evt.getOldValue(), evt.getNewValue());
        } else if (evt.getPropertyName().equals("lowRange")) {
            this.firePropertyChange("LOW_RANGE_highExpression", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("LOW_RANGE_lowExpression", evt.getOldValue(), evt.getNewValue());
        } else if (evt.getPropertyName().equals("mediumRange")) {
            this.firePropertyChange("MEDIUM_RANGE_highExpression", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("MEDIUM_RANGE_lowExpression", evt.getOldValue(), evt.getNewValue());
        } else if (evt.getPropertyName().equals("highRange")) {
            this.firePropertyChange("HIGH_RANGE_highExpression", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("HIGH_RANGE_lowExpression", evt.getOldValue(), evt.getNewValue());
        } else if (evt.getPropertyName().equals("valueDisplay") || evt.getPropertyName().equals("valueDisplay")) {
            this.firePropertyChange("font", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("mask", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("color", evt.getOldValue(), evt.getNewValue());
        } else if (evt.getPropertyName().equals("lineColor") || evt.getPropertyName().equals("lineStyle") || evt.getPropertyName().equals("lineWidth")) {
            if (ModelUtils.containsProperty(this.getPropertySets(), "pen")) {
                this.firePropertyChange("pen", evt.getOldValue(), evt.getNewValue());
            }
            if (ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
                this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
            }
        } else if (evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding")) {
            if (ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
                this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
            }
        } else if (evt.getPropertyName().equals("datasetRun") && this.element instanceof JRDesignChart) {
            Node.PropertySet[] sets = this.getPropertySets();
            JRDesignChart chart = (JRDesignChart)this.element;
            JRDesignDataset newDataset = this.jd.getMainDesignDataset();
            if (chart.getDataset() != null && chart.getDataset().getDatasetRun() != null && chart.getDataset().getDatasetRun().getDatasetName() != null) {
                String dsname = chart.getDataset().getDatasetRun().getDatasetName();
                if (this.jd.getDatasetMap().containsKey(dsname)) {
                    newDataset = (JRDesignDataset)this.jd.getDatasetMap().get(dsname);
                }
            }
            for (int i = 0; i < sets.length; ++i) {
                if (!sets[i].getName().equals("CHART_PLOT_PROPERTIES")) continue;
                Node.Property[] pp = sets[i].getProperties();
                for (int j = 0; j < pp.length; ++j) {
                    if (pp[j].getValue("EXPRESSION_CONTEXT") == null && !(pp[j] instanceof ExpressionProperty)) continue;
                    pp[j].setValue("EXPRESSION_CONTEXT", (Object)new ExpressionContext(newDataset));
                }
            }
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public boolean hasExpression(JRDesignExpression ex) {
        HasExpressionVisitor hasExpressionVisitor = new HasExpressionVisitor(this.jd, (JRExpression)ex);
        return hasExpressionVisitor.hasExpression((JRVisitable)this.element);
    }

    public ExpressionContext getExpressionContext(JRDesignExpression ex) {
        JRDesignChart chart;
        if (this.element instanceof JRDesignChart && (chart = (JRDesignChart)this.element).getDataset().getDatasetRun() != null && chart.getDataset().getDatasetRun().getDatasetName() != null && chart.getDataset().getDatasetRun().getConnectionExpression() != ex && chart.getDataset().getDatasetRun().getDataSourceExpression() != ex && chart.getDataset().getDatasetRun().getParametersMapExpression() != ex) {
            boolean found = false;
            JRDatasetParameter[] params = chart.getDataset().getDatasetRun().getParameters();
            for (int i = 0; i < params.length; ++i) {
                if (params[i].getExpression() != ex) continue;
                found = true;
                break;
            }
            if (!found) {
                return new ExpressionContext((JRDesignDataset)this.jd.getDatasetMap().get(chart.getDataset().getDatasetRun().getDatasetName()));
            }
        }
        return new ExpressionContext(ModelUtils.getElementDataset(this.element, this.jd));
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        Node[] dropNodes = NodeTransfer.nodes((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction(t);
        if (dropNode == null) {
            ElementPasteType.setLastPastedNodes(dropNodes);
        }
        if (null != dropNode && !(dropNode instanceof NotRealElementNode)) {
            JRDesignElement element = (JRDesignElement)dropNode.getLookup().lookup(JRDesignElement.class);
            if (null != element) {
                return new ElementPasteType(element.getElementGroup(), this.getElement().getElementGroup(), element, dropAction, (Node)this);
            }
            if (dropNode instanceof ElementGroupNode) {
                JRDesignElementGroup g = ((ElementGroupNode)dropNode).getElementGroup();
                return new ElementPasteType(g.getElementGroup(), this.getElement().getElementGroup(), g, dropAction, (Node)this);
            }
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Object getValue(String attributeName) {
        if ("customDelete".equals(attributeName)) {
            return new Boolean(IReportManager.getPreferences().getBoolean("noConfirmElementDelete", true));
        }
        return super.getValue(attributeName);
    }
}

