/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.fonts.IRFontUtils;
import com.jaspersoft.ireport.designer.fonts.InstallFontWizardPanel2FamilyDetails;
import com.jaspersoft.ireport.designer.fonts.InstallFontWizardPanel2TTFSelection;
import com.jaspersoft.ireport.designer.fonts.InstallFontWizardPanel3Locales;
import com.jaspersoft.ireport.designer.fonts.InstallFontWizardPanel4FontMapping;
import com.jaspersoft.ireport.designer.fonts.SimpleFontFamilyEx;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;

public class InstallFontWizardDescriptor
extends WizardDescriptor {
    private WizardDescriptor.Panel[] panels;

    public InstallFontWizardDescriptor() {
        this.setPanelsAndSettings((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(this.getPanels()), (Object)this);
        this.setTitleFormat(new MessageFormat("{0}"));
        this.setTitle("Font Installation");
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new InstallFontWizardPanel2TTFSelection(this), new InstallFontWizardPanel2FamilyDetails(this), new InstallFontWizardPanel3Locales(), new InstallFontWizardPanel4FontMapping()};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public boolean runWizard() {
        boolean cancelled;
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = this.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            String familyName = (String)this.getProperty("family_name");
            String normal_ttf_file = (String)this.getProperty("normal_ttf_file");
            String bold_ttf_file = (String)this.getProperty("bold_ttf_file");
            String italic_ttf_file = (String)this.getProperty("italic_ttf_file");
            String bolditalic_ttf_file = (String)this.getProperty("bolditalic_ttf_file");
            String pdf_encoding = (String)this.getProperty("pdf_encoding");
            String pdf_embedded = (String)this.getProperty("pdf_embedded");
            List locales = (List)this.getProperty("locales");
            Map mappings = (Map)this.getProperty("mappings");
            try {
                File f;
                File fontsDir = Misc.getFontsDirectory();
                if (fontsDir == null) {
                    throw new Exception("I'm unable to find the fonts directory of iReport!!");
                }
                String fname = new File(normal_ttf_file).getName();
                Misc.copyFile(new File(normal_ttf_file), new File(fontsDir, fname));
                SimpleFontFamilyEx font = new SimpleFontFamilyEx();
                font.setName(familyName);
                font.setNormalFont(fname);
                if (bold_ttf_file != null && bold_ttf_file.length() > 0 && (f = new File(bold_ttf_file)).exists()) {
                    fname = f.getName();
                    Misc.copyFile(f, new File(fontsDir, fname));
                    font.setBoldFont(fname);
                }
                if (italic_ttf_file != null && italic_ttf_file.length() > 0 && (f = new File(italic_ttf_file)).exists()) {
                    fname = f.getName();
                    Misc.copyFile(f, new File(fontsDir, fname));
                    font.setItalicFont(fname);
                }
                if (bolditalic_ttf_file != null && bolditalic_ttf_file.length() > 0 && (f = new File(bolditalic_ttf_file)).exists()) {
                    fname = f.getName();
                    Misc.copyFile(f, new File(fontsDir, fname));
                    font.setBoldItalicFont(fname);
                }
                font.setPdfEncoding(pdf_encoding);
                font.setPdfEmbedded(pdf_embedded != null && pdf_embedded.equals("true"));
                if (mappings != null) {
                    font.setExportFonts(mappings);
                }
                if (locales != null) {
                    font.setLocales(new HashSet(locales));
                }
                String bean_xml = IRFontUtils.dumpBean(font);
                bean_xml = bean_xml + "</beans>\n\n";
                File xmlFile = new File(fontsDir, "irfonts.xml");
                StringBuffer buf = new StringBuffer("");
                FileInputStream fis = new FileInputStream(xmlFile);
                byte[] bufBytes = new byte[1024];
                int count = 0;
                while ((count = fis.read(bufBytes)) > 0) {
                    buf.append(new String(bufBytes, 0, count));
                }
                fis.close();
                String xmlContent = buf.toString();
                xmlContent = Misc.string_replace(bean_xml, "</beans>", xmlContent);
                FileWriter fos = new FileWriter(xmlFile);
                fos.write(xmlContent);
                fos.flush();
                fos.close();
                return true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainFrame(), ex.getMessage(), "Error", 0);
            }
        }
        return cancelled;
    }

    public static void browseForTTFFile(JTextField destinationTextField) {
        String fontsDir = IReportManager.getPreferences().get("fontsdir", null);
        if (fontsDir == null) {
            fontsDir = IReportManager.getInstance().getCurrentDirectory();
        }
        JFileChooser jfc = new JFileChooser(fontsDir);
        jfc.setDialogTitle("Select a TrueType Font");
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".ttf") || file.isDirectory();
            }

            public String getDescription() {
                return "TrueType Font *.ttf";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(SwingUtilities.getAncestorOfClass(Window.class, destinationTextField)) == 0) {
            File file = jfc.getSelectedFile();
            try {
                destinationTextField.setText(file.getAbsolutePath());
                IReportManager.getPreferences().put("fontsdir", file.getParent());
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }
}

