/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * JROptionsPanel.java
 *
 * Created on 20-mar-2009, 17.55.55
 */

package com.jaspersoft.ireport.designer.options.jasperreports;

import com.jaspersoft.ireport.designer.options.IReportOptionsPanelController;
import com.jaspersoft.ireport.designer.options.OptionsPanel;
import java.awt.BorderLayout;
import java.beans.PropertyVetoException;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

/**
 *
 * @author gtoffoli
 */
public class JROptionsPanel extends javax.swing.JPanel implements OptionsPanel, ExplorerManager.Provider {

    private ExplorerManager explorerManager = null;
    private JRPropertiesNode propertiesNode = null;
    private PropertySheetView propertySheet = null;

    IReportOptionsPanelController controller = null;
    /** Creates new form ExportOptionsPanel */
    public JROptionsPanel(IReportOptionsPanelController controller) {
        initComponents();
        this.controller = controller;

        explorerManager = new ExplorerManager();
        propertiesNode = new JRPropertiesNode();
        explorerManager.setRootContext(propertiesNode);
        
        propertySheet = new PropertySheetView();

        this.add(propertySheet, BorderLayout.CENTER);
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents

    public void load() {

        propertiesNode = new JRPropertiesNode();
        explorerManager.setRootContext(propertiesNode);
        try {
            getExplorerManager().setSelectedNodes(new Node[]{propertiesNode});
        } catch (PropertyVetoException ex) {
            ex.printStackTrace();
            //Exceptions.printStackTrace(ex);
        }
    }

    public void store() {

    }

    public boolean valid() {
        return true;
    }

    /**
     * @return the explorerManager
     */
    public ExplorerManager getExplorerManager() {
        return explorerManager;
    }

    /**
     * @param explorerManager the explorerManager to set
     */
    public void setExplorerManager(ExplorerManager explorerManager) {
        this.explorerManager = explorerManager;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
