/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderTree;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.utils.S;

public class MdBuilderTreeDropListener
implements DropTargetListener {
    MdxBuilderTree mdxBuilderTree;

    public MdBuilderTreeDropListener(MdxBuilderTree _mdxBuilderTree) {
        this.mdxBuilderTree = _mdxBuilderTree;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.acceptDrop(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.acceptDrop(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
    }

    private boolean acceptDrop(DropTargetDragEvent dtde) {
        try {
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            for (int i = 0; flavors != null && i < flavors.length; ++i) {
                if (!this.mdxBuilderTree.acceptDropOnPoint(dtde.getLocation(), flavors[i])) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!(tr.getTransferData(flavors[i]) instanceof DimensionTreeElement) && !(tr.getTransferData(flavors[i]) instanceof MBTNode) && !(tr.getTransferData(flavors[i]) instanceof MdxFunction)) continue;
                dtde.acceptDrop(1);
                this.mdxBuilderTree.handleDropOnPoint(dtde.getLocation(), tr.getTransferData(flavors[i]));
                dtde.dropComplete(true);
                return;
            }
            S.out("Drop failed: " + dtde);
            dtde.rejectDrop();
            dtde.dropComplete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
            dtde.dropComplete(true);
        }
    }
}

