/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors.box;

import com.jaspersoft.ireport.designer.tools.HexColorChooserPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;

public class ColorSelectorPanel2
extends JPanel {
    private Color color = Color.BLACK;
    private String value = "#000000";
    private ImageIcon noColorIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/nocolor.png"));
    private boolean init = false;
    private JButton jButtonSelect;
    private JLabel lblNoColor;
    private JPanel pnlColor;
    private JTextField txtBorderSupplier;
    private JTextField txtColor;

    public ColorSelectorPanel2() {
        this.initComponents();
        this.applyI18n();
        this.setColor(null);
        this.txtBorderSupplier.setVisible(false);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        if (newValue == null) {
            this.setColor(null);
            return;
        }
        Color newColor = null;
        newColor = newValue instanceof Color ? (Color)newValue : ColorSelectorPanel2.parseColorString("" + newValue);
        if (newColor == null) {
            return;
        }
        this.setColor(newColor);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.lblNoColor.setIcon(color == null ? this.noColorIcon : null);
        if (color == null) {
            this.value = null;
            this.txtColor.setText("");
            this.pnlColor.setBackground(Color.WHITE);
            this.pnlColor.setBorder(new LineBorder(Color.LIGHT_GRAY));
            this.pnlColor.invalidate();
            this.pnlColor.updateUI();
        } else {
            this.pnlColor.setBorder(new LineBorder(Color.BLACK));
            this.value = HexColorChooserPanel.getEncodedColor(color);
            this.pnlColor.setBackground(color);
            this.pnlColor.invalidate();
            this.pnlColor.updateUI();
            this.txtColor.setText(HexColorChooserPanel.getEncodedColor(color));
        }
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, ""));
    }

    public static Color parseColorString(String newValue) {
        if (newValue == null) {
            return null;
        }
        if (!(newValue = newValue.trim()).startsWith("[") || !newValue.endsWith("]")) {
            Color c = Color.getColor(newValue);
            if (c != null) {
                return c;
            }
            if (c == null && newValue.matches("(#?)(([0-9]|[a-f]|[A-F]){0,6})")) {
                if (newValue.startsWith("#")) {
                    newValue = newValue.substring(1);
                }
                if (newValue.length() >= 6) {
                    try {
                        int hr = Integer.parseInt(newValue.substring(0, 2), 16);
                        int hg = Integer.parseInt(newValue.substring(2, 4), 16);
                        int hb = Integer.parseInt(newValue.substring(4, 6), 16);
                        c = new Color(hr, hg, hb);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            return c;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        String rgbValues = newValue.substring(1, newValue.length() - 1);
        try {
            StringTokenizer st = new StringTokenizer(rgbValues, ",", false);
            r = Integer.parseInt(st.nextToken());
            g = Integer.parseInt(st.nextToken());
            b = Integer.parseInt(st.nextToken());
        }
        catch (Exception ex) {
            return null;
        }
        Color c = new Color(r, g, b);
        return c;
    }

    private void initComponents() {
        this.pnlColor = new JPanel();
        this.lblNoColor = new JLabel();
        this.txtBorderSupplier = new JTextField();
        this.txtColor = new JTextField();
        this.jButtonSelect = new JButton();
        this.setBackground(SystemColor.text);
        this.setBorder(this.txtBorderSupplier.getBorder());
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        this.setMinimumSize(new Dimension(120, 22));
        this.setPreferredSize(new Dimension(120, 22));
        this.setLayout(new GridBagLayout());
        this.pnlColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pnlColor.setMaximumSize(new Dimension(11, 11));
        this.pnlColor.setMinimumSize(new Dimension(11, 11));
        this.pnlColor.setPreferredSize(new Dimension(11, 11));
        this.pnlColor.setLayout(new BorderLayout());
        this.pnlColor.add((Component)this.lblNoColor, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlColor, gridBagConstraints);
        this.txtBorderSupplier.setEditable(false);
        this.txtBorderSupplier.setEnabled(false);
        this.txtBorderSupplier.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.txtBorderSupplier, gridBagConstraints);
        this.txtColor.setText("[0,0,0]");
        this.txtColor.setBorder(null);
        this.txtColor.setMinimumSize(new Dimension(20, 20));
        this.txtColor.setPreferredSize(new Dimension(20, 20));
        this.txtColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorSelectorPanel2.this.txtColorActionPerformed(evt);
            }
        });
        this.txtColor.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ColorSelectorPanel2.this.txtColorFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.txtColor, gridBagConstraints);
        this.jButtonSelect.setText("...");
        this.jButtonSelect.setFocusable(false);
        this.jButtonSelect.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonSelect.setMaximumSize(new Dimension(18, 18));
        this.jButtonSelect.setMinimumSize(new Dimension(18, 18));
        this.jButtonSelect.setPreferredSize(new Dimension(18, 18));
        this.jButtonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorSelectorPanel2.this.jButtonSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonSelect, gridBagConstraints);
    }

    private void txtColorFocusLost(FocusEvent evt) {
        this.txtColorActionPerformed(null);
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        Color c = HexColorChooserPanel.showDialog(this, I18n.getString("ColorSelectorPanel.Dialog.PickColor"), this.getColor());
        if (c != null) {
            this.setColor(c);
        }
        this.txtColor.requestFocus();
    }

    private void txtColorActionPerformed(ActionEvent evt) {
        Color newColor = ColorSelectorPanel2.parseColorString(this.txtColor.getText());
        if (newColor == null) {
            this.txtColor.setText(this.getValue());
        }
        if (newColor != null) {
            this.setColor(newColor);
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void applyI18n() {
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

