/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.export.AbstractExportParametersPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.util.JRProperties;
import org.jdesktop.layout.GroupLayout;

public class CommonExportParametersPanel
extends AbstractExportParametersPanel {
    private ButtonGroup buttonGroup1;
    private JCheckBox jCheckBoxIgnorePageMargins;
    private JLabel jLabelCharacterEncoding;
    private JLabel jLabelError;
    private JLabel jLabelOffsetX;
    private JLabel jLabelOffsetY;
    private JLabel jLabelPageRangeTo;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonExportAll;
    private JRadioButton jRadioButtonExportPageIndex;
    private JRadioButton jRadioButtonExportRange;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerOffsetX;
    private JSpinner jSpinnerOffsetY;
    private JTextField jTextFieldCharacterEncoding;
    private JTextField jTextFieldPageIndex;
    private JTextField jTextFieldPageRangeFrom;
    private JTextField jTextFieldPageRangeTo;

    public CommonExportParametersPanel() {
        this.initComponents();
        SpinnerNumberModel snmX = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        SpinnerNumberModel snmY = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerOffsetX.setModel(snmX);
        this.jSpinnerOffsetY.setModel(snmY);
        snmX.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CommonExportParametersPanel.this.notifyChange();
            }
        });
        snmY.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CommonExportParametersPanel.this.notifyChange();
            }
        });
        DocumentListener textfieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                CommonExportParametersPanel.this.notifyChange();
            }

            public void insertUpdate(DocumentEvent evt) {
                CommonExportParametersPanel.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent evt) {
                CommonExportParametersPanel.this.notifyChange();
            }
        };
        this.jTextFieldCharacterEncoding.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldPageIndex.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldPageRangeFrom.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldPageRangeTo.getDocument().addDocumentListener(textfieldListener);
        this.applyI18n();
    }

    public void applyI18n() {
        this.jRadioButtonExportAll.setText(I18n.getString("CommonExportParametersPanel.jRadioButtonExportAll.text"));
        this.jRadioButtonExportPageIndex.setText(I18n.getString("CommonExportParametersPanel.jRadioButtonExportPageIndex.text"));
        this.jRadioButtonExportRange.setText(I18n.getString("CommonExportParametersPanel.jRadioButtonExportRange.text"));
        this.jLabelPageRangeTo.setText(I18n.getString("CommonExportParametersPanel.jLabelPageRangeTo.text"));
        this.jLabelCharacterEncoding.setText(I18n.getString("CommonExportParametersPanel.jLabelCharacterEncoding.text"));
        this.jLabelOffsetX.setText(I18n.getString("CommonExportParametersPanel.jLabelOffsetX.text"));
        this.jLabelOffsetY.setText(I18n.getString("CommonExportParametersPanel.jLabelOffsetY.text"));
        this.jCheckBoxIgnorePageMargins.setText(I18n.getString("CommonExportParametersPanel.jCheckBoxIgnorePageMargins.text"));
        this.jLabelTitle.setText(I18n.getString("CommonExportParametersPanel.jLabelTitle.text"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(I18n.getString("CommonExportParametersPanel.jPanel1.border.title")));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonExportAll = new JRadioButton();
        this.jRadioButtonExportPageIndex = new JRadioButton();
        this.jRadioButtonExportRange = new JRadioButton();
        this.jTextFieldPageIndex = new JTextField();
        this.jTextFieldPageRangeFrom = new JTextField();
        this.jLabelPageRangeTo = new JLabel();
        this.jTextFieldPageRangeTo = new JTextField();
        this.jLabelError = new JLabel();
        this.jLabelCharacterEncoding = new JLabel();
        this.jTextFieldCharacterEncoding = new JTextField();
        this.jLabelOffsetX = new JLabel();
        this.jSpinnerOffsetX = new JSpinner();
        this.jLabelOffsetY = new JLabel();
        this.jSpinnerOffsetY = new JSpinner();
        this.jCheckBoxIgnorePageMargins = new JCheckBox();
        this.jLabelTitle.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitle.setText("Common Export parameters");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Pages to export"));
        this.buttonGroup1.add(this.jRadioButtonExportAll);
        this.jRadioButtonExportAll.setSelected(true);
        this.jRadioButtonExportAll.setText("Export all pages");
        this.jRadioButtonExportAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommonExportParametersPanel.this.jRadioButtonExportAllActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonExportPageIndex);
        this.jRadioButtonExportPageIndex.setText("Export page:");
        this.jRadioButtonExportPageIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommonExportParametersPanel.this.jRadioButtonExportPageIndexActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonExportRange);
        this.jRadioButtonExportRange.setText("Export pages from:");
        this.jRadioButtonExportRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommonExportParametersPanel.this.jRadioButtonExportRangeActionPerformed(evt);
            }
        });
        this.jLabelPageRangeTo.setText("to");
        this.jLabelError.setForeground(new Color(204, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonExportAll).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonExportPageIndex).addPreferredGap(0).add((Component)this.jTextFieldPageIndex, -2, 33, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonExportRange).addPreferredGap(0).add((Component)this.jTextFieldPageRangeFrom, -2, 34, -2).add(10, 10, 10).add((Component)this.jLabelPageRangeTo).addPreferredGap(0).add((Component)this.jTextFieldPageRangeTo, -2, 34, -2))).addContainerGap(325, Short.MAX_VALUE)).add((Component)this.jLabelError, -1, 538, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonExportAll).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonExportPageIndex).add((Component)this.jTextFieldPageIndex, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonExportRange).add((Component)this.jTextFieldPageRangeFrom, -2, -1, -2).add((Component)this.jLabelPageRangeTo).add((Component)this.jTextFieldPageRangeTo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelError).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabelCharacterEncoding.setText("Character encoding");
        this.jLabelOffsetX.setText("Offset X");
        this.jLabelOffsetY.setText("Offset Y");
        this.jCheckBoxIgnorePageMargins.setText("Ignore page margins");
        this.jCheckBoxIgnorePageMargins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommonExportParametersPanel.this.jCheckBoxIgnorePageMarginsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap(392, Short.MAX_VALUE)).add(2, (Component)this.jSeparator1, -1, 564, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelCharacterEncoding).addPreferredGap(0).add((Component)this.jTextFieldCharacterEncoding, -2, 141, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelOffsetX).add((Component)this.jLabelOffsetY, -2, 44, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jSpinnerOffsetY).add((Component)this.jSpinnerOffsetX, -1, 64, Short.MAX_VALUE)))).add(315, 315, 315)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxIgnorePageMargins).addContainerGap(433, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, 120, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCharacterEncoding).add((Component)this.jTextFieldCharacterEncoding, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelOffsetX).add((Component)this.jSpinnerOffsetX, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelOffsetY).add((Component)this.jSpinnerOffsetY, -2, 20, -2)).addPreferredGap(0).add((Component)this.jCheckBoxIgnorePageMargins).add(42, 42, 42)));
    }

    private void jRadioButtonExportAllActionPerformed(ActionEvent evt) {
        this.updateRange();
    }

    private void jRadioButtonExportPageIndexActionPerformed(ActionEvent evt) {
        this.updateRange();
    }

    private void jRadioButtonExportRangeActionPerformed(ActionEvent evt) {
        this.updateRange();
    }

    private void jCheckBoxIgnorePageMarginsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    public void updateRange() {
        this.jTextFieldPageIndex.setEnabled(this.jRadioButtonExportPageIndex.isSelected());
        this.jTextFieldPageRangeFrom.setEnabled(this.jRadioButtonExportRange.isSelected());
        this.jTextFieldPageRangeTo.setEnabled(this.jRadioButtonExportRange.isSelected());
        this.notifyChange();
    }

    public void load() {
        String encoding;
        Preferences pref = IReportManager.getPreferences();
        this.jCheckBoxIgnorePageMargins.setSelected(pref.getBoolean("net.sf.jasperreports.export.ignore.page.margins", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.ignore.page.margins")));
        int pageMode = pref.getInt("net.sf.jasperreports.export.printrange", 0);
        this.jRadioButtonExportAll.setSelected(pageMode == 0);
        this.jRadioButtonExportPageIndex.setSelected(pageMode == 1);
        this.jTextFieldPageIndex.setEnabled(pageMode == 1);
        if (pageMode == 1) {
            this.jTextFieldPageIndex.setText(pref.getInt("net.sf.jasperreports.export.printrange.index", 1) + "");
        }
        this.jRadioButtonExportRange.setSelected(pageMode == 2);
        this.jTextFieldPageRangeFrom.setEnabled(pageMode == 2);
        this.jTextFieldPageRangeTo.setEnabled(pageMode == 2);
        if (pageMode == 2) {
            this.jTextFieldPageRangeFrom.setText(pref.getInt("net.sf.jasperreports.export.printrange.from", 1) + "");
            this.jTextFieldPageRangeTo.setText(pref.getInt("net.sf.jasperreports.export.printrange.to", 1) + "");
        }
        this.jTextFieldCharacterEncoding.setText((encoding = pref.get("net.sf.jasperreports.export.character.encoding", JRProperties.getProperty((String)"net.sf.jasperreports.export.character.encoding"))) == null ? "" : encoding);
        SpinnerNumberModel m = (SpinnerNumberModel)this.jSpinnerOffsetX.getModel();
        m.setValue(pref.getInt("net.sf.jasperreports.export.offset.x", 0));
        m = (SpinnerNumberModel)this.jSpinnerOffsetY.getModel();
        m.setValue(pref.getInt("net.sf.jasperreports.export.offset.y", 0));
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        if (this.jRadioButtonExportAll.isSelected()) {
            pref.putInt("net.sf.jasperreports.export.printrange", 0);
        } else if (this.jRadioButtonExportPageIndex.isSelected()) {
            pref.putInt("net.sf.jasperreports.export.printrange", 1);
            pref.putInt("net.sf.jasperreports.export.printrange.index", Integer.valueOf(this.jTextFieldPageIndex.getText()));
        } else if (this.jRadioButtonExportRange.isSelected()) {
            pref.putInt("net.sf.jasperreports.export.printrange", 2);
            pref.putInt("net.sf.jasperreports.export.printrange.from", Integer.valueOf(this.jTextFieldPageRangeFrom.getText()));
            pref.putInt("net.sf.jasperreports.export.printrange.to", Integer.valueOf(this.jTextFieldPageRangeTo.getText()));
        }
        if (this.jTextFieldCharacterEncoding.getText().trim().length() == 0) {
            pref.remove("net.sf.jasperreports.export.character.encoding");
        } else {
            pref.put("net.sf.jasperreports.export.character.encoding", this.jTextFieldCharacterEncoding.getText().trim());
        }
        SpinnerNumberModel m = (SpinnerNumberModel)this.jSpinnerOffsetX.getModel();
        if (m.getNumber().intValue() == 0) {
            pref.remove("net.sf.jasperreports.export.offset.x");
        } else {
            pref.putInt("net.sf.jasperreports.export.offset.x", m.getNumber().intValue());
        }
        m = (SpinnerNumberModel)this.jSpinnerOffsetY.getModel();
        if (m.getNumber().intValue() == 0) {
            pref.remove("net.sf.jasperreports.export.offset.y");
        } else {
            pref.putInt("net.sf.jasperreports.export.offset.y", m.getNumber().intValue());
        }
        pref.putBoolean("net.sf.jasperreports.export.ignore.page.margins", this.jCheckBoxIgnorePageMargins.isSelected());
    }

    public boolean valid() {
        this.jLabelError.setText(" ");
        if (this.jRadioButtonExportPageIndex.isSelected()) {
            try {
                Integer.valueOf(this.jTextFieldPageIndex.getText().trim());
            }
            catch (Exception ex) {
                this.jLabelError.setText(I18n.getString("CommonExportParametersPanel.errorInvalidPageIndex"));
                return false;
            }
        }
        if (this.jRadioButtonExportRange.isSelected()) {
            try {
                int a = Integer.valueOf(this.jTextFieldPageRangeFrom.getText().trim());
                int b = Integer.valueOf(this.jTextFieldPageRangeTo.getText().trim());
                if (b < a) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                this.jLabelError.setText(I18n.getString("CommonExportParametersPanel.errorInvalidRange"));
                return false;
            }
        }
        return true;
    }

    public String getDisplayName() {
        return I18n.getString("CommonExportParametersPanel.title");
    }
}

