/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.Assert;
import mondrian.olap.Util;
import mondrian.test.FoodMartTestCase;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaUtil;

public class XmlaTests
extends FoodMartTestCase {
    public XmlaTests() {
    }

    public XmlaTests(String name) {
        super(name);
    }

    public void testXmlaUtilNormalizeNumericString() throws Exception {
        String vin = "1.0E10";
        String expected = "1.0E10";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "1.0E1";
        expected = "1.0E1";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "1.0E11";
        expected = "1.0E11";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "1.40";
        expected = "1.4";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "1.400";
        expected = "1.4";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "1.4040";
        expected = "1.404";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "1.0";
        expected = "1";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "1";
        expected = "1";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
        vin = "10";
        expected = "10";
        this.doXmlaUtilNormalizeNumericString(vin, expected);
    }

    public void testXmlaHandlerGetValueTypeHint() throws Exception {
        String dataType = "Integer";
        this.doXmlaHandlerGetValueTypeHint(dataType, "xsd:int");
        dataType = "Numeric";
        this.doXmlaHandlerGetValueTypeHint(dataType, "xsd:double");
        dataType = "FOO";
        this.doXmlaHandlerGetValueTypeHint(dataType, "xsd:string");
        dataType = null;
        this.doXmlaHandlerGetValueTypeHint(dataType, null);
    }

    public void testXmlaHandlerValueInfo() throws Exception {
        String dataType = "Integer";
        Number inputValue = new Integer(4);
        String valueType = "xsd:int";
        Number value = inputValue;
        boolean isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new Long(0x80000000L);
        valueType = "xsd:long";
        value = inputValue;
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new Long(-2147483649L);
        valueType = "xsd:long";
        value = inputValue;
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new BigInteger("9223372036854775807");
        valueType = "xsd:long";
        value = new Long(Long.MAX_VALUE);
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new BigInteger("-9223372036854775808");
        valueType = "xsd:long";
        value = new Long(Long.MIN_VALUE);
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new BigInteger("9223372036854775808");
        valueType = "xsd:integer";
        value = inputValue;
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new BigInteger("-9223372036854775809");
        valueType = "xsd:integer";
        value = inputValue;
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new BigDecimal("9223372036854775807.0");
        valueType = "xsd:long";
        value = new Long(Long.MAX_VALUE);
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        valueType = "xsd:decimal";
        value = inputValue;
        isDecimal = true;
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Integer";
        inputValue = new BigDecimal("-9223372036854775808.0");
        valueType = "xsd:long";
        value = new Long(Long.MIN_VALUE);
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        valueType = Util.Retrowoven ? "xsd:double" : "xsd:decimal";
        value = Util.Retrowoven ? (Number)Double.valueOf("-9.223372036854776E18") : (Number)inputValue;
        isDecimal = true;
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Numeric";
        inputValue = new Double(4.0);
        valueType = "xsd:double";
        value = inputValue;
        isDecimal = true;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        this.doXmlaHandlerValueInfo(null, inputValue, valueType, value, isDecimal);
        dataType = "Numeric";
        inputValue = new Integer(4);
        valueType = "xsd:double";
        value = new Double(4.0);
        isDecimal = true;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        dataType = "Numeric";
        inputValue = new Long(4L);
        valueType = "xsd:double";
        value = new Double(4.0);
        isDecimal = true;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        if (!Util.Retrowoven) {
            dataType = "Numeric";
            inputValue = new BigDecimal("1.797693134862315e+308");
            valueType = "xsd:double";
            value = Double.valueOf("1.797693134862315e+308");
            isDecimal = true;
            this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        }
        dataType = "Numeric";
        inputValue = new BigDecimal("1.9e+500");
        valueType = "xsd:decimal";
        value = inputValue;
        isDecimal = true;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
        dataType = "Numeric";
        inputValue = new BigInteger("4");
        valueType = "xsd:int";
        value = new Integer(4);
        isDecimal = false;
        this.doXmlaHandlerValueInfo(dataType, inputValue, valueType, value, isDecimal);
    }

    protected void doXmlaUtilNormalizeNumericString(String vin, String expected) throws Exception {
        String actual = XmlaUtil.normalizeNumericString(vin);
        Assert.assertEquals((String)expected, (String)actual);
    }

    protected void doXmlaHandlerGetValueTypeHint(String dataType, String expected) throws Exception {
        String actual = XmlaHandler.ValueInfo.getValueTypeHint(dataType);
        Assert.assertEquals((String)expected, (String)actual);
    }

    protected void doXmlaHandlerValueInfo(String dataType, Object inputValue, String valueType, Object value, boolean isDecimal) throws Exception {
        XmlaHandler.ValueInfo vi = new XmlaHandler.ValueInfo(dataType, inputValue);
        Assert.assertEquals((String)"valueType:", (String)valueType, (String)vi.valueType);
        Assert.assertEquals((String)"value:", (Object)value, (Object)vi.value);
        Assert.assertEquals((String)"isDecimal:", (boolean)isDecimal, (boolean)vi.isDecimal);
    }
}

