/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.test.DiffRepository;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import mondrian.tui.XmlUtil;
import mondrian.tui.XmlaSupport;
import mondrian.xmla.XmlaBasicTest;
import mondrian.xmla.XmlaRequestCallback;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlaBaseTestCase
extends FoodMartTestCase {
    protected static final String LAST_SCHEMA_UPDATE_DATE_PROP = "last.schema.update.date";
    protected static final String LAST_SCHEMA_UPDATE_DATE = "somedate";
    private static final String LAST_SCHEMA_UPDATE_NODE_NAME = "LAST_SCHEMA_UPDATE";
    protected SortedMap<String, String> catalogNameUrls = null;
    private Servlet servlet;
    private static int sessionIdCounter = 1000;
    private static Map<String, String> sessionIdMap = new HashMap<String, String>();
    public static final String SESSION_ID_PROP = "session.id";
    public static final String REQUEST_TYPE_PROP = "request.type";
    public static final String DATA_SOURCE_INFO_PROP = "data.source.info";
    public static final String DATA_SOURCE_INFO = "MondrianFoodMart";
    public static final String CATALOG_PROP = "catalog";
    public static final String CATALOG_NAME_PROP = "catalog.name";
    public static final String CATALOG = "FoodMart";
    public static final String CUBE_NAME_PROP = "cube.name";
    public static final String SALES_CUBE = "Sales";
    public static final String HR_CUBE = "HR";
    public static final String FORMAT_PROP = "format";
    public static final String FORMAT_MULTI_DIMENSIONAL = "Multidimensional";
    private static final boolean DEBUG = false;
    private static final ThreadLocal<Role> roles = new ThreadLocal();

    public XmlaBaseTestCase() {
    }

    public XmlaBaseTestCase(String name) {
        super(name);
    }

    protected abstract DiffRepository getDiffRepos();

    protected String fileToString(String filename) throws Exception {
        String var = "${" + filename + "}";
        String s = this.getDiffRepos().expand(null, var);
        if (s.startsWith("$")) {
            this.getDiffRepos().amend(var, "\n\n");
        }
        return s;
    }

    protected Document replaceLastSchemaUpdateDate(Document doc) {
        NodeList elements = doc.getElementsByTagName(LAST_SCHEMA_UPDATE_NODE_NAME);
        if (elements.getLength() == 0) {
            return doc;
        }
        Node lastSchemaUpdateNode = elements.item(0);
        lastSchemaUpdateNode.getFirstChild().setNodeValue(LAST_SCHEMA_UPDATE_DATE);
        return doc;
    }

    protected Map<String, String> getCatalogNameUrls(TestContext testContext) {
        if (this.catalogNameUrls == null) {
            this.catalogNameUrls = new TreeMap<String, String>();
            String connectString = testContext.getConnectString();
            Util.PropertyList connectProperties = Util.parseConnectString(connectString);
            String catalog = connectProperties.get(RolapConnectionProperties.Catalog.name());
            this.catalogNameUrls.put(CATALOG, catalog);
        }
        return this.catalogNameUrls;
    }

    protected Servlet getServlet(TestContext testContext) throws IOException, ServletException, SAXException {
        if (this.servlet == null) {
            this.getSessionId(Action.CLEAR);
            String connectString = testContext.getConnectString();
            Map<String, String> catalogNameUrls = this.getCatalogNameUrls(testContext);
            this.servlet = XmlaSupport.makeServlet(connectString, catalogNameUrls, this.getServletCallbackClass().getName());
        }
        return this.servlet;
    }

    protected void clearServlet() {
        this.servlet = null;
    }

    protected abstract Class<? extends XmlaRequestCallback> getServletCallbackClass();

    protected Properties getDefaultRequestProperties(String requestType) {
        Properties props = new Properties();
        props.setProperty(REQUEST_TYPE_PROP, requestType);
        props.setProperty(CATALOG_PROP, CATALOG);
        props.setProperty(CATALOG_NAME_PROP, CATALOG);
        props.setProperty(CUBE_NAME_PROP, SALES_CUBE);
        props.setProperty(FORMAT_PROP, FORMAT_MULTI_DIMENSIONAL);
        props.setProperty(DATA_SOURCE_INFO_PROP, DATA_SOURCE_INFO);
        return props;
    }

    protected Document fileToDocument(String filename) throws IOException, SAXException {
        String s = this.getDiffRepos().expand(null, filename);
        if (s.equals(filename)) {
            s = "<?xml version='1.0'?><Empty/>";
        }
        s = this.filter(this.getDiffRepos().getCurrentTestCaseName(true), filename, s);
        return XmlUtil.parse(new ByteArrayInputStream(s.getBytes()));
    }

    protected String filter(String testCaseName, String filename, String content) {
        Util.discard((Object)testCaseName);
        Util.discard((Object)filename);
        return content;
    }

    public void doTest(String requestType, Properties props, TestContext testContext) throws Exception {
        this.doTest(requestType, props, testContext, null);
    }

    public void doTest(String requestType, Properties props, TestContext testContext, Role role) throws Exception {
        String requestText = this.fileToString("request");
        requestText = testContext.upgradeQuery(requestText);
        this.doTestInline(requestType, requestText, "${response}", props, testContext, role);
    }

    public void doTestInline(String requestType, String requestText, String respFileName, Properties props, TestContext testContext) throws Exception {
        this.doTestInline(requestType, requestText, respFileName, props, testContext, null);
    }

    public void doTestInline(String requestType, String requestText, String respFileName, Properties props, TestContext testContext, Role role) throws Exception {
        Document responseDoc = respFileName != null ? this.fileToDocument(respFileName) : null;
        String connectString = testContext.getConnectString();
        Map<String, String> catalogNameUrls = this.getCatalogNameUrls(testContext);
        String ns = "cxmla";
        Document expectedDoc = responseDoc != null ? XmlaSupport.transformSoapXmla(responseDoc, new String[][]{{"content", "schemadata"}}, "cxmla") : null;
        this.doTests(requestText, props, testContext, null, connectString, catalogNameUrls, expectedDoc, XmlaBasicTest.CONTENT_SCHEMADATA, role);
        if (requestType.equals("EXECUTE")) {
            return;
        }
        expectedDoc = responseDoc != null ? XmlaSupport.transformSoapXmla(responseDoc, new String[][]{{"content", "none"}}, "cxmla") : null;
        this.doTests(requestText, props, testContext, null, connectString, catalogNameUrls, expectedDoc, XmlaBasicTest.CONTENT_NONE, role);
        expectedDoc = responseDoc != null ? XmlaSupport.transformSoapXmla(responseDoc, new String[][]{{"content", "data"}}, "cxmla") : null;
        this.doTests(requestText, props, testContext, null, connectString, catalogNameUrls, expectedDoc, XmlaBasicTest.CONTENT_DATA, role);
        expectedDoc = responseDoc != null ? XmlaSupport.transformSoapXmla(responseDoc, new String[][]{{"content", "schema"}}, "cxmla") : null;
        this.doTests(requestText, props, testContext, null, connectString, catalogNameUrls, expectedDoc, XmlaBasicTest.CONTENT_SCHEMA, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTests(String soapRequestText, Properties props, TestContext testContext, String soapResponseText, String connectString, Map<String, String> catalogNameUrls, Document expectedDoc, String content, Role role) throws Exception {
        if (content != null) {
            props.setProperty("content", content);
        }
        soapRequestText = Util.replaceProperties(soapRequestText, Util.toMap(props));
        Document soapReqDoc = XmlUtil.parseString(soapRequestText);
        Document xmlaReqDoc = XmlaSupport.extractBodyFromSoap(soapReqDoc);
        byte[] bytes = XmlaSupport.processXmla(xmlaReqDoc, connectString, catalogNameUrls, role);
        String response = new String(bytes);
        if (!XmlUtil.supportsValidation() || XmlaSupport.validateXmlaUsingXpath(bytes)) {
            // empty if block
        }
        try {
            String callBackClassName = CallBack.class.getName();
            if (role != null) {
                roles.set(role);
            }
            bytes = XmlaSupport.processSoapXmla(soapReqDoc, connectString, catalogNameUrls, callBackClassName);
        }
        finally {
            if (role != null) {
                roles.set(null);
            }
        }
        response = new String(bytes);
        if (!XmlUtil.supportsValidation() || XmlaSupport.validateSoapXmlaUsingXpath(bytes)) {
            // empty if block
        }
        Document gotDoc = this.ignoreLastUpdateDate(XmlUtil.parse(bytes));
        String gotStr = XmlUtil.toString(gotDoc, true);
        gotStr = Util.maskVersion(gotStr);
        gotStr = testContext.upgradeActual(gotStr);
        if (expectedDoc != null) {
            String expectedStr = XmlUtil.toString(expectedDoc, true);
            try {
                XMLAssert.assertXMLEqual((String)expectedStr, (String)gotStr);
            }
            catch (AssertionFailedError e) {
                if (content.equals(XmlaBasicTest.CONTENT_SCHEMADATA)) {
                    this.getDiffRepos().assertEquals("response", "${response}", gotStr);
                }
                throw e;
            }
        } else if (content.equals(XmlaBasicTest.CONTENT_SCHEMADATA)) {
            this.getDiffRepos().amend("${response}", gotStr);
        }
    }

    private Document ignoreLastUpdateDate(Document document) {
        NodeList elements = document.getElementsByTagName(LAST_SCHEMA_UPDATE_NODE_NAME);
        for (int i = elements.getLength(); i > 0; --i) {
            this.removeNode(elements.item(i - 1));
        }
        return document;
    }

    private void removeNode(Node node) {
        Node parentNode = node.getParentNode();
        parentNode.removeChild(node);
    }

    protected abstract String getSessionId(Action var1);

    protected static String getSessionId(String name, Action action) {
        switch (action) {
            case CLEAR: {
                sessionIdMap.put(name, null);
                return null;
            }
            case QUERY: {
                return sessionIdMap.get(name);
            }
            case CREATE: {
                String sessionId = sessionIdMap.get(name);
                if (sessionId == null) {
                    int id = sessionIdCounter++;
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append("-");
                    buf.append(id);
                    buf.append("-foo");
                    sessionId = buf.toString();
                    sessionIdMap.put(name, sessionId);
                }
                return sessionId;
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        CREATE,
        QUERY,
        CLEAR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CallBack
    implements XmlaRequestCallback {
        @Override
        public void init(ServletConfig servletConfig) throws ServletException {
        }

        @Override
        public boolean processHttpHeader(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws Exception {
            Role role = (Role)roles.get();
            if (role != null) {
                context.put("role", role);
            }
            return true;
        }

        @Override
        public void preAction(HttpServletRequest request, Element[] requestSoapParts, Map<String, Object> context) throws Exception {
        }

        @Override
        public String generateSessionId(Map<String, Object> context) {
            return null;
        }

        @Override
        public void postAction(HttpServletRequest request, HttpServletResponse response, byte[][] responseSoapParts, Map<String, Object> context) throws Exception {
        }
    }
}

