/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.comp;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.Test;
import junit.framework.TestSuite;
import mondrian.olap.Connection;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.test.FoodMartTestCase;
import mondrian.test.comp.ResultComparator;
import mondrian.test.comp.XMLUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResultComparatorTest
extends FoodMartTestCase {
    private File file;

    public ResultComparatorTest(String name) {
        super(name);
        this.file = new File(name);
    }

    public ResultComparatorTest() {
    }

    public ResultComparatorTest(File file) {
        super(file.getName());
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Exception {
        DocumentBuilder db = XMLUtility.createDomParser(false, true, false, new XMLUtility.UtilityErrorHandler());
        Document doc = db.parse(this.file);
        Element queryNode = (Element)doc.getElementsByTagName("mdxQuery").item(0);
        Element expectedResult = (Element)doc.getElementsByTagName("dataResult").item(0);
        if (!this.isDefaultNullMemberRepresentation() && this.resultHasDefaultNullMemberRepresentation(expectedResult)) {
            return;
        }
        String queryString = XMLUtility.decodeEncodedString(queryNode.getFirstChild().getNodeValue());
        Connection cxn = this.getConnection();
        try {
            Query query = cxn.parseQuery(queryString);
            Result result = cxn.execute(query);
            ResultComparator comp = new ResultComparator(expectedResult, result);
            comp.compareResults();
        }
        finally {
            cxn.close();
        }
    }

    private boolean resultHasDefaultNullMemberRepresentation(Element expectedResult) {
        return XMLUtility.toString(expectedResult).indexOf("#null") != -1;
    }

    public static TestSuite suite() {
        Pattern pattern;
        TestSuite suite = new TestSuite();
        MondrianProperties properties = MondrianProperties.instance();
        String filePattern = properties.QueryFilePattern.get();
        String fileDirectory = properties.QueryFileDirectory.get();
        String directory = fileDirectory == null ? "testsrc" + File.separatorChar + "queryFiles" : fileDirectory;
        File[] files = new File(directory).listFiles(new FilenameFilter(pattern = filePattern == null ? null : Pattern.compile(filePattern)){
            final /* synthetic */ Pattern val$pattern;
            {
                this.val$pattern = pattern;
            }

            public boolean accept(File dir, String name) {
                if (name.startsWith("query") && name.endsWith(".xml")) {
                    if (this.val$pattern == null) {
                        return true;
                    }
                    return this.val$pattern.matcher(name).matches();
                }
                return false;
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        for (int idx = 0; idx < files.length; ++idx) {
            suite.addTest((Test)new ResultComparatorTest(files[idx]));
        }
        return suite;
    }
}

