/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import junit.framework.TestCase;
import mondrian.olap.Util;
import mondrian.test.DelegatingTestContext;
import mondrian.test.TestContext;

public class SteelWheelsTestCase
extends TestCase {
    protected static final String nl = Util.nl;

    public SteelWheelsTestCase(String name) {
        super(name);
    }

    public SteelWheelsTestCase() {
    }

    public TestContext getTestContext() {
        return new DelegatingTestContext(TestContext.instance()){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList propertyList = Util.parseConnectString(1.getDefaultConnectString());
                propertyList.put("Jdbc", Util.replace(propertyList.get("Jdbc"), "/foodmart", "/steelwheels"));
                propertyList.put("Catalog", Util.replace(propertyList.get("Catalog"), "FoodMart.xml", "SteelWheels.mondrian.xml"));
                return propertyList;
            }

            public String getDefaultCubeName() {
                return "SteelWheelsSales";
            }
        };
    }

    public void testMeasures() {
        TestContext testContext = this.getTestContext();
        if (!testContext.databaseIsValid()) {
            return;
        }
        testContext.assertAxisReturns("Measures.Members", TestContext.fold("[Measures].[Quantity]\n[Measures].[Sales]"));
    }

    public void testMarkets() {
        TestContext testContext = this.getTestContext();
        if (!testContext.databaseIsValid()) {
            return;
        }
        testContext.assertQueryReturns("select [Markets].[All Markets].[Japan] on 0 from [SteelWheelsSales]", TestContext.fold("Axis #0:\n{}\nAxis #1:\n{[Markets].[All Markets].[Japan]}\nRow #0: 4,923\n"));
        testContext.assertQueryReturns("select [Markets].Children on 0 from [SteelWheelsSales]", TestContext.fold("Axis #0:\n{}\nAxis #1:\n{[Markets].[All Markets].[#null]}\n{[Markets].[All Markets].[APAC]}\n{[Markets].[All Markets].[EMEA]}\n{[Markets].[All Markets].[Japan]}\n{[Markets].[All Markets].[NA]}\nRow #0: \nRow #0: 12,878\nRow #0: 49,578\nRow #0: 4,923\nRow #0: 37,952\n"));
        testContext.assertQueryReturns("select Subset([Markets].Members, 130, 8) on 0 from [SteelWheelsSales]", TestContext.fold("Axis #0:\n{}\nAxis #1:\n{[Markets].[All Markets].[EMEA].[UK].[Isle of Wight].[Cowes]}\n{[Markets].[All Markets].[Japan]}\n{[Markets].[All Markets].[Japan].[Hong Kong]}\n{[Markets].[All Markets].[Japan].[Hong Kong].[#null]}\n{[Markets].[All Markets].[Japan].[Hong Kong].[#null].[Central Hong Kong]}\n{[Markets].[All Markets].[Japan].[Japan]}\n{[Markets].[All Markets].[Japan].[Japan].[Osaka]}\n{[Markets].[All Markets].[Japan].[Japan].[Osaka].[Osaka]}\nRow #0: 895\nRow #0: 4,923\nRow #0: 596\nRow #0: 58,396\nRow #0: 596\nRow #0: 1,842\nRow #0: 692\nRow #0: 692\n"));
        testContext.assertQueryReturns("select [Markets].[Territory].Members on 0 from [SteelWheelsSales]", TestContext.fold("Axis #0:\n{}\nAxis #1:\n{[Markets].[All Markets].[#null]}\n{[Markets].[All Markets].[APAC]}\n{[Markets].[All Markets].[EMEA]}\n{[Markets].[All Markets].[Japan]}\n{[Markets].[All Markets].[NA]}\nRow #0: \nRow #0: 12,878\nRow #0: 49,578\nRow #0: 4,923\nRow #0: 37,952\n"));
    }
}

