/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import junit.framework.TestCase;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.MondrianException;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionPool;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapUtil;
import mondrian.spi.Dialect;
import mondrian.test.TestContext;
import mondrian.util.Pair;

public class RolapConnectionTest
extends TestCase {
    private static final ThreadLocal<InitialContext> THREAD_INITIAL_CONTEXT = new ThreadLocal();

    public RolapConnectionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!NamingManager.hasInitialContextFactoryBuilder()) {
            NamingManager.setInitialContextFactoryBuilder(new InitialContextFactoryBuilder(){

                @Override
                public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
                    return new InitialContextFactory(){

                        @Override
                        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
                            return (Context)THREAD_INITIAL_CONTEXT.get();
                        }
                    };
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPooledConnectionWithProperties() throws SQLException {
        Util.PropertyList properties = TestContext.instance().getFoodMartConnectionProperties();
        String jdbc = properties.get("Jdbc");
        if (jdbc != null && !jdbc.startsWith("jdbc:odbc:")) {
            return;
        }
        properties.put("jdbc.charSet", "UTF-16");
        StringBuilder buf = new StringBuilder();
        DataSource dataSource = RolapConnection.createDataSource(null, properties, buf);
        String desc = buf.toString();
        RolapConnectionTest.assertTrue((boolean)desc.startsWith("Jdbc="));
        try {
            java.sql.Connection connection = dataSource.getConnection();
            connection.close();
            RolapConnectionTest.fail((String)"Expected exception");
        }
        catch (SQLException e) {
            if (e.getClass().getName().equals("org.apache.commons.dbcp.DbcpException")) {
            } else if (e.getClass() == SQLException.class && e.getCause() == null && e.getMessage() != null && e.getMessage().equals("")) {
            } else {
                RolapConnectionTest.fail((String)("Expected exception, but got a different one: " + e));
            }
        }
        catch (IllegalArgumentException e) {
            this.handleIllegalArgumentException(properties, e);
        }
        finally {
            RolapConnectionPool.instance().clearPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonPooledConnectionWithProperties() {
        Util.PropertyList properties = TestContext.instance().getFoodMartConnectionProperties();
        String jdbc = properties.get("Jdbc");
        if (jdbc != null && !jdbc.startsWith("jdbc:odbc:")) {
            return;
        }
        properties.put("jdbc.charSet", "UTF-16");
        properties.put(RolapConnectionProperties.PoolNeeded.name(), "false");
        StringBuilder buf = new StringBuilder();
        DataSource dataSource = RolapConnection.createDataSource(null, properties, buf);
        String desc = buf.toString();
        RolapConnectionTest.assertTrue((boolean)desc.startsWith("Jdbc="));
        java.sql.Connection connection = null;
        try {
            connection = dataSource.getConnection();
            RolapConnectionTest.fail((String)"Expected exception");
        }
        catch (SQLException se) {
        }
        catch (IllegalArgumentException e) {
            this.handleIllegalArgumentException(properties, e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private void handleIllegalArgumentException(Util.PropertyList properties, IllegalArgumentException e) {
        if (System.getProperties().getProperty("java.version").startsWith("1.6.")) {
            properties.remove("jdbc.charSet");
            StringBuilder buf = new StringBuilder();
            DataSource dataSource = RolapConnection.createDataSource(null, properties, buf);
            String desc = buf.toString();
            RolapConnectionTest.assertTrue((boolean)desc.startsWith("Jdbc="));
            try {
                java.sql.Connection connection1 = dataSource.getConnection();
                connection1.close();
            }
            catch (SQLException e1) {}
        } else {
            RolapConnectionTest.fail((String)("Expect IllegalArgumentException only in JDK 1.6, got " + e));
        }
    }

    public void testFormatLocale() {
        String expr = "FORMAT(1234.56, \"#,##.#\")";
        RolapConnectionTest.checkLocale("es_ES", expr, "1.234,6", false);
        RolapConnectionTest.checkLocale("es_MX", expr, "1,234.6", false);
        RolapConnectionTest.checkLocale("en_US", expr, "1,234.6", false);
    }

    public void testFormatStringLocale() {
        RolapConnectionTest.checkLocale("es_ES", "1234.56", "1.234,6", true);
        RolapConnectionTest.checkLocale("es_MX", "1234.56", "1,234.6", true);
        RolapConnectionTest.checkLocale("en_US", "1234.56", "1,234.6", true);
    }

    private static void checkLocale(final String localeName, String expr, String expected, boolean isQuery) {
        TestContext testContextSpain = new TestContext(){

            public Connection getConnection() {
                Util.PropertyList properties = Util.parseConnectString(this.getConnectString());
                properties.put(RolapConnectionProperties.Locale.name(), localeName);
                return DriverManager.getConnection(properties, null);
            }
        };
        if (isQuery) {
            String query = "WITH MEMBER [Measures].[Foo] AS '" + expr + "',\n" + " FORMAT_STRING = '#,##.#' \n" + "SELECT {[MEasures].[Foo]} ON COLUMNS FROM [Sales]";
            String expected2 = TestContext.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: " + expected + "\n");
            testContextSpain.assertQueryReturns(query, expected2);
        } else {
            testContextSpain.assertExprReturns(expr, expected);
        }
    }

    public void testConnectSansCatalogFails() {
        Util.PropertyList properties = TestContext.instance().getFoodMartConnectionProperties();
        properties.remove(RolapConnectionProperties.Catalog.name());
        properties.remove(RolapConnectionProperties.CatalogContent.name());
        if (RolapUtil.SQL_LOGGER.isDebugEnabled()) {
            RolapUtil.SQL_LOGGER.debug((Object)(this.getName() + "\n  [Connection Properties | " + properties + "]\n"));
        } else {
            System.out.println(properties);
        }
        try {
            DriverManager.getConnection(properties, null);
            RolapConnectionTest.fail((String)"expected exception");
        }
        catch (MondrianException e) {
            RolapConnectionTest.assertTrue((e.getMessage().indexOf("Connect string must contain property 'Catalog' or property 'CatalogContent'") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testJndiConnection() throws NamingException {
        Util.PropertyList properties = TestContext.instance().getFoodMartConnectionProperties();
        StringBuilder buf = new StringBuilder();
        final DataSource dataSource = RolapConnection.createDataSource(null, properties, buf);
        String desc = buf.toString();
        RolapConnectionTest.assertTrue((String)desc, (boolean)desc.startsWith("Jdbc="));
        final ArrayList lookupCalls = new ArrayList();
        THREAD_INITIAL_CONTEXT.set(new InitialContext(){

            public Object lookup(String str) {
                lookupCalls.add("Called");
                return dataSource;
            }
        });
        Util.PropertyList properties2 = TestContext.instance().getFoodMartConnectionProperties();
        properties2.remove(RolapConnectionProperties.Jdbc.name());
        properties2.remove(RolapConnectionProperties.JdbcUser.name());
        properties2.remove(RolapConnectionProperties.JdbcPassword.name());
        properties2.put(RolapConnectionProperties.DataSource.name(), "jnditest");
        DriverManager.getConnection(properties2, null);
        RolapConnectionTest.assertTrue((lookupCalls.size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void testDataSourceOverrideUserPass() throws SQLException, NamingException {
        properties = TestContext.instance().getFoodMartConnectionProperties();
        dialect = TestContext.instance().getDialect();
        if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ACCESS) {
            return;
        }
        jdbcUser = properties.get(RolapConnectionProperties.JdbcUser.name());
        jdbcPassword = properties.get(RolapConnectionProperties.JdbcPassword.name());
        if (jdbcUser == null || jdbcPassword == null) {
            return;
        }
        properties.put(RolapConnectionProperties.JdbcUser.name(), "bogususer");
        properties.put(RolapConnectionProperties.JdbcPassword.name(), "boguspassword");
        properties.put(RolapConnectionProperties.PoolNeeded.name(), "false");
        buf = new StringBuilder();
        dataSource = RolapConnection.createDataSource(null, properties, buf);
        desc = buf.toString();
        RolapConnectionTest.assertTrue((String)desc, (boolean)desc.startsWith("Jdbc="));
        RolapConnectionTest.assertTrue((String)desc, (boolean)(desc.indexOf("JdbcUser=bogususer; JdbcPassword=boguspassword") >= 0));
        jndiName = "jndiDataSource";
        RolapConnectionTest.THREAD_INITIAL_CONTEXT.set(new InitialContext(){

            public Object lookup(String str) {
                return str.equals("jndiDataSource") ? dataSource : null;
            }
        });
        properties2 = new Util.PropertyList();
        for (Pair<String, String> entry : properties) {
            properties2.put(entry.getKey(), entry.getValue());
        }
        properties2.remove(RolapConnectionProperties.Jdbc.name());
        properties2.put(RolapConnectionProperties.DataSource.name(), "jndiDataSource");
        properties2.put(RolapConnectionProperties.JdbcUser.name(), jdbcUser);
        properties2.put(RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
        connection = null;
        try {
            connection = DriverManager.getConnection(properties2, null);
            query = connection.parseQuery("select from [Sales]");
            result = connection.execute(query);
            RolapConnectionTest.assertNotNull((Object)result);
        }
        finally {
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
        properties2.remove(RolapConnectionProperties.JdbcUser.name());
        properties2.remove(RolapConnectionProperties.JdbcPassword.name());
lbl52:
        // 9 sources

        block15: for (String poolNeeded : Arrays.asList(new String[]{"false", "true"})) {
            properties2.put(RolapConnectionProperties.PoolNeeded.name(), poolNeeded);
            try {
                connection = DriverManager.getConnection(properties2, null);
                RolapConnectionTest.fail((String)"Expected exception");
            }
            catch (MondrianException e) {
                s = TestContext.getStackTrace(e);
                RolapConnectionTest.assertTrue((String)s, (boolean)(s.indexOf("Error while creating SQL connection: DataSource=jndiDataSource") >= 0));
                switch (5.$SwitchMap$mondrian$spi$Dialect$DatabaseProduct[dialect.getDatabaseProduct().ordinal()]) {
                    case 1: {
                        RolapConnectionTest.assertTrue((String)s, (boolean)(s.indexOf("Caused by: java.sql.SQLException: Schema 'BOGUSUSER' does not exist") >= 0));
                        ** break;
                    }
                    case 2: {
                        RolapConnectionTest.assertTrue((String)s, (boolean)(s.indexOf("Caused by: java.sql.SQLException: ORA-01017: invalid username/password; logon denied") >= 0));
                        ** break;
                    }
                    case 3: {
                        RolapConnectionTest.assertTrue((String)s, (boolean)(s.indexOf("Caused by: java.sql.SQLException: Access denied for user 'bogususer'@'localhost' (using password: YES)") >= 0));
                        ** break;
                    }
                    case 4: {
                        RolapConnectionTest.assertTrue((String)s, (boolean)(s.indexOf("Caused by: org.postgresql.util.PSQLException: FATAL: password authentication failed for user \"bogususer\"") >= 0));
                        continue block15;
                    }
                    ** default:
lbl76:
                    // 1 sources

                    continue block15;
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
                connection = null;
            }
        }
    }

    static class 5 {
        static final /* synthetic */ int[] $SwitchMap$mondrian$spi$Dialect$DatabaseProduct;

        static {
            $SwitchMap$mondrian$spi$Dialect$DatabaseProduct = new int[Dialect.DatabaseProduct.values().length];
            try {
                5.$SwitchMap$mondrian$spi$Dialect$DatabaseProduct[Dialect.DatabaseProduct.DERBY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$mondrian$spi$Dialect$DatabaseProduct[Dialect.DatabaseProduct.ORACLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$mondrian$spi$Dialect$DatabaseProduct[Dialect.DatabaseProduct.MYSQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$mondrian$spi$Dialect$DatabaseProduct[Dialect.DatabaseProduct.POSTGRESQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

